/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.pulsar.common.policies.data.ClusterPolicies;

@ApiModel(value="ClusterPolicies", description="The local cluster policies for a cluster")
public final class ClusterPoliciesImpl
implements ClusterPolicies,
Cloneable {
    @ApiModelProperty(name="migrated", value="flag to check if cluster is migrated to different cluster", example="true/false")
    private boolean migrated;
    @ApiModelProperty(name="migratedClusterUrl", value="url of cluster where current cluster is migrated")
    private ClusterPolicies.ClusterUrl migratedClusterUrl;

    public static ClusterPoliciesImplBuilder builder() {
        return new ClusterPoliciesImplBuilder();
    }

    public ClusterPoliciesImplBuilder clone() {
        return ClusterPoliciesImpl.builder().migrated(this.migrated).migratedClusterUrl(this.migratedClusterUrl);
    }

    public boolean isMigrated() {
        return this.migrated;
    }

    public ClusterPolicies.ClusterUrl getMigratedClusterUrl() {
        return this.migratedClusterUrl;
    }

    public void setMigrated(boolean migrated) {
        this.migrated = migrated;
    }

    public void setMigratedClusterUrl(ClusterPolicies.ClusterUrl migratedClusterUrl) {
        this.migratedClusterUrl = migratedClusterUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterPoliciesImpl)) {
            return false;
        }
        ClusterPoliciesImpl other = (ClusterPoliciesImpl)o;
        if (this.isMigrated() != other.isMigrated()) {
            return false;
        }
        ClusterPolicies.ClusterUrl this$migratedClusterUrl = this.getMigratedClusterUrl();
        ClusterPolicies.ClusterUrl other$migratedClusterUrl = other.getMigratedClusterUrl();
        return !(this$migratedClusterUrl == null ? other$migratedClusterUrl != null : !this$migratedClusterUrl.equals(other$migratedClusterUrl));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMigrated() ? 79 : 97);
        ClusterPolicies.ClusterUrl $migratedClusterUrl = this.getMigratedClusterUrl();
        result = result * 59 + ($migratedClusterUrl == null ? 43 : $migratedClusterUrl.hashCode());
        return result;
    }

    public String toString() {
        return "ClusterPoliciesImpl(migrated=" + this.isMigrated() + ", migratedClusterUrl=" + this.getMigratedClusterUrl() + ")";
    }

    public ClusterPoliciesImpl(boolean migrated, ClusterPolicies.ClusterUrl migratedClusterUrl) {
        this.migrated = migrated;
        this.migratedClusterUrl = migratedClusterUrl;
    }

    public ClusterPoliciesImpl() {
    }

    public static class ClusterPoliciesImplBuilder
    implements ClusterPolicies.Builder {
        private boolean migrated;
        private ClusterPolicies.ClusterUrl migratedClusterUrl;

        ClusterPoliciesImplBuilder() {
        }

        public ClusterPoliciesImplBuilder migrated(boolean migrated) {
            this.migrated = migrated;
            return this;
        }

        public ClusterPoliciesImplBuilder migratedClusterUrl(ClusterPolicies.ClusterUrl migratedClusterUrl) {
            this.migratedClusterUrl = migratedClusterUrl;
            return this;
        }

        public ClusterPoliciesImpl build() {
            return new ClusterPoliciesImpl(this.migrated, this.migratedClusterUrl);
        }

        public boolean isMigrated() {
            return this.migrated;
        }

        public ClusterPolicies.ClusterUrl getMigratedClusterUrl() {
            return this.migratedClusterUrl;
        }

        public void setMigrated(boolean migrated) {
            this.migrated = migrated;
        }

        public void setMigratedClusterUrl(ClusterPolicies.ClusterUrl migratedClusterUrl) {
            this.migratedClusterUrl = migratedClusterUrl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClusterPoliciesImplBuilder)) {
                return false;
            }
            ClusterPoliciesImplBuilder other = (ClusterPoliciesImplBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isMigrated() != other.isMigrated()) {
                return false;
            }
            ClusterPolicies.ClusterUrl this$migratedClusterUrl = this.getMigratedClusterUrl();
            ClusterPolicies.ClusterUrl other$migratedClusterUrl = other.getMigratedClusterUrl();
            return !(this$migratedClusterUrl == null ? other$migratedClusterUrl != null : !this$migratedClusterUrl.equals(other$migratedClusterUrl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ClusterPoliciesImplBuilder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isMigrated() ? 79 : 97);
            ClusterPolicies.ClusterUrl $migratedClusterUrl = this.getMigratedClusterUrl();
            result = result * 59 + ($migratedClusterUrl == null ? 43 : $migratedClusterUrl.hashCode());
            return result;
        }

        public String toString() {
            return "ClusterPoliciesImpl.ClusterPoliciesImplBuilder(migrated=" + this.isMigrated() + ", migratedClusterUrl=" + this.getMigratedClusterUrl() + ")";
        }
    }
}

