/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.discovery.service.web;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.pulsar.discovery.service.web.RestException;
import org.apache.pulsar.discovery.service.web.ZookeeperCacheLoader;
import org.apache.pulsar.policies.data.loadbalancer.LoadReport;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZookeeperClientFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryServiceServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final AtomicInteger counter = new AtomicInteger();
    private ZookeeperCacheLoader zkCache;
    private static final Logger log = LoggerFactory.getLogger(DiscoveryServiceServlet.class);

    public void init(ServletConfig config) throws ServletException {
        log.info("Initializing DiscoveryServiceServlet resource");
        String zookeeperServers = config.getInitParameter("zookeeperServers");
        String zookeeperSessionTimeoutMsStr = config.getInitParameter("zookeeperSessionTimeoutMs");
        int zookeeperSessionTimeoutMs = zookeeperSessionTimeoutMsStr != null ? Integer.valueOf(zookeeperSessionTimeoutMsStr) : 30000;
        String zookeeperClientFactoryClassName = config.getInitParameter("zookeeperClientFactoryClass");
        if (zookeeperClientFactoryClassName == null) {
            zookeeperClientFactoryClassName = ZookeeperClientFactoryImpl.class.getName();
        }
        log.info("zookeeperServers={} zookeeperClientFactoryClass={}", (Object)zookeeperServers, (Object)zookeeperClientFactoryClassName);
        try {
            ZooKeeperClientFactory zkClientFactory = (ZooKeeperClientFactory)Class.forName(zookeeperClientFactoryClassName).newInstance();
            this.zkCache = new ZookeeperCacheLoader(zkClientFactory, zookeeperServers, zookeeperSessionTimeoutMs);
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.redirect(req, resp);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.redirect(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.redirect(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.redirect(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.redirect(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.redirect(req, resp);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.redirect(req, resp);
    }

    private void redirect(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            LoadReport broker = this.nextBroker();
            URI brokerURI = request.getScheme().equals("http") ? new URI(broker.getWebServiceUrl()) : new URI(broker.getWebServiceUrlTls());
            StringBuilder location = new StringBuilder();
            location.append(brokerURI.getScheme()).append("://").append(brokerURI.getHost()).append(':').append(brokerURI.getPort()).append(request.getRequestURI());
            if (request.getQueryString() != null) {
                location.append('?').append(request.getQueryString());
            }
            if (log.isDebugEnabled()) {
                log.info("Redirecting to {}", (Object)location);
            }
            response.setStatus(307);
            response.setHeader("Location", location.toString());
        }
        catch (URISyntaxException e) {
            log.warn("No broker found in zookeeper {}", (Object)e.getMessage(), (Object)e);
            throw new RestException(Response.Status.SERVICE_UNAVAILABLE, "Broker is not available");
        }
    }

    LoadReport nextBroker() {
        List<LoadReport> availableBrokers = this.zkCache.getAvailableBrokers();
        if (availableBrokers.isEmpty()) {
            throw new RestException(Response.Status.SERVICE_UNAVAILABLE, "No active broker is available");
        }
        int brokersCount = availableBrokers.size();
        int nextIdx = MathUtils.signSafeMod((long)this.counter.getAndIncrement(), (int)brokersCount);
        return availableBrokers.get(nextIdx);
    }
}

