/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.discovery.service.server;

import com.google.common.base.Preconditions;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.discovery.service.DiscoveryService;
import org.apache.pulsar.discovery.service.server.ServerManager;
import org.apache.pulsar.discovery.service.server.ServiceConfig;
import org.apache.pulsar.discovery.service.web.DiscoveryServiceServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class DiscoveryServiceStarter {
    private static final Logger log = LoggerFactory.getLogger(DiscoveryServiceStarter.class);

    public static void init(String configFile) throws Exception {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        Thread.setDefaultUncaughtExceptionHandler((thread, exception) -> log.error("Uncaught exception in thread {}: {}", new Object[]{thread.getName(), exception.getMessage(), exception}));
        ServiceConfig config = (ServiceConfig)PulsarConfigurationLoader.create((String)configFile, ServiceConfig.class);
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)config.getZookeeperServers()) ? 1 : 0) != 0, (Object)"zookeeperServers must be provided");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)config.getGlobalZookeeperServers()) ? 1 : 0) != 0, (Object)"global-zookeeperServers must be provided");
        final DiscoveryService discoveryService = new DiscoveryService(config);
        final ServerManager server = new ServerManager(config);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    discoveryService.close();
                    server.stop();
                }
                catch (Exception e) {
                    log.warn("server couldn't stop gracefully {}", (Object)e.getMessage(), (Object)e);
                }
            }
        });
        discoveryService.start();
        DiscoveryServiceStarter.startWebService(server, config);
    }

    protected static void startWebService(ServerManager server, ServiceConfig config) throws Exception {
        TreeMap<String, String> initParameters = new TreeMap<String, String>();
        initParameters.put("zookeeperServers", config.getZookeeperServers());
        server.addServlet("/*", DiscoveryServiceServlet.class, initParameters);
        server.start();
        log.info("Discovery service is started at {}", (Object)server.getServiceUri().toString());
    }

    public static void main(String[] args) {
        Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0, (Object)"Need to specify a configuration file");
        try {
            DiscoveryServiceStarter.init(args[0]);
        }
        catch (Exception e) {
            log.error("Failed to start discovery service.", (Throwable)e);
            Runtime.getRuntime().halt(1);
        }
    }
}

