/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.discovery.service;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.ssl.SslContext;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.discovery.service.DiscoveryService;
import org.apache.pulsar.discovery.service.ServerConnection;
import org.apache.pulsar.discovery.service.server.ServiceConfig;

public class ServiceChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String TLS_HANDLER = "tls";
    private final ServiceConfig serviceConfig;
    private final DiscoveryService discoveryService;
    private final SslContext sslCtx;

    public ServiceChannelInitializer(DiscoveryService discoveryService, ServiceConfig serviceConfig, boolean enableTLS) throws Exception {
        this.serviceConfig = serviceConfig;
        this.discoveryService = discoveryService;
        this.sslCtx = enableTLS ? SecurityUtility.createNettySslContextForServer((boolean)serviceConfig.isTlsAllowInsecureConnection(), (String)serviceConfig.getTlsTrustCertsFilePath(), (String)serviceConfig.getTlsCertificateFilePath(), (String)serviceConfig.getTlsKeyFilePath(), serviceConfig.getTlsCiphers(), serviceConfig.getTlsProtocols(), (boolean)serviceConfig.getTlsRequireTrustedClientCertOnConnect()) : null;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        if (this.sslCtx != null) {
            ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)this.sslCtx.newHandler(ch.alloc()));
        }
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(0x500000, 0, 4, 0, 4));
        ch.pipeline().addLast("handler", (ChannelHandler)new ServerConnection(this.discoveryService));
    }
}

