/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.discovery.service.web;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;
import org.apache.pulsar.zookeeper.LocalZooKeeperCache;
import org.apache.pulsar.zookeeper.LocalZooKeeperConnectionService;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperChildrenCache;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZooKeeperDataCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperCacheLoader
implements Closeable {
    private final ZooKeeperCache localZkCache;
    private final LocalZooKeeperConnectionService localZkConnectionSvc;
    private final ZooKeeperDataCache<LoadManagerReport> brokerInfo;
    private final ZooKeeperChildrenCache availableBrokersCache;
    private volatile List<LoadManagerReport> availableBrokers;
    private final OrderedScheduler orderedExecutor = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(8).name("pulsar-discovery-ordered-cache").build();
    public static final String LOADBALANCE_BROKERS_ROOT = "/loadbalance/brokers";
    private static final Logger log = LoggerFactory.getLogger(ZookeeperCacheLoader.class);

    public ZookeeperCacheLoader(ZooKeeperClientFactory zkClientFactory, String zookeeperServers, int zookeeperSessionTimeoutMs) throws Exception {
        this.localZkConnectionSvc = new LocalZooKeeperConnectionService(zkClientFactory, zookeeperServers, (long)zookeeperSessionTimeoutMs);
        this.localZkConnectionSvc.start(exitCode -> log.error("Shutting down ZK sessions: {}", (Object)exitCode));
        this.localZkCache = new LocalZooKeeperCache(this.localZkConnectionSvc.getLocalZooKeeper(), (int)TimeUnit.MILLISECONDS.toSeconds(zookeeperSessionTimeoutMs), (OrderedExecutor)this.orderedExecutor);
        this.localZkConnectionSvc.start(exitCode -> {
            try {
                this.localZkCache.getZooKeeper().close();
            }
            catch (InterruptedException e) {
                log.warn("Failed to shutdown ZooKeeper gracefully {}", (Object)e.getMessage(), (Object)e);
            }
        });
        this.brokerInfo = new ZooKeeperDataCache<LoadManagerReport>(this.localZkCache){

            public LoadManagerReport deserialize(String key, byte[] content) throws Exception {
                return (LoadManagerReport)ObjectMapperFactory.getThreadLocal().readValue(content, LoadManagerReport.class);
            }
        };
        this.availableBrokersCache = new ZooKeeperChildrenCache(this.getLocalZkCache(), LOADBALANCE_BROKERS_ROOT);
        this.availableBrokersCache.registerListener((path, brokerNodes, stat) -> {
            try {
                this.updateBrokerList((Set<String>)brokerNodes);
            }
            catch (Exception e) {
                log.warn("Error updating broker info after broker list changed.", (Throwable)e);
            }
        });
        this.updateBrokerList(this.availableBrokersCache.get());
    }

    public List<LoadManagerReport> getAvailableBrokers() {
        return this.availableBrokers;
    }

    public ZooKeeperCache getLocalZkCache() {
        return this.localZkCache;
    }

    @Override
    public void close() {
        this.orderedExecutor.shutdown();
    }

    private void updateBrokerList(Set<String> brokerNodes) throws Exception {
        ArrayList<LoadManagerReport> availableBrokers = new ArrayList<LoadManagerReport>(brokerNodes.size());
        for (String broker : brokerNodes) {
            availableBrokers.add((LoadManagerReport)this.brokerInfo.get("/loadbalance/brokers/" + broker).get());
        }
        this.availableBrokers = availableBrokers;
    }
}

