/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.discovery.service;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.ThreadFactory;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationService;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.broker.cache.ConfigurationCacheService;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.configuration.PulsarConfiguration;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.apache.pulsar.common.util.netty.EventLoopUtil;
import org.apache.pulsar.discovery.service.BrokerDiscoveryProvider;
import org.apache.pulsar.discovery.service.ServiceChannelInitializer;
import org.apache.pulsar.discovery.service.server.ServiceConfig;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.pulsar.zookeeper.ZookeeperClientFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryService
implements Closeable {
    private final ServiceConfig config;
    private final String serviceUrl;
    private final String serviceUrlTls;
    private ConfigurationCacheService configurationCacheService;
    private AuthenticationService authenticationService;
    private AuthorizationService authorizationService;
    private ZooKeeperClientFactory zkClientFactory = null;
    private BrokerDiscoveryProvider discoveryProvider;
    private final EventLoopGroup acceptorGroup;
    private final EventLoopGroup workerGroup;
    private final DefaultThreadFactory acceptorThreadFactory = new DefaultThreadFactory("pulsar-discovery-acceptor");
    private final DefaultThreadFactory workersThreadFactory = new DefaultThreadFactory("pulsar-discovery-io");
    private final int numThreads = Runtime.getRuntime().availableProcessors();
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryService.class);

    public DiscoveryService(ServiceConfig serviceConfig) {
        Preconditions.checkNotNull((Object)serviceConfig);
        this.config = serviceConfig;
        this.serviceUrl = this.serviceUrl();
        this.serviceUrlTls = this.serviceUrlTls();
        this.acceptorGroup = EventLoopUtil.newEventLoopGroup((int)1, (ThreadFactory)this.acceptorThreadFactory);
        this.workerGroup = EventLoopUtil.newEventLoopGroup((int)this.numThreads, (ThreadFactory)this.workersThreadFactory);
    }

    public void start() throws Exception {
        this.discoveryProvider = new BrokerDiscoveryProvider(this.config, this.getZooKeeperClientFactory());
        this.configurationCacheService = new ConfigurationCacheService((ZooKeeperCache)this.discoveryProvider.globalZkCache);
        ServiceConfiguration serviceConfiguration = PulsarConfigurationLoader.convertFrom((PulsarConfiguration)this.config);
        this.authenticationService = new AuthenticationService(serviceConfiguration);
        this.authorizationService = new AuthorizationService(serviceConfiguration, this.configurationCacheService);
        this.startServer();
    }

    public void startServer() throws Exception {
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PulsarByteBufAllocator.DEFAULT);
        bootstrap.group(this.acceptorGroup, this.workerGroup);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(1024, 16384, 0x100000));
        bootstrap.channel(EventLoopUtil.getServerSocketChannelClass((EventLoopGroup)this.workerGroup));
        EventLoopUtil.enableTriggeredMode((ServerBootstrap)bootstrap);
        bootstrap.childHandler((ChannelHandler)new ServiceChannelInitializer(this, this.config, false));
        Preconditions.checkArgument((this.config.getServicePort().isPresent() || this.config.getServicePortTls().isPresent() ? 1 : 0) != 0, (Object)"Either ServicePort or ServicePortTls should be configured.");
        if (this.config.getServicePort().isPresent()) {
            bootstrap.bind(this.config.getServicePort().get().intValue()).sync();
            LOG.info("Started Pulsar Discovery service on port {}", this.config.getServicePort());
        }
        if (this.config.getServicePortTls().isPresent()) {
            ServerBootstrap tlsBootstrap = bootstrap.clone();
            tlsBootstrap.childHandler((ChannelHandler)new ServiceChannelInitializer(this, this.config, true));
            tlsBootstrap.bind(this.config.getServicePortTls().get().intValue()).sync();
            LOG.info("Started Pulsar Discovery TLS service on port {}", (Object)this.config.getServicePortTls().get());
        }
    }

    public ZooKeeperClientFactory getZooKeeperClientFactory() {
        if (this.zkClientFactory == null) {
            this.zkClientFactory = new ZookeeperClientFactoryImpl();
        }
        return this.zkClientFactory;
    }

    public BrokerDiscoveryProvider getDiscoveryProvider() {
        return this.discoveryProvider;
    }

    @Override
    public void close() throws IOException {
        this.discoveryProvider.close();
        this.acceptorGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }

    public String host() {
        try {
            if (!this.config.isBindOnLocalhost()) {
                return InetAddress.getLocalHost().getHostName();
            }
            return "localhost";
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new IllegalStateException("failed to find host", e);
        }
    }

    public String serviceUrl() {
        if (this.config.getServicePort().isPresent()) {
            return "pulsar://" + this.host() + ":" + this.config.getServicePort().get();
        }
        return null;
    }

    public String serviceUrlTls() {
        if (this.config.getServicePortTls().isPresent()) {
            return "pulsar+ssl://" + this.host() + ":" + this.config.getServicePortTls().get();
        }
        return null;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getServiceUrlTls() {
        return this.serviceUrlTls;
    }

    public ServiceConfig getConfiguration() {
        return this.config;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    public ConfigurationCacheService getConfigurationCacheService() {
        return this.configurationCacheService;
    }

    public void setConfigurationCacheService(ConfigurationCacheService configurationCacheService) {
        this.configurationCacheService = configurationCacheService;
    }

    public EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }
}

