/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.discovery.service.server;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.pulsar.broker.authorization.PulsarAuthorizationProvider;
import org.apache.pulsar.common.configuration.PulsarConfiguration;

public class ServiceConfig
implements PulsarConfiguration {
    private String zookeeperServers;
    @Deprecated
    private String globalZookeeperServers;
    private String configurationStoreServers;
    private int zookeeperSessionTimeoutMs = 30000;
    private Optional<Integer> servicePort = Optional.ofNullable(5000);
    private Optional<Integer> servicePortTls = Optional.empty();
    private Optional<Integer> webServicePort = Optional.ofNullable(8080);
    private Optional<Integer> webServicePortTls = Optional.empty();
    private boolean bindOnLocalhost = false;
    private Set<String> superUserRoles = Sets.newTreeSet();
    private boolean authorizationAllowWildcardsMatching = false;
    private boolean authenticationEnabled = false;
    private Set<String> authenticationProviders = Sets.newTreeSet();
    private boolean authorizationEnabled = false;
    private String authorizationProvider = PulsarAuthorizationProvider.class.getName();
    @Deprecated
    private boolean tlsEnabled = false;
    private long tlsCertRefreshCheckDurationSec = 300L;
    private String tlsCertificateFilePath;
    private String tlsKeyFilePath;
    private String tlsTrustCertsFilePath = "";
    private boolean tlsAllowInsecureConnection = false;
    private Set<String> tlsProtocols = Sets.newTreeSet();
    private Set<String> tlsCiphers = Sets.newTreeSet();
    private boolean tlsRequireTrustedClientCertOnConnect = false;
    private Properties properties = new Properties();

    public String getZookeeperServers() {
        return this.zookeeperServers;
    }

    public void setZookeeperServers(String zookeeperServers) {
        this.zookeeperServers = zookeeperServers;
    }

    @Deprecated
    public String getGlobalZookeeperServers() {
        return this.globalZookeeperServers;
    }

    @Deprecated
    public void setGlobalZookeeperServers(String globalZookeeperServers) {
        this.globalZookeeperServers = globalZookeeperServers;
    }

    public String getConfigurationStoreServers() {
        return null == this.configurationStoreServers ? this.getGlobalZookeeperServers() : this.configurationStoreServers;
    }

    public void setConfigurationStoreServers(String configurationStoreServers) {
        this.configurationStoreServers = configurationStoreServers;
    }

    public int getZookeeperSessionTimeoutMs() {
        return this.zookeeperSessionTimeoutMs;
    }

    public void setZookeeperSessionTimeoutMs(int zookeeperSessionTimeoutMs) {
        this.zookeeperSessionTimeoutMs = zookeeperSessionTimeoutMs;
    }

    public Optional<Integer> getServicePort() {
        return this.servicePort;
    }

    public void setServicePort(Optional<Integer> servicePort) {
        this.servicePort = servicePort;
    }

    public Optional<Integer> getServicePortTls() {
        return this.servicePortTls;
    }

    public void setServicePortTls(Optional<Integer> servicePortTls) {
        this.servicePortTls = servicePortTls;
    }

    public Optional<Integer> getWebServicePort() {
        return this.webServicePort;
    }

    public void setWebServicePort(Optional<Integer> webServicePort) {
        this.webServicePort = webServicePort;
    }

    public Optional<Integer> getWebServicePortTls() {
        return this.webServicePortTls;
    }

    public void setWebServicePortTls(Optional<Integer> webServicePortTls) {
        this.webServicePortTls = webServicePortTls;
    }

    @Deprecated
    public boolean isTlsEnabled() {
        return this.tlsEnabled || this.webServicePortTls != null || this.servicePortTls != null;
    }

    @Deprecated
    public void setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
    }

    public String getTlsCertificateFilePath() {
        return this.tlsCertificateFilePath;
    }

    public void setTlsCertificateFilePath(String tlsCertificateFilePath) {
        this.tlsCertificateFilePath = tlsCertificateFilePath;
    }

    public String getTlsKeyFilePath() {
        return this.tlsKeyFilePath;
    }

    public void setTlsKeyFilePath(String tlsKeyFilePath) {
        this.tlsKeyFilePath = tlsKeyFilePath;
    }

    public String getTlsTrustCertsFilePath() {
        return this.tlsTrustCertsFilePath;
    }

    public void setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
    }

    public boolean isTlsAllowInsecureConnection() {
        return this.tlsAllowInsecureConnection;
    }

    public void setTlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
    }

    public boolean isBindOnLocalhost() {
        return this.bindOnLocalhost;
    }

    public void setBindOnLocalhost(boolean bindOnLocalhost) {
        this.bindOnLocalhost = bindOnLocalhost;
    }

    public boolean isAuthenticationEnabled() {
        return this.authenticationEnabled;
    }

    public void setAuthenticationEnabled(boolean authenticationEnabled) {
        this.authenticationEnabled = authenticationEnabled;
    }

    public Set<String> getAuthenticationProviders() {
        return this.authenticationProviders;
    }

    public void setAuthenticationProviders(Set<String> authenticationProviders) {
        this.authenticationProviders = authenticationProviders;
    }

    public boolean isAuthorizationEnabled() {
        return this.authorizationEnabled;
    }

    public void setAuthorizationEnabled(boolean authorizationEnabled) {
        this.authorizationEnabled = authorizationEnabled;
    }

    public String getAuthorizationProvider() {
        return this.authorizationProvider;
    }

    public void setAuthorizationProvider(String authorizationProvider) {
        this.authorizationProvider = authorizationProvider;
    }

    public Set<String> getSuperUserRoles() {
        return this.superUserRoles;
    }

    public void setSuperUserRoles(Set<String> superUserRoles) {
        this.superUserRoles = superUserRoles;
    }

    public boolean getAuthorizationAllowWildcardsMatching() {
        return this.authorizationAllowWildcardsMatching;
    }

    public void setAuthorizationAllowWildcardsMatching(boolean authorizationAllowWildcardsMatching) {
        this.authorizationAllowWildcardsMatching = authorizationAllowWildcardsMatching;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Set<String> getTlsProtocols() {
        return this.tlsProtocols;
    }

    public void setTlsProtocols(Set<String> tlsProtocols) {
        this.tlsProtocols = tlsProtocols;
    }

    public long getTlsCertRefreshCheckDurationSec() {
        return this.tlsCertRefreshCheckDurationSec;
    }

    public void setTlsCertRefreshCheckDurationSec(long tlsCertRefreshCheckDurationSec) {
        this.tlsCertRefreshCheckDurationSec = tlsCertRefreshCheckDurationSec;
    }

    public Set<String> getTlsCiphers() {
        return this.tlsCiphers;
    }

    public void setTlsCiphers(Set<String> tlsCiphers) {
        this.tlsCiphers = tlsCiphers;
    }

    public boolean getTlsRequireTrustedClientCertOnConnect() {
        return this.tlsRequireTrustedClientCertOnConnect;
    }

    public void setTlsRequireTrustedClientCertOnConnect(boolean tlsRequireTrustedClientCertOnConnect) {
        this.tlsRequireTrustedClientCertOnConnect = tlsRequireTrustedClientCertOnConnect;
    }
}

