/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.discovery.service;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.ssl.SslContext;
import org.apache.pulsar.common.util.NettySslContextBuilder;
import org.apache.pulsar.discovery.service.DiscoveryService;
import org.apache.pulsar.discovery.service.ServerConnection;
import org.apache.pulsar.discovery.service.server.ServiceConfig;

public class ServiceChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String TLS_HANDLER = "tls";
    private final DiscoveryService discoveryService;
    private final boolean enableTls;
    private final NettySslContextBuilder sslCtxRefresher;

    public ServiceChannelInitializer(DiscoveryService discoveryService, ServiceConfig serviceConfig, boolean e) throws Exception {
        this.discoveryService = discoveryService;
        this.enableTls = e;
        this.sslCtxRefresher = this.enableTls ? new NettySslContextBuilder(serviceConfig.isTlsAllowInsecureConnection(), serviceConfig.getTlsTrustCertsFilePath(), serviceConfig.getTlsCertificateFilePath(), serviceConfig.getTlsKeyFilePath(), serviceConfig.getTlsCiphers(), serviceConfig.getTlsProtocols(), serviceConfig.getTlsRequireTrustedClientCertOnConnect(), serviceConfig.getTlsCertRefreshCheckDurationSec()) : null;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        SslContext sslContext;
        if (this.sslCtxRefresher != null && this.enableTls && (sslContext = (SslContext)this.sslCtxRefresher.get()) != null) {
            ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)sslContext.newHandler(ch.alloc()));
        }
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(5253120, 0, 4, 0, 4));
        ch.pipeline().addLast("handler", (ChannelHandler)new ServerConnection(this.discoveryService));
    }
}

