/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.docs.tools;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(showDefaultValues=true, scope=CommandLine.ScopeType.INHERIT)
public class CmdGenerateDocs
implements Callable<Integer> {
    @CommandLine.Option(names={"-h", "--help"}, description={"Display help information"}, usageHelp=true)
    public boolean help;
    @CommandLine.Option(names={"-n", "--command-names"}, description={"List of command names"})
    private List<String> commandNames = new ArrayList<String>();
    private static final String name = "gen-doc";
    private final CommandLine commander = new CommandLine((Object)this);

    public CmdGenerateDocs(String cmdName) {
        this.commander.setCommandName(cmdName);
    }

    public CmdGenerateDocs addCommand(String name, Object command) {
        this.commander.addSubcommand(name, command);
        return this;
    }

    public boolean run(String[] args) {
        if (args == null) {
            args = new String[]{};
        }
        return this.commander.execute(args) == 0;
    }

    private static String getCommandDescription(CommandLine commandLine) {
        String[] description = commandLine.getCommandSpec().usageMessage().description();
        if (description != null && description.length != 0) {
            return description[0];
        }
        return "";
    }

    private static String getArgDescription(CommandLine.Model.ArgSpec argSpec) {
        String[] description = argSpec.description();
        if (description != null && description.length != 0) {
            return description[0];
        }
        return "";
    }

    private String generateDocument(String module, CommandLine commander) {
        StringBuilder sb = new StringBuilder();
        sb.append("# ").append(module).append("\n\n");
        String desc = CmdGenerateDocs.getCommandDescription(commander);
        if (null != desc && !desc.isEmpty()) {
            sb.append(desc).append("\n");
        }
        sb.append("\n\n```shell\n").append("$ ");
        String commandName = commander.getCommandName();
        sb.append(this.commander.getCommandName() + " " + commandName);
        if (!commander.getSubcommands().isEmpty()) {
            sb.append(" subcommand").append("\n```").append("\n\n");
            commander.getSubcommands().forEach((subK, subV) -> {
                if (!subK.equals(name)) {
                    sb.append("\n\n## ").append((String)subK).append("\n\n");
                    String subDesc = CmdGenerateDocs.getCommandDescription(subV);
                    if (null != subDesc && !subDesc.isEmpty()) {
                        sb.append(subDesc).append("\n");
                    }
                    sb.append("```shell\n$ ");
                    sb.append(this.commander.getCommandName()).append(" ");
                    sb.append(module).append(" ").append((String)subK).append(" options").append("\n```\n\n");
                    List argSpecs = subV.getCommandSpec().args();
                    if (argSpecs.size() > 0) {
                        sb.append("|Flag|Description|Default|\n");
                        sb.append("|---|---|---|\n");
                    }
                    argSpecs.forEach(option -> {
                        if (option.hidden() || !(option instanceof CommandLine.Model.OptionSpec)) {
                            return;
                        }
                        sb.append("| `").append(String.join((CharSequence)", ", ((CommandLine.Model.OptionSpec)option).names())).append("` | ").append(CmdGenerateDocs.getArgDescription(option).replace("\n", " ")).append("|").append(option.defaultValueString()).append("|\n");
                    });
                }
            });
        } else {
            sb.append(" options").append("\n```").append("\n\n");
            sb.append("|Flag|Description|Default|\n");
            sb.append("|---|---|---|\n");
            List argSpecs = commander.getCommandSpec().args();
            argSpecs.forEach(option -> {
                if (option.hidden() || !(option instanceof CommandLine.Model.OptionSpec)) {
                    return;
                }
                sb.append("| `").append(String.join((CharSequence)", ", ((CommandLine.Model.OptionSpec)option).names())).append("` | ").append(CmdGenerateDocs.getArgDescription(option).replace("\n", " ")).append("|").append(option.defaultValueString()).append("|\n");
            });
        }
        return sb.toString();
    }

    @Override
    public Integer call() throws Exception {
        if (this.commandNames.size() == 0) {
            this.commander.getSubcommands().forEach((name, cmd) -> this.commander.getOut().println(this.generateDocument((String)name, (CommandLine)cmd)));
        } else {
            for (String commandName : this.commandNames) {
                CommandLine cmd2;
                if (commandName.equals(name) || (cmd2 = (CommandLine)this.commander.getSubcommands().get(commandName)) == null) continue;
                this.commander.getOut().println(this.generateDocument(commandName, cmd2));
            }
        }
        return 0;
    }

    @VisibleForTesting
    CommandLine getCommander() {
        return this.commander;
    }

    public boolean isHelp() {
        return this.help;
    }

    public List<String> getCommandNames() {
        return this.commandNames;
    }

    public void setHelp(boolean help) {
        this.help = help;
    }

    public void setCommandNames(List<String> commandNames) {
        this.commandNames = commandNames;
    }
}

