/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.api.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.pulsar.functions.api.SerDe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSerDe
implements SerDe<Object> {
    private static final Logger log = LoggerFactory.getLogger(JavaSerDe.class);
    private static final JavaSerDe INSTANCE = new JavaSerDe();

    public static JavaSerDe of() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] serialize(Object resultValue) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(bos);
            out.writeObject(resultValue);
            out.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            log.info("Exception during serialization", (Throwable)ex);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object deserialize(byte[] data) {
        Object obj = null;
        ByteArrayInputStream bis = null;
        ObjectInputStream ois = null;
        try {
            bis = new ByteArrayInputStream(data);
            ois = new ObjectInputStream(bis);
            obj = ois.readObject();
        }
        catch (Exception ex) {
            log.info("Exception during deserialization", (Throwable)ex);
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException iOException) {}
        }
        return obj;
    }
}

