/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.windowing.triggers;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.ThreadContext;
import org.apache.pulsar.functions.api.Context;
import org.apache.pulsar.functions.windowing.DefaultEvictionContext;
import org.apache.pulsar.functions.windowing.Event;
import org.apache.pulsar.functions.windowing.EvictionPolicy;
import org.apache.pulsar.functions.windowing.TriggerHandler;
import org.apache.pulsar.functions.windowing.TriggerPolicy;
import org.apache.pulsar.functions.windowing.WindowUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeTriggerPolicy<T>
implements TriggerPolicy<T, Void> {
    private static final Logger log = LoggerFactory.getLogger(TimeTriggerPolicy.class);
    private long duration;
    private final TriggerHandler handler;
    private final EvictionPolicy<T, ?> evictionPolicy;
    private ScheduledFuture<?> executorFuture;
    private final ScheduledExecutorService executor;
    private Context context;

    public TimeTriggerPolicy(long millis, TriggerHandler handler, EvictionPolicy<T, ?> evictionPolicy, Context context) {
        this.duration = millis;
        this.handler = handler;
        this.evictionPolicy = evictionPolicy;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("time-trigger-policy-%d").setDaemon(true).build();
        this.executor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.context = context;
    }

    @Override
    public void track(Event<T> event) {
        this.checkFailures();
    }

    @Override
    public void reset() {
    }

    @Override
    public void start() {
        this.executorFuture = this.executor.scheduleAtFixedRate(this.newTriggerTask(), this.duration, this.duration, TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(2L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException ie) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public String toString() {
        return "TimeTriggerPolicy{duration=" + this.duration + '}';
    }

    private Runnable newTriggerTask() {
        return new Runnable(){

            @Override
            public void run() {
                ThreadContext.put((String)"function", (String)WindowUtils.getFullyQualifiedName(TimeTriggerPolicy.this.context.getTenant(), TimeTriggerPolicy.this.context.getNamespace(), TimeTriggerPolicy.this.context.getFunctionName()));
                long now = System.currentTimeMillis() - 1L;
                try {
                    TimeTriggerPolicy.this.evictionPolicy.setContext(new DefaultEvictionContext(now, null, null, TimeTriggerPolicy.this.duration));
                    TimeTriggerPolicy.this.handler.onTrigger();
                }
                catch (Throwable th) {
                    log.error("handler.onTrigger failed ", th);
                    throw th;
                }
            }
        };
    }

    private void checkFailures() {
        if (this.executorFuture != null && this.executorFuture.isDone()) {
            try {
                this.executorFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("Got exception in timer trigger policy ", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Void getState() {
        return null;
    }

    @Override
    public void restoreState(Void state) {
    }
}

