/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.windowing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.functions.windowing.Event;
import org.apache.pulsar.functions.windowing.EventImpl;
import org.apache.pulsar.functions.windowing.EvictionPolicy;
import org.apache.pulsar.functions.windowing.TriggerHandler;
import org.apache.pulsar.functions.windowing.TriggerPolicy;
import org.apache.pulsar.functions.windowing.WindowLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowManager<T>
implements TriggerHandler {
    private static final Logger log = LoggerFactory.getLogger(WindowManager.class);
    protected static final int EXPIRE_EVENTS_THRESHOLD = 100;
    protected final Collection<Event<T>> queue;
    protected EvictionPolicy<T, ?> evictionPolicy;
    protected TriggerPolicy<T, ?> triggerPolicy;
    protected final WindowLifecycleListener<Event<T>> windowLifecycleListener;
    private final List<Event<T>> expiredEvents;
    private final Set<Event<T>> prevWindowEvents;
    private final AtomicInteger eventsSinceLastExpiry;
    private final ReentrantLock lock;

    public WindowManager(WindowLifecycleListener<Event<T>> lifecycleListener, Collection<Event<T>> queue) {
        this.windowLifecycleListener = lifecycleListener;
        this.queue = queue;
        this.expiredEvents = new ArrayList<Event<T>>();
        this.prevWindowEvents = new HashSet<Event<T>>();
        this.eventsSinceLastExpiry = new AtomicInteger();
        this.lock = new ReentrantLock(true);
    }

    public void setEvictionPolicy(EvictionPolicy<T, ?> evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
    }

    public void setTriggerPolicy(TriggerPolicy<T, ?> triggerPolicy) {
        this.triggerPolicy = triggerPolicy;
    }

    public void add(T event, long ts, Record<?> record) {
        this.add(new EventImpl<T>(event, ts, record));
    }

    public void add(Event<T> windowEvent) {
        if (windowEvent.isWatermark()) {
            log.debug(String.format("Got watermark event with ts %d", windowEvent.getTimestamp()));
        } else {
            this.queue.add(windowEvent);
        }
        this.track(windowEvent);
        this.compactWindow();
    }

    @Override
    public boolean onTrigger() {
        List<Event<T>> windowEvents = null;
        ArrayList<Event<T>> expired = null;
        this.lock.lock();
        try {
            windowEvents = this.scanEvents(true);
            expired = new ArrayList<Event<T>>(this.expiredEvents);
            this.expiredEvents.clear();
        }
        finally {
            this.lock.unlock();
        }
        ArrayList<Event<T>> events = new ArrayList<Event<T>>();
        ArrayList<Event<T>> newEvents = new ArrayList<Event<T>>();
        for (Event<T> event : windowEvents) {
            events.add(event);
            if (this.prevWindowEvents.contains(event)) continue;
            newEvents.add(event);
        }
        this.prevWindowEvents.clear();
        if (!events.isEmpty()) {
            this.prevWindowEvents.addAll(windowEvents);
            log.debug(String.format("invoking windowLifecycleListener onActivation, [%d] events in window.", events.size()));
            this.windowLifecycleListener.onActivation(events, newEvents, expired, this.evictionPolicy.getContext().getReferenceTime());
        } else {
            log.debug("No events in the window, skipping onActivation");
        }
        this.triggerPolicy.reset();
        return !events.isEmpty();
    }

    public void shutdown() {
        log.debug("Shutting down WindowManager");
        if (this.triggerPolicy != null) {
            this.triggerPolicy.shutdown();
        }
    }

    protected void compactWindow() {
        if (this.eventsSinceLastExpiry.incrementAndGet() >= 100) {
            this.scanEvents(false);
        }
    }

    private void track(Event<T> windowEvent) {
        this.evictionPolicy.track(windowEvent);
        this.triggerPolicy.track(windowEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event<T>> scanEvents(boolean fullScan) {
        log.debug("Scan events, eviction policy {}", this.evictionPolicy);
        ArrayList<Event<T>> eventsToExpire = new ArrayList<Event<T>>();
        ArrayList<Event<T>> eventsToProcess = new ArrayList<Event<T>>();
        this.lock.lock();
        try {
            Iterator<Event<T>> it = this.queue.iterator();
            while (it.hasNext()) {
                Event<T> windowEvent = it.next();
                EvictionPolicy.Action action = this.evictionPolicy.evict(windowEvent);
                if (action == EvictionPolicy.Action.EXPIRE) {
                    eventsToExpire.add(windowEvent);
                    it.remove();
                    continue;
                }
                if (!fullScan || action == EvictionPolicy.Action.STOP) break;
                if (action != EvictionPolicy.Action.PROCESS) continue;
                eventsToProcess.add(windowEvent);
            }
            this.expiredEvents.addAll(eventsToExpire);
        }
        finally {
            this.lock.unlock();
        }
        this.eventsSinceLastExpiry.set(0);
        log.debug(String.format("[%d] events expired from window.", eventsToExpire.size()));
        if (!eventsToExpire.isEmpty()) {
            log.debug("invoking windowLifecycleListener.onExpiry");
            this.windowLifecycleListener.onExpiry(eventsToExpire);
        }
        return eventsToProcess;
    }

    public long getEarliestEventTs(long startTs, long endTs) {
        long minTs = Long.MAX_VALUE;
        for (Event<T> event : this.queue) {
            if (event.getTimestamp() <= startTs || event.getTimestamp() > endTs) continue;
            minTs = Math.min(minTs, event.getTimestamp());
        }
        return minTs;
    }

    public int getEventCount(long referenceTime) {
        int count = 0;
        for (Event<T> event : this.queue) {
            if (event.getTimestamp() > referenceTime) continue;
            ++count;
        }
        return count;
    }

    public List<Long> getSlidingCountTimestamps(long startTs, long endTs, int slidingCount) {
        ArrayList<Long> timestamps = new ArrayList<Long>();
        if (endTs > startTs) {
            int count = 0;
            long ts = Long.MIN_VALUE;
            for (Event<T> event : this.queue) {
                if (event.getTimestamp() <= startTs || event.getTimestamp() > endTs) continue;
                ts = Math.max(ts, event.getTimestamp());
                if (++count % slidingCount != 0) continue;
                timestamps.add(ts);
            }
        }
        return timestamps;
    }

    public String toString() {
        return "WindowManager{evictionPolicy=" + this.evictionPolicy + ", triggerPolicy=" + this.triggerPolicy + '}';
    }
}

