/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.source;

import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.functions.source.PulsarSource;
import org.apache.pulsar.functions.source.PulsarSourceConfig;
import org.apache.pulsar.io.core.SourceContext;

public abstract class PushPulsarSource<T>
extends PulsarSource<T> {
    private LinkedBlockingQueue<Record<T>> queue = new LinkedBlockingQueue(this.getQueueLength());
    private static final int DEFAULT_QUEUE_LENGTH = 1000;

    public PushPulsarSource(PulsarClient pulsarClient, PulsarSourceConfig pulsarSourceConfig, Map<String, String> properties, ClassLoader functionClassLoader) {
        super(pulsarClient, pulsarSourceConfig, properties, functionClassLoader);
    }

    public Record<T> read() throws Exception {
        return this.queue.take();
    }

    public abstract void open(Map<String, Object> var1, SourceContext var2) throws Exception;

    public void consume(Record<T> record) {
        try {
            this.queue.put(record);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public int getQueueLength() {
        return 1000;
    }
}

