/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth.oauth2;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.auth.oauth2.Flow;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.DefaultMetadataResolver;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.Metadata;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.MetadataResolver;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class FlowBase
implements Flow {
    private static final Logger log = LoggerFactory.getLogger(FlowBase.class);
    private static final long serialVersionUID = 1L;
    protected final URL issuerUrl;
    protected transient Metadata metadata;

    protected FlowBase(URL issuerUrl) {
        this.issuerUrl = issuerUrl;
    }

    @Override
    public void initialize() throws PulsarClientException {
        try {
            this.metadata = this.createMetadataResolver().resolve();
        }
        catch (IOException e) {
            log.error("Unable to retrieve OAuth 2.0 server metadata", (Throwable)e);
            throw new PulsarClientException.AuthenticationException("Unable to retrieve OAuth 2.0 server metadata");
        }
    }

    protected MetadataResolver createMetadataResolver() {
        return DefaultMetadataResolver.fromIssuerUrl(this.issuerUrl);
    }

    static String parseParameterString(Map<String, String> params, String name) {
        String s = params.get(name);
        if (StringUtils.isEmpty(s)) {
            throw new IllegalArgumentException("Required configuration parameter: " + name);
        }
        return s;
    }

    static URL parseParameterUrl(Map<String, String> params, String name) {
        String s = params.get(name);
        if (StringUtils.isEmpty(s)) {
            throw new IllegalArgumentException("Required configuration parameter: " + name);
        }
        try {
            return new URL(s);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed configuration parameter: " + name);
        }
    }
}

