/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.nio.ByteBuffer;
import java.time.Instant;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;

public class InstantSchema
extends AbstractSchema<Instant> {
    private static final InstantSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;

    public static InstantSchema of() {
        return INSTANCE;
    }

    @Override
    public byte[] encode(Instant message) {
        if (null == message) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(12);
        buffer.putLong(message.getEpochSecond());
        buffer.putInt(message.getNano());
        return buffer.array();
    }

    @Override
    public Instant decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        long epochSecond = buffer.getLong();
        int nanos = buffer.getInt();
        return Instant.ofEpochSecond(epochSecond, nanos);
    }

    @Override
    public Instant decode(ByteBuf byteBuf) {
        if (null == byteBuf) {
            return null;
        }
        long epochSecond = byteBuf.readLong();
        int nanos = byteBuf.readInt();
        return Instant.ofEpochSecond(epochSecond, nanos);
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = SchemaInfoImpl.builder().name("Instant").type(SchemaType.INSTANT).schema(new byte[0]).build();
        INSTANCE = new InstantSchema();
    }
}

