/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.io.airlift.compress.zstd;

import java.util.Arrays;
import org.apache.pulsar.functions.runtime.shaded.io.airlift.compress.zstd.CompressionParameters;

class BlockCompressionState {
    public final int[] hashTable;
    public final int[] chainTable;
    private final long baseAddress;
    private int windowBaseOffset;

    public BlockCompressionState(CompressionParameters parameters, long baseAddress) {
        this.baseAddress = baseAddress;
        this.hashTable = new int[1 << parameters.getHashLog()];
        this.chainTable = new int[1 << parameters.getChainLog()];
    }

    public void reset() {
        Arrays.fill(this.hashTable, 0);
        Arrays.fill(this.chainTable, 0);
    }

    public void enforceMaxDistance(long inputLimit, int maxDistance) {
        int distance = (int)(inputLimit - this.baseAddress);
        int newOffset = distance - maxDistance;
        if (this.windowBaseOffset < newOffset) {
            this.windowBaseOffset = newOffset;
        }
    }

    public long getBaseAddress() {
        return this.baseAddress;
    }

    public int getWindowBaseOffset() {
        return this.windowBaseOffset;
    }
}

