/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.directentrylogger;

import java.io.IOException;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.EntryLogMetadata;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.directentrylogger.Header;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.directentrylogger.LogMetadata;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.storage.directentrylogger.LogWriter;

class WriterWithMetadata {
    private final LogWriter writer;
    private final EntryLogMetadata metadata;
    private final ByteBufAllocator allocator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WriterWithMetadata(LogWriter writer, EntryLogMetadata metadata, ByteBufAllocator allocator) throws IOException {
        this.writer = writer;
        this.metadata = metadata;
        this.allocator = allocator;
        ByteBuf buf = allocator.buffer(4096);
        try {
            Header.writeEmptyHeader(buf);
            writer.writeAt(0L, buf);
            writer.position(buf.capacity());
        }
        finally {
            buf.release();
        }
    }

    int logId() {
        return this.writer.logId();
    }

    boolean shouldRoll(ByteBuf entry, long rollThreshold) throws IOException {
        return this.writer.position() + (long)this.writer.serializedSize(entry) > rollThreshold;
    }

    long addEntry(long ledgerId, ByteBuf entry) throws IOException {
        int size = entry.readableBytes();
        this.metadata.addLedgerSize(ledgerId, size + 4);
        long offset = this.writer.writeDelimited(entry);
        Preconditions.checkState(offset < Integer.MAX_VALUE, "Offsets can't be higher than max int (%d)", offset);
        return (long)this.writer.logId() << 32 | offset;
    }

    void flush() throws IOException {
        this.writer.flush();
    }

    void finalizeAndClose() throws IOException {
        this.writer.flush();
        LogMetadata.write(this.writer, this.metadata, this.allocator);
        this.writer.close();
    }
}

