/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.pulsar.common.functions.FunctionDefinition;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.functions.runtime.thread.ThreadRuntimeFactory;
import org.apache.pulsar.functions.utils.functions.FunctionArchive;
import org.apache.pulsar.functions.utils.functions.FunctionUtils;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionsManager
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(FunctionsManager.class);
    private TreeMap<String, FunctionArchive> functions;

    @VisibleForTesting
    public FunctionsManager() {
        this.functions = new TreeMap();
    }

    public FunctionsManager(WorkerConfig workerConfig) throws IOException {
        this.functions = FunctionsManager.createFunctions(workerConfig);
    }

    public void addFunction(String functionType, FunctionArchive functionArchive) {
        this.functions.put(functionType, functionArchive);
    }

    public FunctionArchive getFunction(String functionType) {
        return this.functions.get(functionType);
    }

    public Path getFunctionArchive(String functionType) {
        return this.functions.get(functionType).getArchivePath();
    }

    public List<FunctionDefinition> getFunctionDefinitions() {
        return this.functions.values().stream().map(FunctionArchive::getFunctionDefinition).collect(Collectors.toList());
    }

    public void reloadFunctions(WorkerConfig workerConfig) throws IOException {
        TreeMap<String, FunctionArchive> oldFunctions = this.functions;
        this.functions = FunctionsManager.createFunctions(workerConfig);
        this.closeFunctions(oldFunctions);
    }

    private static TreeMap<String, FunctionArchive> createFunctions(WorkerConfig workerConfig) throws IOException {
        boolean enableClassloading = workerConfig.getEnableClassloadingOfBuiltinFiles() != false || ThreadRuntimeFactory.class.getName().equals(workerConfig.getFunctionRuntimeFactoryClassName());
        return FunctionUtils.searchForFunctions(workerConfig.getFunctionsDirectory(), workerConfig.getNarExtractionDirectory(), enableClassloading);
    }

    @Override
    public void close() {
        this.closeFunctions(this.functions);
    }

    private void closeFunctions(TreeMap<String, FunctionArchive> functionMap) {
        functionMap.values().forEach(functionArchive -> {
            try {
                functionArchive.close();
            }
            catch (Exception e) {
                log.warn("Failed to close function archive", (Throwable)e);
            }
        });
        functionMap.clear();
    }
}

