/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.conf;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.databind.ObjectMapper;

public final class ConfigurationDataUtils {
    private static final ObjectMapper MAPPER = ConfigurationDataUtils.create();

    public static ObjectMapper create() {
        ObjectMapper mapper = ObjectMapperFactory.create();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        mapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    private ConfigurationDataUtils() {
    }

    public static <T> T loadData(Map<String, Object> config, T existingData, Class<T> dataCls) {
        try {
            String existingConfigJson = MAPPER.writeValueAsString(existingData);
            Map existingConfig = MAPPER.readValue(existingConfigJson, Map.class);
            HashMap<String, Object> newConfig = new HashMap<String, Object>();
            newConfig.putAll(existingConfig);
            newConfig.putAll(config);
            String configJson = MAPPER.writeValueAsString(newConfig);
            return MAPPER.readValue(configJson, dataCls);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load config into existing configuration data", e);
        }
    }
}

