/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.writer;

import java.io.ByteArrayOutputStream;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.SchemaWriter;
import org.apache.pulsar.client.impl.schema.AvroSchema;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.functions.runtime.shaded.org.apache.avro.Schema;
import org.apache.pulsar.functions.runtime.shaded.org.apache.avro.io.BinaryEncoder;
import org.apache.pulsar.functions.runtime.shaded.org.apache.avro.io.EncoderFactory;
import org.apache.pulsar.functions.runtime.shaded.org.apache.avro.reflect.ReflectData;
import org.apache.pulsar.functions.runtime.shaded.org.apache.avro.reflect.ReflectDatumWriter;

public class AvroWriter<T>
implements SchemaWriter<T> {
    private final ReflectDatumWriter<T> writer;
    private final BinaryEncoder encoder;
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();

    public AvroWriter(Schema schema) {
        this(schema, false);
    }

    public AvroWriter(Schema schema, boolean jsr310ConversionEnabled) {
        this.encoder = EncoderFactory.get().binaryEncoder(this.byteArrayOutputStream, null);
        ReflectData reflectData = new ReflectData();
        AvroSchema.addLogicalTypeConversions(reflectData, jsr310ConversionEnabled);
        this.writer = new ReflectDatumWriter(schema, reflectData);
    }

    @VisibleForTesting
    public BinaryEncoder getEncoder() {
        return this.encoder;
    }

    @Override
    public synchronized byte[] write(T message) {
        byte[] outputBytes = null;
        try {
            this.writer.write(message, this.encoder);
        }
        catch (Exception e) {
            throw new SchemaSerializationException(e);
        }
        finally {
            try {
                this.encoder.flush();
                outputBytes = this.byteArrayOutputStream.toByteArray();
            }
            catch (Exception ex) {
                throw new SchemaSerializationException(ex);
            }
            this.byteArrayOutputStream.reset();
        }
        return outputBytes;
    }
}

