/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.impl.result;

import org.apache.pulsar.functions.runtime.shaded.io.netty.util.Recycler;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.ReferenceCountUtil;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.op.OpType;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.Code;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.api.kv.result.Result;

abstract class ResultImpl<K, V, T extends ResultImpl<K, V, T>>
implements Result<K, V> {
    protected final Recycler.Handle<T> handle;
    protected final OpType type;
    protected long revision;
    protected Code code;
    protected K pKey;

    protected ResultImpl(OpType type, Recycler.Handle<T> handle) {
        this.type = type;
        this.handle = handle;
    }

    abstract T asResult();

    public ResultImpl<K, V, T> pKey(K pKey) {
        ReferenceCountUtil.release(this.pKey);
        this.pKey = ReferenceCountUtil.retain(pKey);
        return this;
    }

    protected void reset() {
        this.code = null;
        this.revision = -1L;
        this.code = Code.UNEXPECTED;
        ReferenceCountUtil.release(this.pKey);
        this.pKey = null;
    }

    @Override
    public void close() {
        this.reset();
        this.handle.recycle(this.asResult());
    }

    public ResultImpl<K, V, T> revision(long revision) {
        this.revision = revision;
        return this;
    }

    public ResultImpl<K, V, T> code(Code code) {
        this.code = code;
        return this;
    }

    public Recycler.Handle<T> handle() {
        return this.handle;
    }

    @Override
    public OpType type() {
        return this.type;
    }

    @Override
    public long revision() {
        return this.revision;
    }

    @Override
    public Code code() {
        return this.code;
    }

    @Override
    public K pKey() {
        return this.pKey;
    }

    public String toString() {
        return "ResultImpl(type=" + (Object)((Object)this.type()) + ", revision=" + this.revision() + ", code=" + (Object)((Object)this.code()) + ", pKey=" + this.pKey() + ")";
    }
}

