/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client;

import java.io.InputStream;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBufInputStream;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.impl.LedgerEntryImpl;

public class LedgerEntry {
    final long ledgerId;
    final long entryId;
    final long length;
    ByteBuf data;

    LedgerEntry(LedgerEntryImpl entry) {
        this.ledgerId = entry.getLedgerId();
        this.entryId = entry.getEntryId();
        this.length = entry.getLength();
        this.data = entry.getEntryBuffer().retain();
    }

    public long getLedgerId() {
        return this.ledgerId;
    }

    public long getEntryId() {
        return this.entryId;
    }

    public long getLength() {
        return this.length;
    }

    public byte[] getEntry() {
        Preconditions.checkState(null != this.data, "entry content can be accessed only once");
        byte[] entry = new byte[this.data.readableBytes()];
        this.data.readBytes(entry);
        this.data.release();
        this.data = null;
        return entry;
    }

    public InputStream getEntryInputStream() {
        Preconditions.checkState(null != this.data, "entry content can be accessed only once");
        ByteBufInputStream res = new ByteBufInputStream(this.data);
        this.data = null;
        return res;
    }

    public ByteBuf getEntryBuffer() {
        Preconditions.checkState(null != this.data, "entry content has been retrieved by #getEntry or #getEntryInputStream");
        return this.data;
    }
}

