/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto;

import java.net.UnknownHostException;
import java.util.function.Supplier;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.discover.BookieServiceInfoUtils;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.net.BookieSocketAddress;

public class SimpleBookieServiceInfoProvider
implements Supplier<BookieServiceInfo> {
    private final BookieSocketAddress bookieSocketAddress;

    public SimpleBookieServiceInfoProvider(ServerConfiguration serverConfiguration) {
        try {
            this.bookieSocketAddress = BookieImpl.getBookieAddress(serverConfiguration);
        }
        catch (UnknownHostException err) {
            throw new RuntimeException(err);
        }
    }

    @Override
    public BookieServiceInfo get() {
        try {
            return BookieServiceInfoUtils.buildLegacyBookieServiceInfo(this.bookieSocketAddress.toBookieId().toString());
        }
        catch (UnknownHostException err) {
            throw new RuntimeException(err);
        }
    }
}

