/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.cli.commands.bookies;

import com.beust.jcommander.Parameter;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.tools.framework.CliSpec;

public class MetaFormatCommand
extends BookieCommand<MetaFormatFlags> {
    private static final String NAME = "metaformat";
    private static final String DESC = "Format bookkeeper metadata in zookeeper.";

    public MetaFormatCommand() {
        this(new MetaFormatFlags());
    }

    private MetaFormatCommand(MetaFormatFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, MetaFormatFlags flags) {
        try {
            return BookKeeperAdmin.format(conf, flags.interactive, flags.force);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
    }

    public static class MetaFormatFlags
    extends CliFlags {
        @Parameter(names={"-n", "nonInteractive"}, description="Whether to confirm old data exists..?")
        private boolean interactive;
        @Parameter(names={"-f", "--force"}, description="If [nonInteractive] is specified, then whether to force delete the old data without prompt.")
        private boolean force;

        public MetaFormatFlags interactive(boolean interactive) {
            this.interactive = interactive;
            return this;
        }

        public MetaFormatFlags force(boolean force) {
            this.force = force;
            return this;
        }
    }
}

