/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.rocksdb;

import java.util.List;
import org.apache.pulsar.functions.runtime.shaded.org.rocksdb.BackupEngineOptions;
import org.apache.pulsar.functions.runtime.shaded.org.rocksdb.BackupInfo;
import org.apache.pulsar.functions.runtime.shaded.org.rocksdb.Env;
import org.apache.pulsar.functions.runtime.shaded.org.rocksdb.RestoreOptions;
import org.apache.pulsar.functions.runtime.shaded.org.rocksdb.RocksDB;
import org.apache.pulsar.functions.runtime.shaded.org.rocksdb.RocksDBException;
import org.apache.pulsar.functions.runtime.shaded.org.rocksdb.RocksObject;

public class BackupEngine
extends RocksObject
implements AutoCloseable {
    protected BackupEngine(long l) {
        super(l);
    }

    public static BackupEngine open(Env env, BackupEngineOptions backupEngineOptions) throws RocksDBException {
        return new BackupEngine(BackupEngine.open(env.nativeHandle_, backupEngineOptions.nativeHandle_));
    }

    public void createNewBackup(RocksDB rocksDB) throws RocksDBException {
        this.createNewBackup(rocksDB, false);
    }

    public void createNewBackup(RocksDB rocksDB, boolean bl) throws RocksDBException {
        assert (this.isOwningHandle());
        this.createNewBackup(this.nativeHandle_, rocksDB.nativeHandle_, bl);
    }

    public void createNewBackupWithMetadata(RocksDB rocksDB, String string, boolean bl) throws RocksDBException {
        assert (this.isOwningHandle());
        this.createNewBackupWithMetadata(this.nativeHandle_, rocksDB.nativeHandle_, string, bl);
    }

    public List<BackupInfo> getBackupInfo() {
        assert (this.isOwningHandle());
        return this.getBackupInfo(this.nativeHandle_);
    }

    public int[] getCorruptedBackups() {
        assert (this.isOwningHandle());
        return this.getCorruptedBackups(this.nativeHandle_);
    }

    public void garbageCollect() throws RocksDBException {
        assert (this.isOwningHandle());
        this.garbageCollect(this.nativeHandle_);
    }

    public void purgeOldBackups(int n) throws RocksDBException {
        assert (this.isOwningHandle());
        this.purgeOldBackups(this.nativeHandle_, n);
    }

    public void deleteBackup(int n) throws RocksDBException {
        assert (this.isOwningHandle());
        this.deleteBackup(this.nativeHandle_, n);
    }

    public void restoreDbFromBackup(int n, String string, String string2, RestoreOptions restoreOptions) throws RocksDBException {
        assert (this.isOwningHandle());
        this.restoreDbFromBackup(this.nativeHandle_, n, string, string2, restoreOptions.nativeHandle_);
    }

    public void restoreDbFromLatestBackup(String string, String string2, RestoreOptions restoreOptions) throws RocksDBException {
        assert (this.isOwningHandle());
        this.restoreDbFromLatestBackup(this.nativeHandle_, string, string2, restoreOptions.nativeHandle_);
    }

    private static native long open(long var0, long var2) throws RocksDBException;

    private native void createNewBackup(long var1, long var3, boolean var5) throws RocksDBException;

    private native void createNewBackupWithMetadata(long var1, long var3, String var5, boolean var6) throws RocksDBException;

    private native List<BackupInfo> getBackupInfo(long var1);

    private native int[] getCorruptedBackups(long var1);

    private native void garbageCollect(long var1) throws RocksDBException;

    private native void purgeOldBackups(long var1, int var3) throws RocksDBException;

    private native void deleteBackup(long var1, int var3) throws RocksDBException;

    private native void restoreDbFromBackup(long var1, int var3, String var4, String var5, long var6) throws RocksDBException;

    private native void restoreDbFromLatestBackup(long var1, String var3, String var4, long var5) throws RocksDBException;

    @Override
    protected final native void disposeInternal(long var1);
}

