/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.json.jackson;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.core.util.BufferRecycler;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.core.util.JsonRecyclerPools;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.core.util.RecyclerPool;

public class HybridJacksonPool
implements RecyclerPool<BufferRecycler> {
    private static final HybridJacksonPool INSTANCE = new HybridJacksonPool();
    private static final Predicate<Thread> isVirtual = VirtualPredicate.access$000();
    private final RecyclerPool<BufferRecycler> nativePool = JsonRecyclerPools.threadLocalPool();
    private static final int MAX_POW2 = 0x40000000;

    private HybridJacksonPool() {
    }

    public static HybridJacksonPool getInstance() {
        return INSTANCE;
    }

    public BufferRecycler acquirePooled() {
        return isVirtual.test(Thread.currentThread()) ? VirtualPoolHolder.virtualPool.acquirePooled() : (BufferRecycler)this.nativePool.acquirePooled();
    }

    public BufferRecycler acquireAndLinkPooled() {
        return isVirtual.test(Thread.currentThread()) ? (BufferRecycler)VirtualPoolHolder.virtualPool.acquireAndLinkPooled() : (BufferRecycler)this.nativePool.acquirePooled();
    }

    public void releasePooled(BufferRecycler bufferRecycler) {
        if (bufferRecycler instanceof VThreadBufferRecycler) {
            VirtualPoolHolder.virtualPool.releasePooled(bufferRecycler);
        }
    }

    private static int roundToPowerOfTwo(int value) {
        if (value > 0x40000000) {
            throw new IllegalArgumentException("There is no larger power of 2 int for value:" + value + " since it exceeds 2^31.");
        }
        if (value < 0) {
            throw new IllegalArgumentException("Given value:" + value + ". Expecting value >= 0.");
        }
        int nextPow2 = 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
        return nextPow2;
    }

    private static class XorShiftThreadProbe {
        private final int mask;

        XorShiftThreadProbe(int mask) {
            this.mask = mask;
        }

        public int index() {
            return this.probe() & this.mask;
        }

        private int probe() {
            int probe = (int)(Thread.currentThread().getId() * -1640531527L & Integer.MAX_VALUE);
            probe ^= probe << 13;
            probe ^= probe >>> 17;
            probe ^= probe << 5;
            return probe;
        }
    }

    private static class VirtualPredicate {
        private static final MethodHandle virtualMh = VirtualPredicate.findVirtualMH();

        private VirtualPredicate() {
        }

        private static MethodHandle findVirtualMH() {
            try {
                return MethodHandles.publicLookup().findVirtual(Thread.class, "isVirtual", MethodType.methodType(Boolean.TYPE));
            }
            catch (Exception e) {
                return null;
            }
        }

        private static Predicate<Thread> findIsVirtualPredicate() {
            if (virtualMh != null) {
                return new Predicate<Thread>(){

                    @Override
                    public boolean test(Thread thread) {
                        try {
                            return virtualMh.invokeExact(thread);
                        }
                        catch (Throwable e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
            return new Predicate<Thread>(){

                @Override
                public boolean test(Thread thread) {
                    return false;
                }
            };
        }

        static /* synthetic */ Predicate access$000() {
            return VirtualPredicate.findIsVirtualPredicate();
        }
    }

    private static class VThreadBufferRecycler
    extends BufferRecycler {
        private final int slot;

        VThreadBufferRecycler(int slot) {
            this.slot = slot;
        }
    }

    static class StripedLockFreePool
    implements RecyclerPool<BufferRecycler> {
        private static final int CACHE_LINE_SHIFT = 4;
        private static final int CACHE_LINE_PADDING = 16;
        private final XorShiftThreadProbe threadProbe;
        private final AtomicReferenceArray<Node> topStacks;
        private final int stripesCount;

        public StripedLockFreePool(int stripesCount) {
            if (stripesCount <= 0) {
                throw new IllegalArgumentException("Expecting a stripesCount that is larger than 0");
            }
            this.stripesCount = stripesCount;
            int size = HybridJacksonPool.roundToPowerOfTwo(stripesCount);
            this.topStacks = new AtomicReferenceArray(size * 16);
            int mask = size - 1 << 4;
            this.threadProbe = new XorShiftThreadProbe(mask);
        }

        public int size() {
            return this.stackSizes().sum();
        }

        public int[] stackStats() {
            return this.stackSizes().toArray();
        }

        private IntStream stackSizes() {
            return IntStream.range(0, this.stripesCount).map(i -> {
                Node node = this.topStacks.get(i * 16);
                return node == null ? 0 : node.level;
            });
        }

        public BufferRecycler acquirePooled() {
            int index = this.threadProbe.index();
            Node currentHead = this.topStacks.get(index);
            while (currentHead != null) {
                if (this.topStacks.compareAndSet(index, currentHead, currentHead.next)) {
                    currentHead.next = null;
                    return currentHead.value;
                }
                currentHead = this.topStacks.get(index);
            }
            return new VThreadBufferRecycler(index);
        }

        public void releasePooled(BufferRecycler recycler) {
            VThreadBufferRecycler vThreadBufferRecycler = (VThreadBufferRecycler)recycler;
            Node newHead = new Node(vThreadBufferRecycler);
            Node next = this.topStacks.get(vThreadBufferRecycler.slot);
            while (true) {
                int n = newHead.level = next == null ? 1 : next.level + 1;
                if (this.topStacks.compareAndSet(vThreadBufferRecycler.slot, next, newHead)) {
                    newHead.next = next;
                    return;
                }
                next = this.topStacks.get(vThreadBufferRecycler.slot);
            }
        }

        private static class Node {
            final VThreadBufferRecycler value;
            Node next;
            int level = 0;

            Node(VThreadBufferRecycler value) {
                this.value = value;
            }
        }
    }

    private static class VirtualPoolHolder {
        private static final StripedLockFreePool virtualPool = new StripedLockFreePool(Runtime.getRuntime().availableProcessors());

        private VirtualPoolHolder() {
        }
    }
}

