/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.grpc;

import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.BinaryLog;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ClientInterceptor;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.CompressorRegistry;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.DecompressorRegistry;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ManagedChannel;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ManagedChannelBuilder;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.NameResolver;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.ProxyDetector;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import org.apache.pulsar.functions.runtime.shaded.javax.annotation.Nullable;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Context;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Handler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Vertx;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.VertxException;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpClientOptions;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.HttpVersion;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.ContextInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.VertxInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.ClientOptionsBase;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl.SSLHelper;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl.SslContextProvider;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.impl.VertxSslContext;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.transport.Transport;

public class VertxChannelBuilder
extends ManagedChannelBuilder<VertxChannelBuilder> {
    private final Vertx vertx;
    private final NettyChannelBuilder builder;
    private final ContextInternal context;
    private final HttpClientOptions options = new HttpClientOptions();

    private static String authorityFromHostAndPort(String host, int port) {
        try {
            return new URI(null, null, host, port, null, null, null).getAuthority();
        }
        catch (URISyntaxException var3) {
            throw new IllegalArgumentException("Invalid host or port: " + host + " " + port, var3);
        }
    }

    public static VertxChannelBuilder forTarget(Vertx vertx, String target) {
        return new VertxChannelBuilder(vertx, target);
    }

    public static VertxChannelBuilder forAddress(Vertx vertx, String host, int port) {
        return new VertxChannelBuilder(vertx, host, port);
    }

    public static VertxChannelBuilder forAddress(Vertx vertx, SocketAddress address) {
        return new VertxChannelBuilder(vertx, address);
    }

    private VertxChannelBuilder(Vertx vertx, String host, int port) {
        this(vertx, VertxChannelBuilder.authorityFromHostAndPort(host, port));
    }

    private VertxChannelBuilder(Vertx vertx, String target) {
        this.vertx = vertx;
        this.builder = NettyChannelBuilder.forTarget((String)target);
        this.context = (ContextInternal)vertx.getOrCreateContext();
    }

    private VertxChannelBuilder(Vertx vertx, SocketAddress address) {
        this.vertx = vertx;
        this.builder = NettyChannelBuilder.forAddress((SocketAddress)address);
        this.context = (ContextInternal)vertx.getOrCreateContext();
    }

    public NettyChannelBuilder nettyBuilder() {
        return this.builder;
    }

    public VertxChannelBuilder directExecutor() {
        throw new UnsupportedOperationException();
    }

    public VertxChannelBuilder executor(Executor executor) {
        throw new UnsupportedOperationException();
    }

    public VertxChannelBuilder intercept(List<ClientInterceptor> interceptors) {
        this.builder.intercept(interceptors);
        return this;
    }

    public VertxChannelBuilder intercept(ClientInterceptor ... interceptors) {
        this.builder.intercept(interceptors);
        return this;
    }

    public VertxChannelBuilder userAgent(String userAgent) {
        this.builder.userAgent(userAgent);
        return this;
    }

    public VertxChannelBuilder overrideAuthority(String authority) {
        this.builder.overrideAuthority(authority);
        return this;
    }

    @Deprecated
    public VertxChannelBuilder nameResolverFactory(NameResolver.Factory resolverFactory) {
        this.builder.nameResolverFactory(resolverFactory);
        return this;
    }

    public VertxChannelBuilder offloadExecutor(Executor executor) {
        this.builder.offloadExecutor(executor);
        return this;
    }

    public VertxChannelBuilder defaultLoadBalancingPolicy(String policy) {
        this.builder.defaultLoadBalancingPolicy(policy);
        return this;
    }

    public VertxChannelBuilder maxInboundMetadataSize(int bytes) {
        this.builder.maxInboundMetadataSize(bytes);
        return this;
    }

    public VertxChannelBuilder proxyDetector(ProxyDetector proxyDetector) {
        this.builder.proxyDetector(proxyDetector);
        return this;
    }

    public VertxChannelBuilder defaultServiceConfig(@Nullable Map<String, ?> serviceConfig) {
        this.builder.defaultServiceConfig(serviceConfig);
        return this;
    }

    public VertxChannelBuilder disableServiceConfigLookUp() {
        this.builder.disableServiceConfigLookUp();
        return this;
    }

    public VertxChannelBuilder decompressorRegistry(DecompressorRegistry registry) {
        this.builder.decompressorRegistry(registry);
        return this;
    }

    public VertxChannelBuilder compressorRegistry(CompressorRegistry registry) {
        this.builder.compressorRegistry(registry);
        return this;
    }

    public VertxChannelBuilder idleTimeout(long value, TimeUnit unit) {
        this.builder.idleTimeout(value, unit);
        return this;
    }

    public VertxChannelBuilder maxInboundMessageSize(int max) {
        this.builder.maxInboundMessageSize(max);
        return this;
    }

    public VertxChannelBuilder usePlaintext() {
        this.builder.usePlaintext();
        return this;
    }

    public VertxChannelBuilder useTransportSecurity() {
        this.builder.useTransportSecurity();
        return this;
    }

    public VertxChannelBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        this.builder.keepAliveTime(keepAliveTime, timeUnit);
        return this;
    }

    public VertxChannelBuilder keepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        this.builder.keepAliveTimeout(keepAliveTimeout, timeUnit);
        return this;
    }

    public VertxChannelBuilder keepAliveWithoutCalls(boolean enable) {
        this.builder.keepAliveWithoutCalls(enable);
        return this;
    }

    public VertxChannelBuilder maxRetryAttempts(int maxRetryAttempts) {
        this.builder.maxRetryAttempts(maxRetryAttempts);
        return this;
    }

    public VertxChannelBuilder maxHedgedAttempts(int maxHedgedAttempts) {
        this.builder.maxHedgedAttempts(maxHedgedAttempts);
        return this;
    }

    public VertxChannelBuilder retryBufferSize(long bytes) {
        this.builder.retryBufferSize(bytes);
        return this;
    }

    public VertxChannelBuilder perRpcBufferLimit(long bytes) {
        this.builder.perRpcBufferLimit(bytes);
        return this;
    }

    public VertxChannelBuilder disableRetry() {
        this.builder.disableRetry();
        return this;
    }

    public VertxChannelBuilder enableRetry() {
        this.builder.enableRetry();
        return this;
    }

    public VertxChannelBuilder setBinaryLog(BinaryLog binaryLog) {
        this.builder.setBinaryLog(binaryLog);
        return this;
    }

    public VertxChannelBuilder maxTraceEvents(int maxTraceEvents) {
        this.builder.maxTraceEvents(maxTraceEvents);
        return this;
    }

    public VertxChannelBuilder useSsl(Handler<ClientOptionsBase> handler) {
        handler.handle(this.options);
        return this;
    }

    public ManagedChannel build() {
        if (this.options.isSsl()) {
            SslContextProvider provider;
            ContextInternal other = ((VertxInternal)this.vertx).createWorkerContext();
            try {
                SSLHelper helper = new SSLHelper(this.options, Collections.singletonList(HttpVersion.HTTP_2.alpnName()));
                provider = helper.buildContextProvider(this.options.getSslOptions(), other).toCompletionStage().toCompletableFuture().get(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                throw new VertxException(e);
            }
            catch (ExecutionException e) {
                throw new VertxException(e.getCause());
            }
            catch (TimeoutException e) {
                throw new VertxException(e);
            }
            VertxSslContext ctx = provider.createContext(false, null, null, null, true, this.options.isTrustAll());
            this.builder.sslContext((SslContext)ctx);
        }
        Transport transport = ((VertxInternal)this.vertx).transport();
        return ((NettyChannelBuilder)this.builder.eventLoopGroup((EventLoopGroup)this.context.nettyEventLoop()).channelFactory(transport.channelFactory(false)).executor(command -> {
            if (Context.isOnEventLoopThread()) {
                this.context.dispatch(event -> command.run());
            } else {
                command.run();
            }
        })).build();
    }
}

