/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.authorization.PulsarAuthorizationProvider;
import org.apache.pulsar.common.configuration.Category;
import org.apache.pulsar.common.configuration.FieldContext;
import org.apache.pulsar.common.configuration.PulsarConfiguration;
import org.apache.pulsar.common.functions.Resources;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.functions.auth.KubernetesSecretsTokenAuthProvider;
import org.apache.pulsar.functions.instance.state.BKStateStoreProviderImpl;
import org.apache.pulsar.functions.runtime.kubernetes.KubernetesRuntimeFactory;
import org.apache.pulsar.functions.runtime.kubernetes.KubernetesRuntimeFactoryConfig;
import org.apache.pulsar.functions.runtime.process.ProcessRuntimeFactoryConfig;
import org.apache.pulsar.functions.runtime.thread.ThreadRuntimeFactoryConfig;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WorkerConfig
implements Serializable,
PulsarConfiguration {
    private static final long serialVersionUID = 1L;
    @Category
    private static final String CATEGORY_WORKER = "Worker Settings";
    @Category
    private static final String CATEGORY_FUNC_PKG = "Function Package Management";
    @Category
    private static final String CATEGORY_FUNC_METADATA_MNG = "Function Metadata Management";
    @Category
    private static final String CATEGORY_FUNC_RUNTIME_MNG = "Function Runtime Management";
    @Category
    private static final String CATEGORY_FUNC_SCHEDULE_MNG = "Function Scheduling Management";
    @Category
    private static final String CATEGORY_SECURITY = "Common Security Settings (applied for both worker and client)";
    @Category
    private static final String CATEGORY_KEYSTORE_TLS = "KeyStoreTLS";
    @Category
    private static final String CATEGORY_WORKER_SECURITY = "Worker Security Settings";
    @Category
    private static final String CATEGORY_CLIENT_SECURITY = "Security settings for clients talking to brokers";
    @Category
    private static final String CATEGORY_STATE = "State Management";
    @Category
    private static final String CATEGORY_CONNECTORS = "Connectors";
    @Category
    private static final String CATEGORY_FUNCTIONS = "Functions";
    @FieldContext(category="Worker Settings", doc="Id to identify a worker instance")
    private String workerId;
    @FieldContext(category="Worker Settings", doc="Hostname of the worker instance")
    private String workerHostname;
    @FieldContext(category="Worker Settings", doc="The port for serving worker http requests")
    private Integer workerPort;
    @FieldContext(category="Worker Settings", doc="The port for serving worker https requests")
    private Integer workerPortTls;
    @FieldContext(category="Worker Settings", doc="Whether the '/metrics' endpoint requires authentication. Defaults to true.'authenticationEnabled' must also be set for this to take effect.")
    private boolean authenticateMetricsEndpoint = true;
    @FieldContext(category="Worker Settings", doc="Whether the '/metrics' endpoint should return default prometheus metrics. Defaults to false.")
    private boolean includeStandardPrometheusMetrics = false;
    @FieldContext(category="Worker Settings", doc="Classname of Pluggable JVM GC metrics logger that can log GC specific metrics")
    private String jvmGCMetricsLoggerClassName;
    @FieldContext(category="Worker Settings", doc="Number of threads to use for HTTP requests processing")
    private int numHttpServerThreads = 8;
    @FieldContext(category="Worker Settings", doc="Enable the enforcement of limits on the incoming HTTP requests")
    private boolean httpRequestsLimitEnabled = false;
    @FieldContext(category="Worker Settings", doc="Max HTTP requests per seconds allowed. The excess of requests will be rejected with HTTP code 429 (Too many requests)")
    private double httpRequestsMaxPerSecond = 100.0;
    @FieldContext(category="Worker Settings", required=false, doc="Configuration store connection string (as a comma-separated list)")
    private String configurationStoreServers;
    @FieldContext(category="Worker Settings", doc="ZooKeeper session timeout in milliseconds")
    private long zooKeeperSessionTimeoutMillis = 30000L;
    @FieldContext(category="Worker Settings", doc="ZooKeeper operation timeout in seconds")
    private int zooKeeperOperationTimeoutSeconds = 30;
    @FieldContext(category="Worker Settings", doc="ZooKeeper cache expiry time in seconds")
    private int zooKeeperCacheExpirySeconds = 300;
    @FieldContext(category="Connectors", doc="The path to the location to locate builtin connectors")
    private String connectorsDirectory = "./connectors";
    @FieldContext(category="Connectors", doc="The directory where nar packages are extractors")
    private String narExtractionDirectory = NarClassLoader.DEFAULT_NAR_EXTRACTION_DIR;
    @FieldContext(category="Connectors", doc="Should we validate connector config during submission")
    private Boolean validateConnectorConfig = false;
    @FieldContext(category="Functions", doc="The path to the location to locate builtin functions")
    private String functionsDirectory = "./functions";
    @FieldContext(category="Function Metadata Management", doc="The Pulsar topic used for storing function metadata")
    private String functionMetadataTopicName;
    @FieldContext(category="Function Metadata Management", doc="Should the metadata topic be compacted?")
    private Boolean useCompactedMetadataTopic = false;
    @FieldContext(category="Function Metadata Management", doc="The web service URL for function workers")
    private String functionWebServiceUrl;
    @FieldContext(category="Function Metadata Management", doc="The Pulsar binary service URL that function metadata manager talks to")
    private String pulsarServiceUrl;
    @FieldContext(category="Function Metadata Management", doc="The Pulsar web service URL that function metadata manager talks to")
    private String pulsarWebServiceUrl;
    @FieldContext(category="Function Metadata Management", doc="The Pulsar topic used for cluster coordination")
    private String clusterCoordinationTopicName;
    @FieldContext(category="Function Metadata Management", doc="The Pulsar namespace for storing metadata topics")
    private String pulsarFunctionsNamespace;
    @FieldContext(category="Function Metadata Management", doc="The Pulsar cluster name. Used for creating Pulsar namespace during worker initialization")
    private String pulsarFunctionsCluster;
    @FieldContext(category="Function Package Management", doc="The number of replicas for storing functions")
    private int numFunctionPackageReplicas;
    @FieldContext(category="Function Runtime Management", doc="The directory to download functions by runtime manager")
    private String downloadDirectory;
    @FieldContext(category="State Management", doc="The service URL of state storage")
    private String stateStorageServiceUrl;
    @FieldContext(category="State Management", doc="The implementation class for the state store")
    private String stateStorageProviderImplementation = BKStateStoreProviderImpl.class.getName();
    @FieldContext(category="Function Runtime Management", doc="The Pulsar topic used for storing function assignment informations")
    private String functionAssignmentTopicName;
    @FieldContext(category="Function Scheduling Management", doc="The scheduler class used by assigning functions to workers")
    private String schedulerClassName;
    @FieldContext(category="Function Runtime Management", doc="The frequency of failure checks, in milliseconds")
    private long failureCheckFreqMs;
    @FieldContext(category="Function Runtime Management", doc="The reschedule timeout of function assignment, in milliseconds")
    private long rescheduleTimeoutMs;
    @FieldContext(category="Function Runtime Management", doc="The frequency to check whether the cluster needs rebalancing")
    private long rebalanceCheckFreqSec;
    @FieldContext(category="Function Runtime Management", doc="Interval to probe for changes in list of workers, in seconds")
    private int workerListProbeIntervalSec = 60;
    @FieldContext(category="Function Runtime Management", doc="The max number of retries for initial broker reconnects when function metadata manager tries to create producer on metadata topics")
    private int initialBrokerReconnectMaxRetries;
    @FieldContext(category="Function Runtime Management", doc="The max number of retries for writing assignment to assignment topic")
    private int assignmentWriteMaxRetries;
    @FieldContext(category="Function Runtime Management", doc="The frequency of instance liveness check, in milliseconds")
    private long instanceLivenessCheckFreqMs;
    @FieldContext(category="Security settings for clients talking to brokers", doc="Whether to enable the broker client authentication used by function workers to talk to brokers")
    private Boolean brokerClientAuthenticationEnabled = null;
    @FieldContext(category="Security settings for clients talking to brokers", doc="The authentication plugin used by function workers to talk to brokers")
    private String brokerClientAuthenticationPlugin;
    @FieldContext(category="Security settings for clients talking to brokers", doc="The parameters of the authentication plugin used by function workers to talk to brokers")
    private String brokerClientAuthenticationParameters;
    @FieldContext(category="Security settings for clients talking to brokers", doc="Authentication plugin to use when connecting to bookies")
    private String bookkeeperClientAuthenticationPlugin;
    @FieldContext(category="Security settings for clients talking to brokers", doc="BookKeeper auth plugin implementation specifics parameters name and values")
    private String bookkeeperClientAuthenticationParametersName;
    @FieldContext(category="Security settings for clients talking to brokers", doc="Parameters for bookkeeper auth plugin")
    private String bookkeeperClientAuthenticationParameters;
    @FieldContext(category="Function Metadata Management", doc="Frequency how often worker performs compaction on function-topics, in seconds")
    private long topicCompactionFrequencySec = 1800L;
    @FieldContext(category="Worker Security Settings", doc="Enable TLS")
    @Deprecated
    private boolean tlsEnabled = false;
    @FieldContext(category="Worker Security Settings", doc="Path for the TLS certificate file")
    private String tlsCertificateFilePath;
    @FieldContext(category="Worker Security Settings", doc="Path for the TLS private key file")
    private String tlsKeyFilePath;
    @FieldContext(category="Worker Security Settings", doc="Path for the trusted TLS certificate file")
    private String tlsTrustCertsFilePath = "";
    @FieldContext(category="Common Security Settings (applied for both worker and client)", doc="Accept untrusted TLS certificate from client")
    private boolean tlsAllowInsecureConnection = false;
    @FieldContext(category="Worker Security Settings", doc="Require trusted client cert on connect")
    private boolean tlsRequireTrustedClientCertOnConnect = false;
    @FieldContext(category="Security settings for clients talking to brokers", doc="Whether to enable TLS when clients connect to broker", deprecated=true)
    @Deprecated
    private boolean useTls = false;
    @FieldContext(category="Common Security Settings (applied for both worker and client)", doc="Whether to enable hostname verification on TLS connections")
    private boolean tlsEnableHostnameVerification = false;
    @FieldContext(category="Common Security Settings (applied for both worker and client)", doc="Tls cert refresh duration in seconds (set 0 to check on every new connection)")
    private long tlsCertRefreshCheckDurationSec = 300L;
    @FieldContext(category="KeyStoreTLS", doc="Enable TLS with KeyStore type configuration in function worker")
    private boolean tlsEnabledWithKeyStore = false;
    @FieldContext(category="KeyStoreTLS", doc="Specify the TLS provider for the function worker service: \nWhen using TLS authentication with CACert, the valid value is either OPENSSL or JDK.\nWhen using TLS authentication with KeyStore, available values can be SunJSSE, Conscrypt and etc.")
    private String tlsProvider = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS KeyStore type configuration in function worker: JKS, PKCS12")
    private String tlsKeyStoreType = "JKS";
    @FieldContext(category="KeyStoreTLS", doc="TLS KeyStore path in function worker")
    private String tlsKeyStore = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS KeyStore password for function worker")
    private String tlsKeyStorePassword = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS TrustStore type configuration in function worker: JKS, PKCS12")
    private String tlsTrustStoreType = "JKS";
    @FieldContext(category="KeyStoreTLS", doc="TLS TrustStore path in function worker")
    private String tlsTrustStore = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS TrustStore password for function worker, null means empty password.")
    private String tlsTrustStorePassword = null;
    @FieldContext(category="Worker Security Settings", doc="Specify the tls protocols the proxy's web service will use to negotiate during TLS Handshake.\n\nExample:- [TLSv1.3, TLSv1.2]")
    private Set<String> webServiceTlsProtocols = new TreeSet<String>();
    @FieldContext(category="Worker Security Settings", doc="Specify the tls cipher the proxy's web service will use to negotiate during TLS Handshake.\n\nExample:- [TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256]")
    private Set<String> webServiceTlsCiphers = new TreeSet<String>();
    @FieldContext(category="Worker Security Settings", doc="Enforce authentication")
    private boolean authenticationEnabled = false;
    @FieldContext(category="Worker Security Settings", doc="Authentication provider name list, which is a list of class names")
    private Set<String> authenticationProviders = Sets.newTreeSet();
    @FieldContext(category="Worker Security Settings", doc="Enforce authorization on accessing functions admin-api")
    private boolean authorizationEnabled = false;
    @FieldContext(category="Worker Security Settings", doc="Authorization provider fully qualified class-name")
    private String authorizationProvider = PulsarAuthorizationProvider.class.getName();
    @FieldContext(category="Worker Security Settings", doc="Role names that are treated as `super-user`, meaning they will be able to access any admin-api")
    private Set<String> superUserRoles = Sets.newTreeSet();
    private Properties properties = new Properties();
    @FieldContext(category="Worker Settings", doc="Whether to initialize distributed log metadata in runtime")
    private Boolean initializedDlogMetadata = false;
    @FieldContext(category="Security settings for clients talking to brokers", doc="The path to trusted certificates used by the Pulsar client to authenticate with Pulsar brokers")
    private String brokerClientTrustCertsFilePath;
    @FieldContext(category="Function Runtime Management", doc="The classname of the function runtime factory.")
    private String functionRuntimeFactoryClassName;
    @FieldContext(category="Function Runtime Management", doc="A map of configs for function runtime factory.")
    private Map<String, Object> functionRuntimeFactoryConfigs;
    @FieldContext(category="Function Runtime Management", doc="The classname of the secrets provider configurator.")
    private String secretsProviderConfiguratorClassName;
    @FieldContext(category="Function Runtime Management", doc="Any config the secret provider configurator might need. \n\nThis is passed on to the init method of the SecretsProviderConfigurator")
    private Map<String, String> secretsProviderConfiguratorConfig;
    @FieldContext(category="Function Runtime Management", doc="A set of the minimum amount of resources functions must request.  Support for this depends on function runtime.")
    private Resources functionInstanceMinResources;
    @FieldContext(category="Function Runtime Management", doc="A set of the maximum amount of resources functions may request.  Support for this depends on function runtime.")
    private Resources functionInstanceMaxResources;
    @FieldContext(category="Function Runtime Management", doc="Granularities of requested resources. If the granularity of any type of resource is set, the requested resource of the type must be a multiple of the granularity.")
    private Resources functionInstanceResourceGranularities;
    @FieldContext(category="Function Runtime Management", doc="If this configuration is set to be true, the amount of requested resources of all type of resources that have the granularity set must be the same multiples of their granularities.")
    private boolean functionInstanceResourceChangeInLockStep = false;
    @FieldContext(category="Function Runtime Management", doc="The class name of the Function Authentication Provider to use.  The Function Authentication Provider is responsible to distributing the necessary authentication information to individual functions e.g. user tokens")
    private String functionAuthProviderClassName;
    @FieldContext(doc="The full class-name of an instance of RuntimeCustomizer. This class receives the 'customRuntimeOptions string and can customize details of how the runtime operates")
    protected String runtimeCustomizerClassName;
    @FieldContext(doc="A map of config passed to the RuntimeCustomizer. This config is distinct from the `customRuntimeOptions` provided by functions as this config is the the same across all functions")
    private Map<String, Object> runtimeCustomizerConfig = Collections.emptyMap();
    @FieldContext(doc="Max pending async requests per instance to avoid large number of concurrent requests.Only used in AsyncFunction. Default: 1000")
    private int maxPendingAsyncRequests = 1000;
    @FieldContext(doc="Whether to forward the source message properties to the output message")
    private boolean forwardSourceMessageProperty = true;
    @FieldContext(category="Worker Settings", doc="The nar package for the function worker service")
    private String functionsWorkerServiceNarPackage = "";
    @FieldContext(category="Worker Settings", doc="The additional configs for the function worker service if functionsWorkerServiceNarPackage provided")
    private Map<String, Object> functionsWorkerServiceCustomConfigs = Collections.emptyMap();
    @FieldContext(category="Worker Settings", doc="Enable to expose Pulsar Admin Client from Function Context, default is disabled")
    private boolean exposeAdminClientEnabled = false;
    @FieldContext(category="Function Runtime Management", doc="Thread based runtime settings")
    @Deprecated
    private ThreadContainerFactory threadContainerFactory;
    @FieldContext(category="Function Runtime Management", doc="Process based runtime settings")
    @Deprecated
    private ProcessContainerFactory processContainerFactory;
    @FieldContext(category="Function Runtime Management", doc="Kubernetes based runtime settings")
    @Deprecated
    private KubernetesContainerFactory kubernetesContainerFactory;
    @FieldContext(category="Security settings for clients talking to brokers", doc="The parameters of the authentication plugin used by function workers to talk to brokers")
    @Deprecated
    private String clientAuthenticationParameters;
    @FieldContext(category="Security settings for clients talking to brokers", doc="The authentication plugin used by function workers to talk to brokers")
    @Deprecated
    private String clientAuthenticationPlugin;

    public boolean isBrokerClientAuthenticationEnabled() {
        if (this.brokerClientAuthenticationEnabled != null) {
            return this.brokerClientAuthenticationEnabled;
        }
        return this.authenticationEnabled;
    }

    public boolean getTlsEnabled() {
        return this.tlsEnabled && this.workerPortTls != null;
    }

    public Boolean isInitializedDlogMetadata() {
        if (this.initializedDlogMetadata == null) {
            return false;
        }
        return this.initializedDlogMetadata;
    }

    public String getBrokerClientTrustCertsFilePath() {
        if (StringUtils.isNotBlank((CharSequence)this.brokerClientTrustCertsFilePath)) {
            return this.brokerClientTrustCertsFilePath;
        }
        return this.tlsTrustCertsFilePath;
    }

    public String getFunctionAuthProviderClassName() {
        if (!StringUtils.isEmpty((CharSequence)this.functionAuthProviderClassName)) {
            return this.functionAuthProviderClassName;
        }
        if (StringUtils.equals((CharSequence)this.getFunctionRuntimeFactoryClassName(), (CharSequence)KubernetesRuntimeFactory.class.getName()) || this.getKubernetesContainerFactory() != null) {
            return KubernetesSecretsTokenAuthProvider.class.getName();
        }
        return null;
    }

    public String getFunctionMetadataTopic() {
        return String.format("persistent://%s/%s", this.pulsarFunctionsNamespace, this.functionMetadataTopicName);
    }

    public String getClusterCoordinationTopic() {
        return String.format("persistent://%s/%s", this.pulsarFunctionsNamespace, this.clusterCoordinationTopicName);
    }

    public String getFunctionAssignmentTopic() {
        return String.format("persistent://%s/%s", this.pulsarFunctionsNamespace, this.functionAssignmentTopicName);
    }

    public static WorkerConfig load(String yamlFile) throws IOException {
        if (StringUtils.isBlank((CharSequence)yamlFile)) {
            return new WorkerConfig();
        }
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (WorkerConfig)mapper.readValue(new File(yamlFile), WorkerConfig.class);
    }

    public String getWorkerId() {
        if (StringUtils.isBlank((CharSequence)this.workerId)) {
            this.workerId = String.format("%s-%s", this.getWorkerHostname(), this.getWorkerPort());
        }
        return this.workerId;
    }

    public String getWorkerHostname() {
        if (StringUtils.isBlank((CharSequence)this.workerHostname)) {
            this.workerHostname = WorkerConfig.unsafeLocalhostResolve();
        }
        return this.workerHostname;
    }

    public byte[] getTlsTrustChainBytes() {
        if (StringUtils.isNotEmpty((CharSequence)this.getTlsTrustCertsFilePath()) && Files.exists(Paths.get(this.getTlsTrustCertsFilePath(), new String[0]), new LinkOption[0])) {
            try {
                return Files.readAllBytes(Paths.get(this.getTlsTrustCertsFilePath(), new String[0]));
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read CA bytes", e);
            }
        }
        return null;
    }

    public String getWorkerWebAddress() {
        return String.format("http://%s:%d", this.getWorkerHostname(), this.getWorkerPort());
    }

    public String getWorkerWebAddressTls() {
        return String.format("https://%s:%d", this.getWorkerHostname(), this.getWorkerPortTls());
    }

    public static String unsafeLocalhostResolve() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            throw new IllegalStateException("Failed to resolve localhost name.", ex);
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getBrokerClientAuthenticationPlugin() {
        if (null == this.brokerClientAuthenticationPlugin) {
            return this.clientAuthenticationPlugin;
        }
        return this.brokerClientAuthenticationPlugin;
    }

    public String getBrokerClientAuthenticationParameters() {
        if (null == this.brokerClientAuthenticationParameters) {
            return this.clientAuthenticationParameters;
        }
        return this.brokerClientAuthenticationParameters;
    }

    public Integer getWorkerPort() {
        return this.workerPort;
    }

    public Integer getWorkerPortTls() {
        return this.workerPortTls;
    }

    public boolean isAuthenticateMetricsEndpoint() {
        return this.authenticateMetricsEndpoint;
    }

    public boolean isIncludeStandardPrometheusMetrics() {
        return this.includeStandardPrometheusMetrics;
    }

    public String getJvmGCMetricsLoggerClassName() {
        return this.jvmGCMetricsLoggerClassName;
    }

    public int getNumHttpServerThreads() {
        return this.numHttpServerThreads;
    }

    public boolean isHttpRequestsLimitEnabled() {
        return this.httpRequestsLimitEnabled;
    }

    public double getHttpRequestsMaxPerSecond() {
        return this.httpRequestsMaxPerSecond;
    }

    public String getConfigurationStoreServers() {
        return this.configurationStoreServers;
    }

    public long getZooKeeperSessionTimeoutMillis() {
        return this.zooKeeperSessionTimeoutMillis;
    }

    public int getZooKeeperOperationTimeoutSeconds() {
        return this.zooKeeperOperationTimeoutSeconds;
    }

    public int getZooKeeperCacheExpirySeconds() {
        return this.zooKeeperCacheExpirySeconds;
    }

    public String getConnectorsDirectory() {
        return this.connectorsDirectory;
    }

    public String getNarExtractionDirectory() {
        return this.narExtractionDirectory;
    }

    public Boolean getValidateConnectorConfig() {
        return this.validateConnectorConfig;
    }

    public String getFunctionsDirectory() {
        return this.functionsDirectory;
    }

    public String getFunctionMetadataTopicName() {
        return this.functionMetadataTopicName;
    }

    public Boolean getUseCompactedMetadataTopic() {
        return this.useCompactedMetadataTopic;
    }

    public String getFunctionWebServiceUrl() {
        return this.functionWebServiceUrl;
    }

    public String getPulsarServiceUrl() {
        return this.pulsarServiceUrl;
    }

    public String getPulsarWebServiceUrl() {
        return this.pulsarWebServiceUrl;
    }

    public String getClusterCoordinationTopicName() {
        return this.clusterCoordinationTopicName;
    }

    public String getPulsarFunctionsNamespace() {
        return this.pulsarFunctionsNamespace;
    }

    public String getPulsarFunctionsCluster() {
        return this.pulsarFunctionsCluster;
    }

    public int getNumFunctionPackageReplicas() {
        return this.numFunctionPackageReplicas;
    }

    public String getDownloadDirectory() {
        return this.downloadDirectory;
    }

    public String getStateStorageServiceUrl() {
        return this.stateStorageServiceUrl;
    }

    public String getStateStorageProviderImplementation() {
        return this.stateStorageProviderImplementation;
    }

    public String getFunctionAssignmentTopicName() {
        return this.functionAssignmentTopicName;
    }

    public String getSchedulerClassName() {
        return this.schedulerClassName;
    }

    public long getFailureCheckFreqMs() {
        return this.failureCheckFreqMs;
    }

    public long getRescheduleTimeoutMs() {
        return this.rescheduleTimeoutMs;
    }

    public long getRebalanceCheckFreqSec() {
        return this.rebalanceCheckFreqSec;
    }

    public int getWorkerListProbeIntervalSec() {
        return this.workerListProbeIntervalSec;
    }

    public int getInitialBrokerReconnectMaxRetries() {
        return this.initialBrokerReconnectMaxRetries;
    }

    public int getAssignmentWriteMaxRetries() {
        return this.assignmentWriteMaxRetries;
    }

    public long getInstanceLivenessCheckFreqMs() {
        return this.instanceLivenessCheckFreqMs;
    }

    public Boolean getBrokerClientAuthenticationEnabled() {
        return this.brokerClientAuthenticationEnabled;
    }

    public String getBookkeeperClientAuthenticationPlugin() {
        return this.bookkeeperClientAuthenticationPlugin;
    }

    public String getBookkeeperClientAuthenticationParametersName() {
        return this.bookkeeperClientAuthenticationParametersName;
    }

    public String getBookkeeperClientAuthenticationParameters() {
        return this.bookkeeperClientAuthenticationParameters;
    }

    public long getTopicCompactionFrequencySec() {
        return this.topicCompactionFrequencySec;
    }

    public String getTlsCertificateFilePath() {
        return this.tlsCertificateFilePath;
    }

    public String getTlsKeyFilePath() {
        return this.tlsKeyFilePath;
    }

    public String getTlsTrustCertsFilePath() {
        return this.tlsTrustCertsFilePath;
    }

    public boolean isTlsAllowInsecureConnection() {
        return this.tlsAllowInsecureConnection;
    }

    public boolean isTlsRequireTrustedClientCertOnConnect() {
        return this.tlsRequireTrustedClientCertOnConnect;
    }

    @Deprecated
    public boolean isUseTls() {
        return this.useTls;
    }

    public boolean isTlsEnableHostnameVerification() {
        return this.tlsEnableHostnameVerification;
    }

    public long getTlsCertRefreshCheckDurationSec() {
        return this.tlsCertRefreshCheckDurationSec;
    }

    public boolean isTlsEnabledWithKeyStore() {
        return this.tlsEnabledWithKeyStore;
    }

    public String getTlsProvider() {
        return this.tlsProvider;
    }

    public String getTlsKeyStoreType() {
        return this.tlsKeyStoreType;
    }

    public String getTlsKeyStore() {
        return this.tlsKeyStore;
    }

    public String getTlsKeyStorePassword() {
        return this.tlsKeyStorePassword;
    }

    public String getTlsTrustStoreType() {
        return this.tlsTrustStoreType;
    }

    public String getTlsTrustStore() {
        return this.tlsTrustStore;
    }

    public String getTlsTrustStorePassword() {
        return this.tlsTrustStorePassword;
    }

    public Set<String> getWebServiceTlsProtocols() {
        return this.webServiceTlsProtocols;
    }

    public Set<String> getWebServiceTlsCiphers() {
        return this.webServiceTlsCiphers;
    }

    public boolean isAuthenticationEnabled() {
        return this.authenticationEnabled;
    }

    public Set<String> getAuthenticationProviders() {
        return this.authenticationProviders;
    }

    public boolean isAuthorizationEnabled() {
        return this.authorizationEnabled;
    }

    public String getAuthorizationProvider() {
        return this.authorizationProvider;
    }

    public Set<String> getSuperUserRoles() {
        return this.superUserRoles;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Boolean getInitializedDlogMetadata() {
        return this.initializedDlogMetadata;
    }

    public String getFunctionRuntimeFactoryClassName() {
        return this.functionRuntimeFactoryClassName;
    }

    public Map<String, Object> getFunctionRuntimeFactoryConfigs() {
        return this.functionRuntimeFactoryConfigs;
    }

    public String getSecretsProviderConfiguratorClassName() {
        return this.secretsProviderConfiguratorClassName;
    }

    public Map<String, String> getSecretsProviderConfiguratorConfig() {
        return this.secretsProviderConfiguratorConfig;
    }

    public Resources getFunctionInstanceMinResources() {
        return this.functionInstanceMinResources;
    }

    public Resources getFunctionInstanceMaxResources() {
        return this.functionInstanceMaxResources;
    }

    public Resources getFunctionInstanceResourceGranularities() {
        return this.functionInstanceResourceGranularities;
    }

    public boolean isFunctionInstanceResourceChangeInLockStep() {
        return this.functionInstanceResourceChangeInLockStep;
    }

    public String getRuntimeCustomizerClassName() {
        return this.runtimeCustomizerClassName;
    }

    public Map<String, Object> getRuntimeCustomizerConfig() {
        return this.runtimeCustomizerConfig;
    }

    public int getMaxPendingAsyncRequests() {
        return this.maxPendingAsyncRequests;
    }

    public boolean isForwardSourceMessageProperty() {
        return this.forwardSourceMessageProperty;
    }

    public String getFunctionsWorkerServiceNarPackage() {
        return this.functionsWorkerServiceNarPackage;
    }

    public Map<String, Object> getFunctionsWorkerServiceCustomConfigs() {
        return this.functionsWorkerServiceCustomConfigs;
    }

    public boolean isExposeAdminClientEnabled() {
        return this.exposeAdminClientEnabled;
    }

    @Deprecated
    public ThreadContainerFactory getThreadContainerFactory() {
        return this.threadContainerFactory;
    }

    @Deprecated
    public ProcessContainerFactory getProcessContainerFactory() {
        return this.processContainerFactory;
    }

    @Deprecated
    public KubernetesContainerFactory getKubernetesContainerFactory() {
        return this.kubernetesContainerFactory;
    }

    @Deprecated
    public String getClientAuthenticationParameters() {
        return this.clientAuthenticationParameters;
    }

    @Deprecated
    public String getClientAuthenticationPlugin() {
        return this.clientAuthenticationPlugin;
    }

    public WorkerConfig setWorkerId(String workerId) {
        this.workerId = workerId;
        return this;
    }

    public WorkerConfig setWorkerHostname(String workerHostname) {
        this.workerHostname = workerHostname;
        return this;
    }

    public WorkerConfig setWorkerPort(Integer workerPort) {
        this.workerPort = workerPort;
        return this;
    }

    public WorkerConfig setWorkerPortTls(Integer workerPortTls) {
        this.workerPortTls = workerPortTls;
        return this;
    }

    public WorkerConfig setAuthenticateMetricsEndpoint(boolean authenticateMetricsEndpoint) {
        this.authenticateMetricsEndpoint = authenticateMetricsEndpoint;
        return this;
    }

    public WorkerConfig setIncludeStandardPrometheusMetrics(boolean includeStandardPrometheusMetrics) {
        this.includeStandardPrometheusMetrics = includeStandardPrometheusMetrics;
        return this;
    }

    public WorkerConfig setJvmGCMetricsLoggerClassName(String jvmGCMetricsLoggerClassName) {
        this.jvmGCMetricsLoggerClassName = jvmGCMetricsLoggerClassName;
        return this;
    }

    public WorkerConfig setNumHttpServerThreads(int numHttpServerThreads) {
        this.numHttpServerThreads = numHttpServerThreads;
        return this;
    }

    public WorkerConfig setHttpRequestsLimitEnabled(boolean httpRequestsLimitEnabled) {
        this.httpRequestsLimitEnabled = httpRequestsLimitEnabled;
        return this;
    }

    public WorkerConfig setHttpRequestsMaxPerSecond(double httpRequestsMaxPerSecond) {
        this.httpRequestsMaxPerSecond = httpRequestsMaxPerSecond;
        return this;
    }

    public WorkerConfig setConfigurationStoreServers(String configurationStoreServers) {
        this.configurationStoreServers = configurationStoreServers;
        return this;
    }

    public WorkerConfig setZooKeeperSessionTimeoutMillis(long zooKeeperSessionTimeoutMillis) {
        this.zooKeeperSessionTimeoutMillis = zooKeeperSessionTimeoutMillis;
        return this;
    }

    public WorkerConfig setZooKeeperOperationTimeoutSeconds(int zooKeeperOperationTimeoutSeconds) {
        this.zooKeeperOperationTimeoutSeconds = zooKeeperOperationTimeoutSeconds;
        return this;
    }

    public WorkerConfig setZooKeeperCacheExpirySeconds(int zooKeeperCacheExpirySeconds) {
        this.zooKeeperCacheExpirySeconds = zooKeeperCacheExpirySeconds;
        return this;
    }

    public WorkerConfig setConnectorsDirectory(String connectorsDirectory) {
        this.connectorsDirectory = connectorsDirectory;
        return this;
    }

    public WorkerConfig setNarExtractionDirectory(String narExtractionDirectory) {
        this.narExtractionDirectory = narExtractionDirectory;
        return this;
    }

    public WorkerConfig setValidateConnectorConfig(Boolean validateConnectorConfig) {
        this.validateConnectorConfig = validateConnectorConfig;
        return this;
    }

    public WorkerConfig setFunctionsDirectory(String functionsDirectory) {
        this.functionsDirectory = functionsDirectory;
        return this;
    }

    public WorkerConfig setFunctionMetadataTopicName(String functionMetadataTopicName) {
        this.functionMetadataTopicName = functionMetadataTopicName;
        return this;
    }

    public WorkerConfig setUseCompactedMetadataTopic(Boolean useCompactedMetadataTopic) {
        this.useCompactedMetadataTopic = useCompactedMetadataTopic;
        return this;
    }

    public WorkerConfig setFunctionWebServiceUrl(String functionWebServiceUrl) {
        this.functionWebServiceUrl = functionWebServiceUrl;
        return this;
    }

    public WorkerConfig setPulsarServiceUrl(String pulsarServiceUrl) {
        this.pulsarServiceUrl = pulsarServiceUrl;
        return this;
    }

    public WorkerConfig setPulsarWebServiceUrl(String pulsarWebServiceUrl) {
        this.pulsarWebServiceUrl = pulsarWebServiceUrl;
        return this;
    }

    public WorkerConfig setClusterCoordinationTopicName(String clusterCoordinationTopicName) {
        this.clusterCoordinationTopicName = clusterCoordinationTopicName;
        return this;
    }

    public WorkerConfig setPulsarFunctionsNamespace(String pulsarFunctionsNamespace) {
        this.pulsarFunctionsNamespace = pulsarFunctionsNamespace;
        return this;
    }

    public WorkerConfig setPulsarFunctionsCluster(String pulsarFunctionsCluster) {
        this.pulsarFunctionsCluster = pulsarFunctionsCluster;
        return this;
    }

    public WorkerConfig setNumFunctionPackageReplicas(int numFunctionPackageReplicas) {
        this.numFunctionPackageReplicas = numFunctionPackageReplicas;
        return this;
    }

    public WorkerConfig setDownloadDirectory(String downloadDirectory) {
        this.downloadDirectory = downloadDirectory;
        return this;
    }

    public WorkerConfig setStateStorageServiceUrl(String stateStorageServiceUrl) {
        this.stateStorageServiceUrl = stateStorageServiceUrl;
        return this;
    }

    public WorkerConfig setStateStorageProviderImplementation(String stateStorageProviderImplementation) {
        this.stateStorageProviderImplementation = stateStorageProviderImplementation;
        return this;
    }

    public WorkerConfig setFunctionAssignmentTopicName(String functionAssignmentTopicName) {
        this.functionAssignmentTopicName = functionAssignmentTopicName;
        return this;
    }

    public WorkerConfig setSchedulerClassName(String schedulerClassName) {
        this.schedulerClassName = schedulerClassName;
        return this;
    }

    public WorkerConfig setFailureCheckFreqMs(long failureCheckFreqMs) {
        this.failureCheckFreqMs = failureCheckFreqMs;
        return this;
    }

    public WorkerConfig setRescheduleTimeoutMs(long rescheduleTimeoutMs) {
        this.rescheduleTimeoutMs = rescheduleTimeoutMs;
        return this;
    }

    public WorkerConfig setRebalanceCheckFreqSec(long rebalanceCheckFreqSec) {
        this.rebalanceCheckFreqSec = rebalanceCheckFreqSec;
        return this;
    }

    public WorkerConfig setWorkerListProbeIntervalSec(int workerListProbeIntervalSec) {
        this.workerListProbeIntervalSec = workerListProbeIntervalSec;
        return this;
    }

    public WorkerConfig setInitialBrokerReconnectMaxRetries(int initialBrokerReconnectMaxRetries) {
        this.initialBrokerReconnectMaxRetries = initialBrokerReconnectMaxRetries;
        return this;
    }

    public WorkerConfig setAssignmentWriteMaxRetries(int assignmentWriteMaxRetries) {
        this.assignmentWriteMaxRetries = assignmentWriteMaxRetries;
        return this;
    }

    public WorkerConfig setInstanceLivenessCheckFreqMs(long instanceLivenessCheckFreqMs) {
        this.instanceLivenessCheckFreqMs = instanceLivenessCheckFreqMs;
        return this;
    }

    public WorkerConfig setBrokerClientAuthenticationEnabled(Boolean brokerClientAuthenticationEnabled) {
        this.brokerClientAuthenticationEnabled = brokerClientAuthenticationEnabled;
        return this;
    }

    public WorkerConfig setBrokerClientAuthenticationPlugin(String brokerClientAuthenticationPlugin) {
        this.brokerClientAuthenticationPlugin = brokerClientAuthenticationPlugin;
        return this;
    }

    public WorkerConfig setBrokerClientAuthenticationParameters(String brokerClientAuthenticationParameters) {
        this.brokerClientAuthenticationParameters = brokerClientAuthenticationParameters;
        return this;
    }

    public WorkerConfig setBookkeeperClientAuthenticationPlugin(String bookkeeperClientAuthenticationPlugin) {
        this.bookkeeperClientAuthenticationPlugin = bookkeeperClientAuthenticationPlugin;
        return this;
    }

    public WorkerConfig setBookkeeperClientAuthenticationParametersName(String bookkeeperClientAuthenticationParametersName) {
        this.bookkeeperClientAuthenticationParametersName = bookkeeperClientAuthenticationParametersName;
        return this;
    }

    public WorkerConfig setBookkeeperClientAuthenticationParameters(String bookkeeperClientAuthenticationParameters) {
        this.bookkeeperClientAuthenticationParameters = bookkeeperClientAuthenticationParameters;
        return this;
    }

    public WorkerConfig setTopicCompactionFrequencySec(long topicCompactionFrequencySec) {
        this.topicCompactionFrequencySec = topicCompactionFrequencySec;
        return this;
    }

    @Deprecated
    public WorkerConfig setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
        return this;
    }

    public WorkerConfig setTlsCertificateFilePath(String tlsCertificateFilePath) {
        this.tlsCertificateFilePath = tlsCertificateFilePath;
        return this;
    }

    public WorkerConfig setTlsKeyFilePath(String tlsKeyFilePath) {
        this.tlsKeyFilePath = tlsKeyFilePath;
        return this;
    }

    public WorkerConfig setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
        return this;
    }

    public WorkerConfig setTlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
        return this;
    }

    public WorkerConfig setTlsRequireTrustedClientCertOnConnect(boolean tlsRequireTrustedClientCertOnConnect) {
        this.tlsRequireTrustedClientCertOnConnect = tlsRequireTrustedClientCertOnConnect;
        return this;
    }

    @Deprecated
    public WorkerConfig setUseTls(boolean useTls) {
        this.useTls = useTls;
        return this;
    }

    public WorkerConfig setTlsEnableHostnameVerification(boolean tlsEnableHostnameVerification) {
        this.tlsEnableHostnameVerification = tlsEnableHostnameVerification;
        return this;
    }

    public WorkerConfig setTlsCertRefreshCheckDurationSec(long tlsCertRefreshCheckDurationSec) {
        this.tlsCertRefreshCheckDurationSec = tlsCertRefreshCheckDurationSec;
        return this;
    }

    public WorkerConfig setTlsEnabledWithKeyStore(boolean tlsEnabledWithKeyStore) {
        this.tlsEnabledWithKeyStore = tlsEnabledWithKeyStore;
        return this;
    }

    public WorkerConfig setTlsProvider(String tlsProvider) {
        this.tlsProvider = tlsProvider;
        return this;
    }

    public WorkerConfig setTlsKeyStoreType(String tlsKeyStoreType) {
        this.tlsKeyStoreType = tlsKeyStoreType;
        return this;
    }

    public WorkerConfig setTlsKeyStore(String tlsKeyStore) {
        this.tlsKeyStore = tlsKeyStore;
        return this;
    }

    public WorkerConfig setTlsKeyStorePassword(String tlsKeyStorePassword) {
        this.tlsKeyStorePassword = tlsKeyStorePassword;
        return this;
    }

    public WorkerConfig setTlsTrustStoreType(String tlsTrustStoreType) {
        this.tlsTrustStoreType = tlsTrustStoreType;
        return this;
    }

    public WorkerConfig setTlsTrustStore(String tlsTrustStore) {
        this.tlsTrustStore = tlsTrustStore;
        return this;
    }

    public WorkerConfig setTlsTrustStorePassword(String tlsTrustStorePassword) {
        this.tlsTrustStorePassword = tlsTrustStorePassword;
        return this;
    }

    public WorkerConfig setWebServiceTlsProtocols(Set<String> webServiceTlsProtocols) {
        this.webServiceTlsProtocols = webServiceTlsProtocols;
        return this;
    }

    public WorkerConfig setWebServiceTlsCiphers(Set<String> webServiceTlsCiphers) {
        this.webServiceTlsCiphers = webServiceTlsCiphers;
        return this;
    }

    public WorkerConfig setAuthenticationEnabled(boolean authenticationEnabled) {
        this.authenticationEnabled = authenticationEnabled;
        return this;
    }

    public WorkerConfig setAuthenticationProviders(Set<String> authenticationProviders) {
        this.authenticationProviders = authenticationProviders;
        return this;
    }

    public WorkerConfig setAuthorizationEnabled(boolean authorizationEnabled) {
        this.authorizationEnabled = authorizationEnabled;
        return this;
    }

    public WorkerConfig setAuthorizationProvider(String authorizationProvider) {
        this.authorizationProvider = authorizationProvider;
        return this;
    }

    public WorkerConfig setSuperUserRoles(Set<String> superUserRoles) {
        this.superUserRoles = superUserRoles;
        return this;
    }

    public WorkerConfig setInitializedDlogMetadata(Boolean initializedDlogMetadata) {
        this.initializedDlogMetadata = initializedDlogMetadata;
        return this;
    }

    public WorkerConfig setBrokerClientTrustCertsFilePath(String brokerClientTrustCertsFilePath) {
        this.brokerClientTrustCertsFilePath = brokerClientTrustCertsFilePath;
        return this;
    }

    public WorkerConfig setFunctionRuntimeFactoryClassName(String functionRuntimeFactoryClassName) {
        this.functionRuntimeFactoryClassName = functionRuntimeFactoryClassName;
        return this;
    }

    public WorkerConfig setFunctionRuntimeFactoryConfigs(Map<String, Object> functionRuntimeFactoryConfigs) {
        this.functionRuntimeFactoryConfigs = functionRuntimeFactoryConfigs;
        return this;
    }

    public WorkerConfig setSecretsProviderConfiguratorClassName(String secretsProviderConfiguratorClassName) {
        this.secretsProviderConfiguratorClassName = secretsProviderConfiguratorClassName;
        return this;
    }

    public WorkerConfig setSecretsProviderConfiguratorConfig(Map<String, String> secretsProviderConfiguratorConfig) {
        this.secretsProviderConfiguratorConfig = secretsProviderConfiguratorConfig;
        return this;
    }

    public WorkerConfig setFunctionInstanceMinResources(Resources functionInstanceMinResources) {
        this.functionInstanceMinResources = functionInstanceMinResources;
        return this;
    }

    public WorkerConfig setFunctionInstanceMaxResources(Resources functionInstanceMaxResources) {
        this.functionInstanceMaxResources = functionInstanceMaxResources;
        return this;
    }

    public WorkerConfig setFunctionInstanceResourceGranularities(Resources functionInstanceResourceGranularities) {
        this.functionInstanceResourceGranularities = functionInstanceResourceGranularities;
        return this;
    }

    public WorkerConfig setFunctionInstanceResourceChangeInLockStep(boolean functionInstanceResourceChangeInLockStep) {
        this.functionInstanceResourceChangeInLockStep = functionInstanceResourceChangeInLockStep;
        return this;
    }

    public WorkerConfig setFunctionAuthProviderClassName(String functionAuthProviderClassName) {
        this.functionAuthProviderClassName = functionAuthProviderClassName;
        return this;
    }

    public WorkerConfig setRuntimeCustomizerClassName(String runtimeCustomizerClassName) {
        this.runtimeCustomizerClassName = runtimeCustomizerClassName;
        return this;
    }

    public WorkerConfig setRuntimeCustomizerConfig(Map<String, Object> runtimeCustomizerConfig) {
        this.runtimeCustomizerConfig = runtimeCustomizerConfig;
        return this;
    }

    public WorkerConfig setMaxPendingAsyncRequests(int maxPendingAsyncRequests) {
        this.maxPendingAsyncRequests = maxPendingAsyncRequests;
        return this;
    }

    public WorkerConfig setForwardSourceMessageProperty(boolean forwardSourceMessageProperty) {
        this.forwardSourceMessageProperty = forwardSourceMessageProperty;
        return this;
    }

    public WorkerConfig setFunctionsWorkerServiceNarPackage(String functionsWorkerServiceNarPackage) {
        this.functionsWorkerServiceNarPackage = functionsWorkerServiceNarPackage;
        return this;
    }

    public WorkerConfig setFunctionsWorkerServiceCustomConfigs(Map<String, Object> functionsWorkerServiceCustomConfigs) {
        this.functionsWorkerServiceCustomConfigs = functionsWorkerServiceCustomConfigs;
        return this;
    }

    public WorkerConfig setExposeAdminClientEnabled(boolean exposeAdminClientEnabled) {
        this.exposeAdminClientEnabled = exposeAdminClientEnabled;
        return this;
    }

    @Deprecated
    public WorkerConfig setThreadContainerFactory(ThreadContainerFactory threadContainerFactory) {
        this.threadContainerFactory = threadContainerFactory;
        return this;
    }

    @Deprecated
    public WorkerConfig setProcessContainerFactory(ProcessContainerFactory processContainerFactory) {
        this.processContainerFactory = processContainerFactory;
        return this;
    }

    @Deprecated
    public WorkerConfig setKubernetesContainerFactory(KubernetesContainerFactory kubernetesContainerFactory) {
        this.kubernetesContainerFactory = kubernetesContainerFactory;
        return this;
    }

    @Deprecated
    public WorkerConfig setClientAuthenticationParameters(String clientAuthenticationParameters) {
        this.clientAuthenticationParameters = clientAuthenticationParameters;
        return this;
    }

    @Deprecated
    public WorkerConfig setClientAuthenticationPlugin(String clientAuthenticationPlugin) {
        this.clientAuthenticationPlugin = clientAuthenticationPlugin;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkerConfig)) {
            return false;
        }
        WorkerConfig other = (WorkerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAuthenticateMetricsEndpoint() != other.isAuthenticateMetricsEndpoint()) {
            return false;
        }
        if (this.isIncludeStandardPrometheusMetrics() != other.isIncludeStandardPrometheusMetrics()) {
            return false;
        }
        if (this.getNumHttpServerThreads() != other.getNumHttpServerThreads()) {
            return false;
        }
        if (this.isHttpRequestsLimitEnabled() != other.isHttpRequestsLimitEnabled()) {
            return false;
        }
        if (Double.compare(this.getHttpRequestsMaxPerSecond(), other.getHttpRequestsMaxPerSecond()) != 0) {
            return false;
        }
        if (this.getZooKeeperSessionTimeoutMillis() != other.getZooKeeperSessionTimeoutMillis()) {
            return false;
        }
        if (this.getZooKeeperOperationTimeoutSeconds() != other.getZooKeeperOperationTimeoutSeconds()) {
            return false;
        }
        if (this.getZooKeeperCacheExpirySeconds() != other.getZooKeeperCacheExpirySeconds()) {
            return false;
        }
        if (this.getNumFunctionPackageReplicas() != other.getNumFunctionPackageReplicas()) {
            return false;
        }
        if (this.getFailureCheckFreqMs() != other.getFailureCheckFreqMs()) {
            return false;
        }
        if (this.getRescheduleTimeoutMs() != other.getRescheduleTimeoutMs()) {
            return false;
        }
        if (this.getRebalanceCheckFreqSec() != other.getRebalanceCheckFreqSec()) {
            return false;
        }
        if (this.getWorkerListProbeIntervalSec() != other.getWorkerListProbeIntervalSec()) {
            return false;
        }
        if (this.getInitialBrokerReconnectMaxRetries() != other.getInitialBrokerReconnectMaxRetries()) {
            return false;
        }
        if (this.getAssignmentWriteMaxRetries() != other.getAssignmentWriteMaxRetries()) {
            return false;
        }
        if (this.getInstanceLivenessCheckFreqMs() != other.getInstanceLivenessCheckFreqMs()) {
            return false;
        }
        if (this.getTopicCompactionFrequencySec() != other.getTopicCompactionFrequencySec()) {
            return false;
        }
        if (this.getTlsEnabled() != other.getTlsEnabled()) {
            return false;
        }
        if (this.isTlsAllowInsecureConnection() != other.isTlsAllowInsecureConnection()) {
            return false;
        }
        if (this.isTlsRequireTrustedClientCertOnConnect() != other.isTlsRequireTrustedClientCertOnConnect()) {
            return false;
        }
        if (this.isUseTls() != other.isUseTls()) {
            return false;
        }
        if (this.isTlsEnableHostnameVerification() != other.isTlsEnableHostnameVerification()) {
            return false;
        }
        if (this.getTlsCertRefreshCheckDurationSec() != other.getTlsCertRefreshCheckDurationSec()) {
            return false;
        }
        if (this.isTlsEnabledWithKeyStore() != other.isTlsEnabledWithKeyStore()) {
            return false;
        }
        if (this.isAuthenticationEnabled() != other.isAuthenticationEnabled()) {
            return false;
        }
        if (this.isAuthorizationEnabled() != other.isAuthorizationEnabled()) {
            return false;
        }
        if (this.isFunctionInstanceResourceChangeInLockStep() != other.isFunctionInstanceResourceChangeInLockStep()) {
            return false;
        }
        if (this.getMaxPendingAsyncRequests() != other.getMaxPendingAsyncRequests()) {
            return false;
        }
        if (this.isForwardSourceMessageProperty() != other.isForwardSourceMessageProperty()) {
            return false;
        }
        if (this.isExposeAdminClientEnabled() != other.isExposeAdminClientEnabled()) {
            return false;
        }
        Integer this$workerPort = this.getWorkerPort();
        Integer other$workerPort = other.getWorkerPort();
        if (this$workerPort == null ? other$workerPort != null : !((Object)this$workerPort).equals(other$workerPort)) {
            return false;
        }
        Integer this$workerPortTls = this.getWorkerPortTls();
        Integer other$workerPortTls = other.getWorkerPortTls();
        if (this$workerPortTls == null ? other$workerPortTls != null : !((Object)this$workerPortTls).equals(other$workerPortTls)) {
            return false;
        }
        Boolean this$validateConnectorConfig = this.getValidateConnectorConfig();
        Boolean other$validateConnectorConfig = other.getValidateConnectorConfig();
        if (this$validateConnectorConfig == null ? other$validateConnectorConfig != null : !((Object)this$validateConnectorConfig).equals(other$validateConnectorConfig)) {
            return false;
        }
        Boolean this$useCompactedMetadataTopic = this.getUseCompactedMetadataTopic();
        Boolean other$useCompactedMetadataTopic = other.getUseCompactedMetadataTopic();
        if (this$useCompactedMetadataTopic == null ? other$useCompactedMetadataTopic != null : !((Object)this$useCompactedMetadataTopic).equals(other$useCompactedMetadataTopic)) {
            return false;
        }
        Boolean this$brokerClientAuthenticationEnabled = this.getBrokerClientAuthenticationEnabled();
        Boolean other$brokerClientAuthenticationEnabled = other.getBrokerClientAuthenticationEnabled();
        if (this$brokerClientAuthenticationEnabled == null ? other$brokerClientAuthenticationEnabled != null : !((Object)this$brokerClientAuthenticationEnabled).equals(other$brokerClientAuthenticationEnabled)) {
            return false;
        }
        Boolean this$initializedDlogMetadata = this.getInitializedDlogMetadata();
        Boolean other$initializedDlogMetadata = other.getInitializedDlogMetadata();
        if (this$initializedDlogMetadata == null ? other$initializedDlogMetadata != null : !((Object)this$initializedDlogMetadata).equals(other$initializedDlogMetadata)) {
            return false;
        }
        String this$workerId = this.getWorkerId();
        String other$workerId = other.getWorkerId();
        if (this$workerId == null ? other$workerId != null : !this$workerId.equals(other$workerId)) {
            return false;
        }
        String this$workerHostname = this.getWorkerHostname();
        String other$workerHostname = other.getWorkerHostname();
        if (this$workerHostname == null ? other$workerHostname != null : !this$workerHostname.equals(other$workerHostname)) {
            return false;
        }
        String this$jvmGCMetricsLoggerClassName = this.getJvmGCMetricsLoggerClassName();
        String other$jvmGCMetricsLoggerClassName = other.getJvmGCMetricsLoggerClassName();
        if (this$jvmGCMetricsLoggerClassName == null ? other$jvmGCMetricsLoggerClassName != null : !this$jvmGCMetricsLoggerClassName.equals(other$jvmGCMetricsLoggerClassName)) {
            return false;
        }
        String this$configurationStoreServers = this.getConfigurationStoreServers();
        String other$configurationStoreServers = other.getConfigurationStoreServers();
        if (this$configurationStoreServers == null ? other$configurationStoreServers != null : !this$configurationStoreServers.equals(other$configurationStoreServers)) {
            return false;
        }
        String this$connectorsDirectory = this.getConnectorsDirectory();
        String other$connectorsDirectory = other.getConnectorsDirectory();
        if (this$connectorsDirectory == null ? other$connectorsDirectory != null : !this$connectorsDirectory.equals(other$connectorsDirectory)) {
            return false;
        }
        String this$narExtractionDirectory = this.getNarExtractionDirectory();
        String other$narExtractionDirectory = other.getNarExtractionDirectory();
        if (this$narExtractionDirectory == null ? other$narExtractionDirectory != null : !this$narExtractionDirectory.equals(other$narExtractionDirectory)) {
            return false;
        }
        String this$functionsDirectory = this.getFunctionsDirectory();
        String other$functionsDirectory = other.getFunctionsDirectory();
        if (this$functionsDirectory == null ? other$functionsDirectory != null : !this$functionsDirectory.equals(other$functionsDirectory)) {
            return false;
        }
        String this$functionMetadataTopicName = this.getFunctionMetadataTopicName();
        String other$functionMetadataTopicName = other.getFunctionMetadataTopicName();
        if (this$functionMetadataTopicName == null ? other$functionMetadataTopicName != null : !this$functionMetadataTopicName.equals(other$functionMetadataTopicName)) {
            return false;
        }
        String this$functionWebServiceUrl = this.getFunctionWebServiceUrl();
        String other$functionWebServiceUrl = other.getFunctionWebServiceUrl();
        if (this$functionWebServiceUrl == null ? other$functionWebServiceUrl != null : !this$functionWebServiceUrl.equals(other$functionWebServiceUrl)) {
            return false;
        }
        String this$pulsarServiceUrl = this.getPulsarServiceUrl();
        String other$pulsarServiceUrl = other.getPulsarServiceUrl();
        if (this$pulsarServiceUrl == null ? other$pulsarServiceUrl != null : !this$pulsarServiceUrl.equals(other$pulsarServiceUrl)) {
            return false;
        }
        String this$pulsarWebServiceUrl = this.getPulsarWebServiceUrl();
        String other$pulsarWebServiceUrl = other.getPulsarWebServiceUrl();
        if (this$pulsarWebServiceUrl == null ? other$pulsarWebServiceUrl != null : !this$pulsarWebServiceUrl.equals(other$pulsarWebServiceUrl)) {
            return false;
        }
        String this$clusterCoordinationTopicName = this.getClusterCoordinationTopicName();
        String other$clusterCoordinationTopicName = other.getClusterCoordinationTopicName();
        if (this$clusterCoordinationTopicName == null ? other$clusterCoordinationTopicName != null : !this$clusterCoordinationTopicName.equals(other$clusterCoordinationTopicName)) {
            return false;
        }
        String this$pulsarFunctionsNamespace = this.getPulsarFunctionsNamespace();
        String other$pulsarFunctionsNamespace = other.getPulsarFunctionsNamespace();
        if (this$pulsarFunctionsNamespace == null ? other$pulsarFunctionsNamespace != null : !this$pulsarFunctionsNamespace.equals(other$pulsarFunctionsNamespace)) {
            return false;
        }
        String this$pulsarFunctionsCluster = this.getPulsarFunctionsCluster();
        String other$pulsarFunctionsCluster = other.getPulsarFunctionsCluster();
        if (this$pulsarFunctionsCluster == null ? other$pulsarFunctionsCluster != null : !this$pulsarFunctionsCluster.equals(other$pulsarFunctionsCluster)) {
            return false;
        }
        String this$downloadDirectory = this.getDownloadDirectory();
        String other$downloadDirectory = other.getDownloadDirectory();
        if (this$downloadDirectory == null ? other$downloadDirectory != null : !this$downloadDirectory.equals(other$downloadDirectory)) {
            return false;
        }
        String this$stateStorageServiceUrl = this.getStateStorageServiceUrl();
        String other$stateStorageServiceUrl = other.getStateStorageServiceUrl();
        if (this$stateStorageServiceUrl == null ? other$stateStorageServiceUrl != null : !this$stateStorageServiceUrl.equals(other$stateStorageServiceUrl)) {
            return false;
        }
        String this$stateStorageProviderImplementation = this.getStateStorageProviderImplementation();
        String other$stateStorageProviderImplementation = other.getStateStorageProviderImplementation();
        if (this$stateStorageProviderImplementation == null ? other$stateStorageProviderImplementation != null : !this$stateStorageProviderImplementation.equals(other$stateStorageProviderImplementation)) {
            return false;
        }
        String this$functionAssignmentTopicName = this.getFunctionAssignmentTopicName();
        String other$functionAssignmentTopicName = other.getFunctionAssignmentTopicName();
        if (this$functionAssignmentTopicName == null ? other$functionAssignmentTopicName != null : !this$functionAssignmentTopicName.equals(other$functionAssignmentTopicName)) {
            return false;
        }
        String this$schedulerClassName = this.getSchedulerClassName();
        String other$schedulerClassName = other.getSchedulerClassName();
        if (this$schedulerClassName == null ? other$schedulerClassName != null : !this$schedulerClassName.equals(other$schedulerClassName)) {
            return false;
        }
        String this$brokerClientAuthenticationPlugin = this.getBrokerClientAuthenticationPlugin();
        String other$brokerClientAuthenticationPlugin = other.getBrokerClientAuthenticationPlugin();
        if (this$brokerClientAuthenticationPlugin == null ? other$brokerClientAuthenticationPlugin != null : !this$brokerClientAuthenticationPlugin.equals(other$brokerClientAuthenticationPlugin)) {
            return false;
        }
        String this$brokerClientAuthenticationParameters = this.getBrokerClientAuthenticationParameters();
        String other$brokerClientAuthenticationParameters = other.getBrokerClientAuthenticationParameters();
        if (this$brokerClientAuthenticationParameters == null ? other$brokerClientAuthenticationParameters != null : !this$brokerClientAuthenticationParameters.equals(other$brokerClientAuthenticationParameters)) {
            return false;
        }
        String this$bookkeeperClientAuthenticationPlugin = this.getBookkeeperClientAuthenticationPlugin();
        String other$bookkeeperClientAuthenticationPlugin = other.getBookkeeperClientAuthenticationPlugin();
        if (this$bookkeeperClientAuthenticationPlugin == null ? other$bookkeeperClientAuthenticationPlugin != null : !this$bookkeeperClientAuthenticationPlugin.equals(other$bookkeeperClientAuthenticationPlugin)) {
            return false;
        }
        String this$bookkeeperClientAuthenticationParametersName = this.getBookkeeperClientAuthenticationParametersName();
        String other$bookkeeperClientAuthenticationParametersName = other.getBookkeeperClientAuthenticationParametersName();
        if (this$bookkeeperClientAuthenticationParametersName == null ? other$bookkeeperClientAuthenticationParametersName != null : !this$bookkeeperClientAuthenticationParametersName.equals(other$bookkeeperClientAuthenticationParametersName)) {
            return false;
        }
        String this$bookkeeperClientAuthenticationParameters = this.getBookkeeperClientAuthenticationParameters();
        String other$bookkeeperClientAuthenticationParameters = other.getBookkeeperClientAuthenticationParameters();
        if (this$bookkeeperClientAuthenticationParameters == null ? other$bookkeeperClientAuthenticationParameters != null : !this$bookkeeperClientAuthenticationParameters.equals(other$bookkeeperClientAuthenticationParameters)) {
            return false;
        }
        String this$tlsCertificateFilePath = this.getTlsCertificateFilePath();
        String other$tlsCertificateFilePath = other.getTlsCertificateFilePath();
        if (this$tlsCertificateFilePath == null ? other$tlsCertificateFilePath != null : !this$tlsCertificateFilePath.equals(other$tlsCertificateFilePath)) {
            return false;
        }
        String this$tlsKeyFilePath = this.getTlsKeyFilePath();
        String other$tlsKeyFilePath = other.getTlsKeyFilePath();
        if (this$tlsKeyFilePath == null ? other$tlsKeyFilePath != null : !this$tlsKeyFilePath.equals(other$tlsKeyFilePath)) {
            return false;
        }
        String this$tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
        String other$tlsTrustCertsFilePath = other.getTlsTrustCertsFilePath();
        if (this$tlsTrustCertsFilePath == null ? other$tlsTrustCertsFilePath != null : !this$tlsTrustCertsFilePath.equals(other$tlsTrustCertsFilePath)) {
            return false;
        }
        String this$tlsProvider = this.getTlsProvider();
        String other$tlsProvider = other.getTlsProvider();
        if (this$tlsProvider == null ? other$tlsProvider != null : !this$tlsProvider.equals(other$tlsProvider)) {
            return false;
        }
        String this$tlsKeyStoreType = this.getTlsKeyStoreType();
        String other$tlsKeyStoreType = other.getTlsKeyStoreType();
        if (this$tlsKeyStoreType == null ? other$tlsKeyStoreType != null : !this$tlsKeyStoreType.equals(other$tlsKeyStoreType)) {
            return false;
        }
        String this$tlsKeyStore = this.getTlsKeyStore();
        String other$tlsKeyStore = other.getTlsKeyStore();
        if (this$tlsKeyStore == null ? other$tlsKeyStore != null : !this$tlsKeyStore.equals(other$tlsKeyStore)) {
            return false;
        }
        String this$tlsKeyStorePassword = this.getTlsKeyStorePassword();
        String other$tlsKeyStorePassword = other.getTlsKeyStorePassword();
        if (this$tlsKeyStorePassword == null ? other$tlsKeyStorePassword != null : !this$tlsKeyStorePassword.equals(other$tlsKeyStorePassword)) {
            return false;
        }
        String this$tlsTrustStoreType = this.getTlsTrustStoreType();
        String other$tlsTrustStoreType = other.getTlsTrustStoreType();
        if (this$tlsTrustStoreType == null ? other$tlsTrustStoreType != null : !this$tlsTrustStoreType.equals(other$tlsTrustStoreType)) {
            return false;
        }
        String this$tlsTrustStore = this.getTlsTrustStore();
        String other$tlsTrustStore = other.getTlsTrustStore();
        if (this$tlsTrustStore == null ? other$tlsTrustStore != null : !this$tlsTrustStore.equals(other$tlsTrustStore)) {
            return false;
        }
        String this$tlsTrustStorePassword = this.getTlsTrustStorePassword();
        String other$tlsTrustStorePassword = other.getTlsTrustStorePassword();
        if (this$tlsTrustStorePassword == null ? other$tlsTrustStorePassword != null : !this$tlsTrustStorePassword.equals(other$tlsTrustStorePassword)) {
            return false;
        }
        Set<String> this$webServiceTlsProtocols = this.getWebServiceTlsProtocols();
        Set<String> other$webServiceTlsProtocols = other.getWebServiceTlsProtocols();
        if (this$webServiceTlsProtocols == null ? other$webServiceTlsProtocols != null : !((Object)this$webServiceTlsProtocols).equals(other$webServiceTlsProtocols)) {
            return false;
        }
        Set<String> this$webServiceTlsCiphers = this.getWebServiceTlsCiphers();
        Set<String> other$webServiceTlsCiphers = other.getWebServiceTlsCiphers();
        if (this$webServiceTlsCiphers == null ? other$webServiceTlsCiphers != null : !((Object)this$webServiceTlsCiphers).equals(other$webServiceTlsCiphers)) {
            return false;
        }
        Set<String> this$authenticationProviders = this.getAuthenticationProviders();
        Set<String> other$authenticationProviders = other.getAuthenticationProviders();
        if (this$authenticationProviders == null ? other$authenticationProviders != null : !((Object)this$authenticationProviders).equals(other$authenticationProviders)) {
            return false;
        }
        String this$authorizationProvider = this.getAuthorizationProvider();
        String other$authorizationProvider = other.getAuthorizationProvider();
        if (this$authorizationProvider == null ? other$authorizationProvider != null : !this$authorizationProvider.equals(other$authorizationProvider)) {
            return false;
        }
        Set<String> this$superUserRoles = this.getSuperUserRoles();
        Set<String> other$superUserRoles = other.getSuperUserRoles();
        if (this$superUserRoles == null ? other$superUserRoles != null : !((Object)this$superUserRoles).equals(other$superUserRoles)) {
            return false;
        }
        Properties this$properties = this.getProperties();
        Properties other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$brokerClientTrustCertsFilePath = this.getBrokerClientTrustCertsFilePath();
        String other$brokerClientTrustCertsFilePath = other.getBrokerClientTrustCertsFilePath();
        if (this$brokerClientTrustCertsFilePath == null ? other$brokerClientTrustCertsFilePath != null : !this$brokerClientTrustCertsFilePath.equals(other$brokerClientTrustCertsFilePath)) {
            return false;
        }
        String this$functionRuntimeFactoryClassName = this.getFunctionRuntimeFactoryClassName();
        String other$functionRuntimeFactoryClassName = other.getFunctionRuntimeFactoryClassName();
        if (this$functionRuntimeFactoryClassName == null ? other$functionRuntimeFactoryClassName != null : !this$functionRuntimeFactoryClassName.equals(other$functionRuntimeFactoryClassName)) {
            return false;
        }
        Map<String, Object> this$functionRuntimeFactoryConfigs = this.getFunctionRuntimeFactoryConfigs();
        Map<String, Object> other$functionRuntimeFactoryConfigs = other.getFunctionRuntimeFactoryConfigs();
        if (this$functionRuntimeFactoryConfigs == null ? other$functionRuntimeFactoryConfigs != null : !((Object)this$functionRuntimeFactoryConfigs).equals(other$functionRuntimeFactoryConfigs)) {
            return false;
        }
        String this$secretsProviderConfiguratorClassName = this.getSecretsProviderConfiguratorClassName();
        String other$secretsProviderConfiguratorClassName = other.getSecretsProviderConfiguratorClassName();
        if (this$secretsProviderConfiguratorClassName == null ? other$secretsProviderConfiguratorClassName != null : !this$secretsProviderConfiguratorClassName.equals(other$secretsProviderConfiguratorClassName)) {
            return false;
        }
        Map<String, String> this$secretsProviderConfiguratorConfig = this.getSecretsProviderConfiguratorConfig();
        Map<String, String> other$secretsProviderConfiguratorConfig = other.getSecretsProviderConfiguratorConfig();
        if (this$secretsProviderConfiguratorConfig == null ? other$secretsProviderConfiguratorConfig != null : !((Object)this$secretsProviderConfiguratorConfig).equals(other$secretsProviderConfiguratorConfig)) {
            return false;
        }
        Resources this$functionInstanceMinResources = this.getFunctionInstanceMinResources();
        Resources other$functionInstanceMinResources = other.getFunctionInstanceMinResources();
        if (this$functionInstanceMinResources == null ? other$functionInstanceMinResources != null : !this$functionInstanceMinResources.equals(other$functionInstanceMinResources)) {
            return false;
        }
        Resources this$functionInstanceMaxResources = this.getFunctionInstanceMaxResources();
        Resources other$functionInstanceMaxResources = other.getFunctionInstanceMaxResources();
        if (this$functionInstanceMaxResources == null ? other$functionInstanceMaxResources != null : !this$functionInstanceMaxResources.equals(other$functionInstanceMaxResources)) {
            return false;
        }
        Resources this$functionInstanceResourceGranularities = this.getFunctionInstanceResourceGranularities();
        Resources other$functionInstanceResourceGranularities = other.getFunctionInstanceResourceGranularities();
        if (this$functionInstanceResourceGranularities == null ? other$functionInstanceResourceGranularities != null : !this$functionInstanceResourceGranularities.equals(other$functionInstanceResourceGranularities)) {
            return false;
        }
        String this$functionAuthProviderClassName = this.getFunctionAuthProviderClassName();
        String other$functionAuthProviderClassName = other.getFunctionAuthProviderClassName();
        if (this$functionAuthProviderClassName == null ? other$functionAuthProviderClassName != null : !this$functionAuthProviderClassName.equals(other$functionAuthProviderClassName)) {
            return false;
        }
        String this$runtimeCustomizerClassName = this.getRuntimeCustomizerClassName();
        String other$runtimeCustomizerClassName = other.getRuntimeCustomizerClassName();
        if (this$runtimeCustomizerClassName == null ? other$runtimeCustomizerClassName != null : !this$runtimeCustomizerClassName.equals(other$runtimeCustomizerClassName)) {
            return false;
        }
        Map<String, Object> this$runtimeCustomizerConfig = this.getRuntimeCustomizerConfig();
        Map<String, Object> other$runtimeCustomizerConfig = other.getRuntimeCustomizerConfig();
        if (this$runtimeCustomizerConfig == null ? other$runtimeCustomizerConfig != null : !((Object)this$runtimeCustomizerConfig).equals(other$runtimeCustomizerConfig)) {
            return false;
        }
        String this$functionsWorkerServiceNarPackage = this.getFunctionsWorkerServiceNarPackage();
        String other$functionsWorkerServiceNarPackage = other.getFunctionsWorkerServiceNarPackage();
        if (this$functionsWorkerServiceNarPackage == null ? other$functionsWorkerServiceNarPackage != null : !this$functionsWorkerServiceNarPackage.equals(other$functionsWorkerServiceNarPackage)) {
            return false;
        }
        Map<String, Object> this$functionsWorkerServiceCustomConfigs = this.getFunctionsWorkerServiceCustomConfigs();
        Map<String, Object> other$functionsWorkerServiceCustomConfigs = other.getFunctionsWorkerServiceCustomConfigs();
        if (this$functionsWorkerServiceCustomConfigs == null ? other$functionsWorkerServiceCustomConfigs != null : !((Object)this$functionsWorkerServiceCustomConfigs).equals(other$functionsWorkerServiceCustomConfigs)) {
            return false;
        }
        ThreadContainerFactory this$threadContainerFactory = this.getThreadContainerFactory();
        ThreadContainerFactory other$threadContainerFactory = other.getThreadContainerFactory();
        if (this$threadContainerFactory == null ? other$threadContainerFactory != null : !((Object)this$threadContainerFactory).equals(other$threadContainerFactory)) {
            return false;
        }
        ProcessContainerFactory this$processContainerFactory = this.getProcessContainerFactory();
        ProcessContainerFactory other$processContainerFactory = other.getProcessContainerFactory();
        if (this$processContainerFactory == null ? other$processContainerFactory != null : !((Object)this$processContainerFactory).equals(other$processContainerFactory)) {
            return false;
        }
        KubernetesContainerFactory this$kubernetesContainerFactory = this.getKubernetesContainerFactory();
        KubernetesContainerFactory other$kubernetesContainerFactory = other.getKubernetesContainerFactory();
        if (this$kubernetesContainerFactory == null ? other$kubernetesContainerFactory != null : !((Object)this$kubernetesContainerFactory).equals(other$kubernetesContainerFactory)) {
            return false;
        }
        String this$clientAuthenticationParameters = this.getClientAuthenticationParameters();
        String other$clientAuthenticationParameters = other.getClientAuthenticationParameters();
        if (this$clientAuthenticationParameters == null ? other$clientAuthenticationParameters != null : !this$clientAuthenticationParameters.equals(other$clientAuthenticationParameters)) {
            return false;
        }
        String this$clientAuthenticationPlugin = this.getClientAuthenticationPlugin();
        String other$clientAuthenticationPlugin = other.getClientAuthenticationPlugin();
        return !(this$clientAuthenticationPlugin == null ? other$clientAuthenticationPlugin != null : !this$clientAuthenticationPlugin.equals(other$clientAuthenticationPlugin));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAuthenticateMetricsEndpoint() ? 79 : 97);
        result = result * 59 + (this.isIncludeStandardPrometheusMetrics() ? 79 : 97);
        result = result * 59 + this.getNumHttpServerThreads();
        result = result * 59 + (this.isHttpRequestsLimitEnabled() ? 79 : 97);
        long $httpRequestsMaxPerSecond = Double.doubleToLongBits(this.getHttpRequestsMaxPerSecond());
        result = result * 59 + (int)($httpRequestsMaxPerSecond >>> 32 ^ $httpRequestsMaxPerSecond);
        long $zooKeeperSessionTimeoutMillis = this.getZooKeeperSessionTimeoutMillis();
        result = result * 59 + (int)($zooKeeperSessionTimeoutMillis >>> 32 ^ $zooKeeperSessionTimeoutMillis);
        result = result * 59 + this.getZooKeeperOperationTimeoutSeconds();
        result = result * 59 + this.getZooKeeperCacheExpirySeconds();
        result = result * 59 + this.getNumFunctionPackageReplicas();
        long $failureCheckFreqMs = this.getFailureCheckFreqMs();
        result = result * 59 + (int)($failureCheckFreqMs >>> 32 ^ $failureCheckFreqMs);
        long $rescheduleTimeoutMs = this.getRescheduleTimeoutMs();
        result = result * 59 + (int)($rescheduleTimeoutMs >>> 32 ^ $rescheduleTimeoutMs);
        long $rebalanceCheckFreqSec = this.getRebalanceCheckFreqSec();
        result = result * 59 + (int)($rebalanceCheckFreqSec >>> 32 ^ $rebalanceCheckFreqSec);
        result = result * 59 + this.getWorkerListProbeIntervalSec();
        result = result * 59 + this.getInitialBrokerReconnectMaxRetries();
        result = result * 59 + this.getAssignmentWriteMaxRetries();
        long $instanceLivenessCheckFreqMs = this.getInstanceLivenessCheckFreqMs();
        result = result * 59 + (int)($instanceLivenessCheckFreqMs >>> 32 ^ $instanceLivenessCheckFreqMs);
        long $topicCompactionFrequencySec = this.getTopicCompactionFrequencySec();
        result = result * 59 + (int)($topicCompactionFrequencySec >>> 32 ^ $topicCompactionFrequencySec);
        result = result * 59 + (this.getTlsEnabled() ? 79 : 97);
        result = result * 59 + (this.isTlsAllowInsecureConnection() ? 79 : 97);
        result = result * 59 + (this.isTlsRequireTrustedClientCertOnConnect() ? 79 : 97);
        result = result * 59 + (this.isUseTls() ? 79 : 97);
        result = result * 59 + (this.isTlsEnableHostnameVerification() ? 79 : 97);
        long $tlsCertRefreshCheckDurationSec = this.getTlsCertRefreshCheckDurationSec();
        result = result * 59 + (int)($tlsCertRefreshCheckDurationSec >>> 32 ^ $tlsCertRefreshCheckDurationSec);
        result = result * 59 + (this.isTlsEnabledWithKeyStore() ? 79 : 97);
        result = result * 59 + (this.isAuthenticationEnabled() ? 79 : 97);
        result = result * 59 + (this.isAuthorizationEnabled() ? 79 : 97);
        result = result * 59 + (this.isFunctionInstanceResourceChangeInLockStep() ? 79 : 97);
        result = result * 59 + this.getMaxPendingAsyncRequests();
        result = result * 59 + (this.isForwardSourceMessageProperty() ? 79 : 97);
        result = result * 59 + (this.isExposeAdminClientEnabled() ? 79 : 97);
        Integer $workerPort = this.getWorkerPort();
        result = result * 59 + ($workerPort == null ? 43 : ((Object)$workerPort).hashCode());
        Integer $workerPortTls = this.getWorkerPortTls();
        result = result * 59 + ($workerPortTls == null ? 43 : ((Object)$workerPortTls).hashCode());
        Boolean $validateConnectorConfig = this.getValidateConnectorConfig();
        result = result * 59 + ($validateConnectorConfig == null ? 43 : ((Object)$validateConnectorConfig).hashCode());
        Boolean $useCompactedMetadataTopic = this.getUseCompactedMetadataTopic();
        result = result * 59 + ($useCompactedMetadataTopic == null ? 43 : ((Object)$useCompactedMetadataTopic).hashCode());
        Boolean $brokerClientAuthenticationEnabled = this.getBrokerClientAuthenticationEnabled();
        result = result * 59 + ($brokerClientAuthenticationEnabled == null ? 43 : ((Object)$brokerClientAuthenticationEnabled).hashCode());
        Boolean $initializedDlogMetadata = this.getInitializedDlogMetadata();
        result = result * 59 + ($initializedDlogMetadata == null ? 43 : ((Object)$initializedDlogMetadata).hashCode());
        String $workerId = this.getWorkerId();
        result = result * 59 + ($workerId == null ? 43 : $workerId.hashCode());
        String $workerHostname = this.getWorkerHostname();
        result = result * 59 + ($workerHostname == null ? 43 : $workerHostname.hashCode());
        String $jvmGCMetricsLoggerClassName = this.getJvmGCMetricsLoggerClassName();
        result = result * 59 + ($jvmGCMetricsLoggerClassName == null ? 43 : $jvmGCMetricsLoggerClassName.hashCode());
        String $configurationStoreServers = this.getConfigurationStoreServers();
        result = result * 59 + ($configurationStoreServers == null ? 43 : $configurationStoreServers.hashCode());
        String $connectorsDirectory = this.getConnectorsDirectory();
        result = result * 59 + ($connectorsDirectory == null ? 43 : $connectorsDirectory.hashCode());
        String $narExtractionDirectory = this.getNarExtractionDirectory();
        result = result * 59 + ($narExtractionDirectory == null ? 43 : $narExtractionDirectory.hashCode());
        String $functionsDirectory = this.getFunctionsDirectory();
        result = result * 59 + ($functionsDirectory == null ? 43 : $functionsDirectory.hashCode());
        String $functionMetadataTopicName = this.getFunctionMetadataTopicName();
        result = result * 59 + ($functionMetadataTopicName == null ? 43 : $functionMetadataTopicName.hashCode());
        String $functionWebServiceUrl = this.getFunctionWebServiceUrl();
        result = result * 59 + ($functionWebServiceUrl == null ? 43 : $functionWebServiceUrl.hashCode());
        String $pulsarServiceUrl = this.getPulsarServiceUrl();
        result = result * 59 + ($pulsarServiceUrl == null ? 43 : $pulsarServiceUrl.hashCode());
        String $pulsarWebServiceUrl = this.getPulsarWebServiceUrl();
        result = result * 59 + ($pulsarWebServiceUrl == null ? 43 : $pulsarWebServiceUrl.hashCode());
        String $clusterCoordinationTopicName = this.getClusterCoordinationTopicName();
        result = result * 59 + ($clusterCoordinationTopicName == null ? 43 : $clusterCoordinationTopicName.hashCode());
        String $pulsarFunctionsNamespace = this.getPulsarFunctionsNamespace();
        result = result * 59 + ($pulsarFunctionsNamespace == null ? 43 : $pulsarFunctionsNamespace.hashCode());
        String $pulsarFunctionsCluster = this.getPulsarFunctionsCluster();
        result = result * 59 + ($pulsarFunctionsCluster == null ? 43 : $pulsarFunctionsCluster.hashCode());
        String $downloadDirectory = this.getDownloadDirectory();
        result = result * 59 + ($downloadDirectory == null ? 43 : $downloadDirectory.hashCode());
        String $stateStorageServiceUrl = this.getStateStorageServiceUrl();
        result = result * 59 + ($stateStorageServiceUrl == null ? 43 : $stateStorageServiceUrl.hashCode());
        String $stateStorageProviderImplementation = this.getStateStorageProviderImplementation();
        result = result * 59 + ($stateStorageProviderImplementation == null ? 43 : $stateStorageProviderImplementation.hashCode());
        String $functionAssignmentTopicName = this.getFunctionAssignmentTopicName();
        result = result * 59 + ($functionAssignmentTopicName == null ? 43 : $functionAssignmentTopicName.hashCode());
        String $schedulerClassName = this.getSchedulerClassName();
        result = result * 59 + ($schedulerClassName == null ? 43 : $schedulerClassName.hashCode());
        String $brokerClientAuthenticationPlugin = this.getBrokerClientAuthenticationPlugin();
        result = result * 59 + ($brokerClientAuthenticationPlugin == null ? 43 : $brokerClientAuthenticationPlugin.hashCode());
        String $brokerClientAuthenticationParameters = this.getBrokerClientAuthenticationParameters();
        result = result * 59 + ($brokerClientAuthenticationParameters == null ? 43 : $brokerClientAuthenticationParameters.hashCode());
        String $bookkeeperClientAuthenticationPlugin = this.getBookkeeperClientAuthenticationPlugin();
        result = result * 59 + ($bookkeeperClientAuthenticationPlugin == null ? 43 : $bookkeeperClientAuthenticationPlugin.hashCode());
        String $bookkeeperClientAuthenticationParametersName = this.getBookkeeperClientAuthenticationParametersName();
        result = result * 59 + ($bookkeeperClientAuthenticationParametersName == null ? 43 : $bookkeeperClientAuthenticationParametersName.hashCode());
        String $bookkeeperClientAuthenticationParameters = this.getBookkeeperClientAuthenticationParameters();
        result = result * 59 + ($bookkeeperClientAuthenticationParameters == null ? 43 : $bookkeeperClientAuthenticationParameters.hashCode());
        String $tlsCertificateFilePath = this.getTlsCertificateFilePath();
        result = result * 59 + ($tlsCertificateFilePath == null ? 43 : $tlsCertificateFilePath.hashCode());
        String $tlsKeyFilePath = this.getTlsKeyFilePath();
        result = result * 59 + ($tlsKeyFilePath == null ? 43 : $tlsKeyFilePath.hashCode());
        String $tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
        result = result * 59 + ($tlsTrustCertsFilePath == null ? 43 : $tlsTrustCertsFilePath.hashCode());
        String $tlsProvider = this.getTlsProvider();
        result = result * 59 + ($tlsProvider == null ? 43 : $tlsProvider.hashCode());
        String $tlsKeyStoreType = this.getTlsKeyStoreType();
        result = result * 59 + ($tlsKeyStoreType == null ? 43 : $tlsKeyStoreType.hashCode());
        String $tlsKeyStore = this.getTlsKeyStore();
        result = result * 59 + ($tlsKeyStore == null ? 43 : $tlsKeyStore.hashCode());
        String $tlsKeyStorePassword = this.getTlsKeyStorePassword();
        result = result * 59 + ($tlsKeyStorePassword == null ? 43 : $tlsKeyStorePassword.hashCode());
        String $tlsTrustStoreType = this.getTlsTrustStoreType();
        result = result * 59 + ($tlsTrustStoreType == null ? 43 : $tlsTrustStoreType.hashCode());
        String $tlsTrustStore = this.getTlsTrustStore();
        result = result * 59 + ($tlsTrustStore == null ? 43 : $tlsTrustStore.hashCode());
        String $tlsTrustStorePassword = this.getTlsTrustStorePassword();
        result = result * 59 + ($tlsTrustStorePassword == null ? 43 : $tlsTrustStorePassword.hashCode());
        Set<String> $webServiceTlsProtocols = this.getWebServiceTlsProtocols();
        result = result * 59 + ($webServiceTlsProtocols == null ? 43 : ((Object)$webServiceTlsProtocols).hashCode());
        Set<String> $webServiceTlsCiphers = this.getWebServiceTlsCiphers();
        result = result * 59 + ($webServiceTlsCiphers == null ? 43 : ((Object)$webServiceTlsCiphers).hashCode());
        Set<String> $authenticationProviders = this.getAuthenticationProviders();
        result = result * 59 + ($authenticationProviders == null ? 43 : ((Object)$authenticationProviders).hashCode());
        String $authorizationProvider = this.getAuthorizationProvider();
        result = result * 59 + ($authorizationProvider == null ? 43 : $authorizationProvider.hashCode());
        Set<String> $superUserRoles = this.getSuperUserRoles();
        result = result * 59 + ($superUserRoles == null ? 43 : ((Object)$superUserRoles).hashCode());
        Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $brokerClientTrustCertsFilePath = this.getBrokerClientTrustCertsFilePath();
        result = result * 59 + ($brokerClientTrustCertsFilePath == null ? 43 : $brokerClientTrustCertsFilePath.hashCode());
        String $functionRuntimeFactoryClassName = this.getFunctionRuntimeFactoryClassName();
        result = result * 59 + ($functionRuntimeFactoryClassName == null ? 43 : $functionRuntimeFactoryClassName.hashCode());
        Map<String, Object> $functionRuntimeFactoryConfigs = this.getFunctionRuntimeFactoryConfigs();
        result = result * 59 + ($functionRuntimeFactoryConfigs == null ? 43 : ((Object)$functionRuntimeFactoryConfigs).hashCode());
        String $secretsProviderConfiguratorClassName = this.getSecretsProviderConfiguratorClassName();
        result = result * 59 + ($secretsProviderConfiguratorClassName == null ? 43 : $secretsProviderConfiguratorClassName.hashCode());
        Map<String, String> $secretsProviderConfiguratorConfig = this.getSecretsProviderConfiguratorConfig();
        result = result * 59 + ($secretsProviderConfiguratorConfig == null ? 43 : ((Object)$secretsProviderConfiguratorConfig).hashCode());
        Resources $functionInstanceMinResources = this.getFunctionInstanceMinResources();
        result = result * 59 + ($functionInstanceMinResources == null ? 43 : $functionInstanceMinResources.hashCode());
        Resources $functionInstanceMaxResources = this.getFunctionInstanceMaxResources();
        result = result * 59 + ($functionInstanceMaxResources == null ? 43 : $functionInstanceMaxResources.hashCode());
        Resources $functionInstanceResourceGranularities = this.getFunctionInstanceResourceGranularities();
        result = result * 59 + ($functionInstanceResourceGranularities == null ? 43 : $functionInstanceResourceGranularities.hashCode());
        String $functionAuthProviderClassName = this.getFunctionAuthProviderClassName();
        result = result * 59 + ($functionAuthProviderClassName == null ? 43 : $functionAuthProviderClassName.hashCode());
        String $runtimeCustomizerClassName = this.getRuntimeCustomizerClassName();
        result = result * 59 + ($runtimeCustomizerClassName == null ? 43 : $runtimeCustomizerClassName.hashCode());
        Map<String, Object> $runtimeCustomizerConfig = this.getRuntimeCustomizerConfig();
        result = result * 59 + ($runtimeCustomizerConfig == null ? 43 : ((Object)$runtimeCustomizerConfig).hashCode());
        String $functionsWorkerServiceNarPackage = this.getFunctionsWorkerServiceNarPackage();
        result = result * 59 + ($functionsWorkerServiceNarPackage == null ? 43 : $functionsWorkerServiceNarPackage.hashCode());
        Map<String, Object> $functionsWorkerServiceCustomConfigs = this.getFunctionsWorkerServiceCustomConfigs();
        result = result * 59 + ($functionsWorkerServiceCustomConfigs == null ? 43 : ((Object)$functionsWorkerServiceCustomConfigs).hashCode());
        ThreadContainerFactory $threadContainerFactory = this.getThreadContainerFactory();
        result = result * 59 + ($threadContainerFactory == null ? 43 : ((Object)$threadContainerFactory).hashCode());
        ProcessContainerFactory $processContainerFactory = this.getProcessContainerFactory();
        result = result * 59 + ($processContainerFactory == null ? 43 : ((Object)$processContainerFactory).hashCode());
        KubernetesContainerFactory $kubernetesContainerFactory = this.getKubernetesContainerFactory();
        result = result * 59 + ($kubernetesContainerFactory == null ? 43 : ((Object)$kubernetesContainerFactory).hashCode());
        String $clientAuthenticationParameters = this.getClientAuthenticationParameters();
        result = result * 59 + ($clientAuthenticationParameters == null ? 43 : $clientAuthenticationParameters.hashCode());
        String $clientAuthenticationPlugin = this.getClientAuthenticationPlugin();
        result = result * 59 + ($clientAuthenticationPlugin == null ? 43 : $clientAuthenticationPlugin.hashCode());
        return result;
    }

    public String toString() {
        return "WorkerConfig(workerId=" + this.getWorkerId() + ", workerHostname=" + this.getWorkerHostname() + ", workerPort=" + this.getWorkerPort() + ", workerPortTls=" + this.getWorkerPortTls() + ", authenticateMetricsEndpoint=" + this.isAuthenticateMetricsEndpoint() + ", includeStandardPrometheusMetrics=" + this.isIncludeStandardPrometheusMetrics() + ", jvmGCMetricsLoggerClassName=" + this.getJvmGCMetricsLoggerClassName() + ", numHttpServerThreads=" + this.getNumHttpServerThreads() + ", httpRequestsLimitEnabled=" + this.isHttpRequestsLimitEnabled() + ", httpRequestsMaxPerSecond=" + this.getHttpRequestsMaxPerSecond() + ", configurationStoreServers=" + this.getConfigurationStoreServers() + ", zooKeeperSessionTimeoutMillis=" + this.getZooKeeperSessionTimeoutMillis() + ", zooKeeperOperationTimeoutSeconds=" + this.getZooKeeperOperationTimeoutSeconds() + ", zooKeeperCacheExpirySeconds=" + this.getZooKeeperCacheExpirySeconds() + ", connectorsDirectory=" + this.getConnectorsDirectory() + ", narExtractionDirectory=" + this.getNarExtractionDirectory() + ", validateConnectorConfig=" + this.getValidateConnectorConfig() + ", functionsDirectory=" + this.getFunctionsDirectory() + ", functionMetadataTopicName=" + this.getFunctionMetadataTopicName() + ", useCompactedMetadataTopic=" + this.getUseCompactedMetadataTopic() + ", functionWebServiceUrl=" + this.getFunctionWebServiceUrl() + ", pulsarServiceUrl=" + this.getPulsarServiceUrl() + ", pulsarWebServiceUrl=" + this.getPulsarWebServiceUrl() + ", clusterCoordinationTopicName=" + this.getClusterCoordinationTopicName() + ", pulsarFunctionsNamespace=" + this.getPulsarFunctionsNamespace() + ", pulsarFunctionsCluster=" + this.getPulsarFunctionsCluster() + ", numFunctionPackageReplicas=" + this.getNumFunctionPackageReplicas() + ", downloadDirectory=" + this.getDownloadDirectory() + ", stateStorageServiceUrl=" + this.getStateStorageServiceUrl() + ", stateStorageProviderImplementation=" + this.getStateStorageProviderImplementation() + ", functionAssignmentTopicName=" + this.getFunctionAssignmentTopicName() + ", schedulerClassName=" + this.getSchedulerClassName() + ", failureCheckFreqMs=" + this.getFailureCheckFreqMs() + ", rescheduleTimeoutMs=" + this.getRescheduleTimeoutMs() + ", rebalanceCheckFreqSec=" + this.getRebalanceCheckFreqSec() + ", workerListProbeIntervalSec=" + this.getWorkerListProbeIntervalSec() + ", initialBrokerReconnectMaxRetries=" + this.getInitialBrokerReconnectMaxRetries() + ", assignmentWriteMaxRetries=" + this.getAssignmentWriteMaxRetries() + ", instanceLivenessCheckFreqMs=" + this.getInstanceLivenessCheckFreqMs() + ", brokerClientAuthenticationEnabled=" + this.getBrokerClientAuthenticationEnabled() + ", brokerClientAuthenticationPlugin=" + this.getBrokerClientAuthenticationPlugin() + ", brokerClientAuthenticationParameters=" + this.getBrokerClientAuthenticationParameters() + ", bookkeeperClientAuthenticationPlugin=" + this.getBookkeeperClientAuthenticationPlugin() + ", bookkeeperClientAuthenticationParametersName=" + this.getBookkeeperClientAuthenticationParametersName() + ", bookkeeperClientAuthenticationParameters=" + this.getBookkeeperClientAuthenticationParameters() + ", topicCompactionFrequencySec=" + this.getTopicCompactionFrequencySec() + ", tlsEnabled=" + this.getTlsEnabled() + ", tlsCertificateFilePath=" + this.getTlsCertificateFilePath() + ", tlsKeyFilePath=" + this.getTlsKeyFilePath() + ", tlsTrustCertsFilePath=" + this.getTlsTrustCertsFilePath() + ", tlsAllowInsecureConnection=" + this.isTlsAllowInsecureConnection() + ", tlsRequireTrustedClientCertOnConnect=" + this.isTlsRequireTrustedClientCertOnConnect() + ", useTls=" + this.isUseTls() + ", tlsEnableHostnameVerification=" + this.isTlsEnableHostnameVerification() + ", tlsCertRefreshCheckDurationSec=" + this.getTlsCertRefreshCheckDurationSec() + ", tlsEnabledWithKeyStore=" + this.isTlsEnabledWithKeyStore() + ", tlsProvider=" + this.getTlsProvider() + ", tlsKeyStoreType=" + this.getTlsKeyStoreType() + ", tlsKeyStore=" + this.getTlsKeyStore() + ", tlsTrustStoreType=" + this.getTlsTrustStoreType() + ", tlsTrustStore=" + this.getTlsTrustStore() + ", webServiceTlsProtocols=" + this.getWebServiceTlsProtocols() + ", webServiceTlsCiphers=" + this.getWebServiceTlsCiphers() + ", authenticationEnabled=" + this.isAuthenticationEnabled() + ", authenticationProviders=" + this.getAuthenticationProviders() + ", authorizationEnabled=" + this.isAuthorizationEnabled() + ", authorizationProvider=" + this.getAuthorizationProvider() + ", superUserRoles=" + this.getSuperUserRoles() + ", properties=" + this.getProperties() + ", initializedDlogMetadata=" + this.getInitializedDlogMetadata() + ", brokerClientTrustCertsFilePath=" + this.getBrokerClientTrustCertsFilePath() + ", functionRuntimeFactoryClassName=" + this.getFunctionRuntimeFactoryClassName() + ", functionRuntimeFactoryConfigs=" + this.getFunctionRuntimeFactoryConfigs() + ", secretsProviderConfiguratorClassName=" + this.getSecretsProviderConfiguratorClassName() + ", secretsProviderConfiguratorConfig=" + this.getSecretsProviderConfiguratorConfig() + ", functionInstanceMinResources=" + this.getFunctionInstanceMinResources() + ", functionInstanceMaxResources=" + this.getFunctionInstanceMaxResources() + ", functionInstanceResourceGranularities=" + this.getFunctionInstanceResourceGranularities() + ", functionInstanceResourceChangeInLockStep=" + this.isFunctionInstanceResourceChangeInLockStep() + ", functionAuthProviderClassName=" + this.getFunctionAuthProviderClassName() + ", runtimeCustomizerClassName=" + this.getRuntimeCustomizerClassName() + ", runtimeCustomizerConfig=" + this.getRuntimeCustomizerConfig() + ", maxPendingAsyncRequests=" + this.getMaxPendingAsyncRequests() + ", forwardSourceMessageProperty=" + this.isForwardSourceMessageProperty() + ", functionsWorkerServiceNarPackage=" + this.getFunctionsWorkerServiceNarPackage() + ", functionsWorkerServiceCustomConfigs=" + this.getFunctionsWorkerServiceCustomConfigs() + ", exposeAdminClientEnabled=" + this.isExposeAdminClientEnabled() + ", threadContainerFactory=" + this.getThreadContainerFactory() + ", processContainerFactory=" + this.getProcessContainerFactory() + ", kubernetesContainerFactory=" + this.getKubernetesContainerFactory() + ", clientAuthenticationParameters=" + this.getClientAuthenticationParameters() + ", clientAuthenticationPlugin=" + this.getClientAuthenticationPlugin() + ")";
    }

    @Deprecated
    public static class KubernetesContainerFactory
    extends KubernetesRuntimeFactoryConfig {
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KubernetesContainerFactory)) {
                return false;
            }
            KubernetesContainerFactory other = (KubernetesContainerFactory)o;
            return other.canEqual(this);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof KubernetesContainerFactory;
        }

        @Override
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        @Override
        public String toString() {
            return "WorkerConfig.KubernetesContainerFactory()";
        }
    }

    @Deprecated
    public static class ProcessContainerFactory
    extends ProcessRuntimeFactoryConfig {
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcessContainerFactory)) {
                return false;
            }
            ProcessContainerFactory other = (ProcessContainerFactory)o;
            return other.canEqual(this);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ProcessContainerFactory;
        }

        @Override
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        @Override
        public String toString() {
            return "WorkerConfig.ProcessContainerFactory()";
        }
    }

    @Deprecated
    public static class ThreadContainerFactory
    extends ThreadRuntimeFactoryConfig {
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThreadContainerFactory)) {
                return false;
            }
            ThreadContainerFactory other = (ThreadContainerFactory)o;
            return other.canEqual(this);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ThreadContainerFactory;
        }

        @Override
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        @Override
        public String toString() {
            return "WorkerConfig.ThreadContainerFactory()";
        }
    }
}

