/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.secretsproviderconfigurator;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1EnvVar;
import io.kubernetes.client.openapi.models.V1EnvVarSource;
import io.kubernetes.client.openapi.models.V1PodSpec;
import io.kubernetes.client.openapi.models.V1SecretKeySelector;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.secretsprovider.EnvironmentBasedSecretsProvider;
import org.apache.pulsar.functions.secretsproviderconfigurator.SecretsProviderConfigurator;

public class KubernetesSecretsProviderConfigurator
implements SecretsProviderConfigurator {
    private static String ID_KEY = "path";
    private static String KEY_KEY = "key";

    @Override
    public String getSecretsProviderClassName(Function.FunctionDetails functionDetails) {
        switch (functionDetails.getRuntime()) {
            case JAVA: {
                return EnvironmentBasedSecretsProvider.class.getName();
            }
            case PYTHON: {
                return "secretsprovider.EnvironmentBasedSecretsProvider";
            }
            case GO: {
                return "";
            }
        }
        throw new RuntimeException("Unknown function runtime " + functionDetails.getRuntime());
    }

    @Override
    public Map<String, String> getSecretsProviderConfig(Function.FunctionDetails functionDetails) {
        return null;
    }

    @Override
    public void configureKubernetesRuntimeSecretsProvider(V1PodSpec podSpec, String functionsContainerName, Function.FunctionDetails functionDetails) {
        V1Container container = null;
        for (V1Container v1Container : podSpec.getContainers()) {
            if (!v1Container.getName().equals(functionsContainerName)) continue;
            container = v1Container;
            break;
        }
        if (container == null) {
            throw new RuntimeException("No FunctionContainer found");
        }
        if (!StringUtils.isEmpty((CharSequence)functionDetails.getSecretsMap())) {
            Type type = new TypeToken<Map<String, Object>>(){}.getType();
            Map secretsMap = (Map)new Gson().fromJson(functionDetails.getSecretsMap(), type);
            for (Map.Entry entry : secretsMap.entrySet()) {
                V1EnvVar secretEnv = new V1EnvVar();
                Map kv = (Map)entry.getValue();
                secretEnv.name((String)entry.getKey()).valueFrom(new V1EnvVarSource().secretKeyRef(new V1SecretKeySelector().name((String)kv.get(ID_KEY)).key((String)kv.get(KEY_KEY))));
                container.addEnvItem(secretEnv);
            }
        }
    }

    @Override
    public void configureProcessRuntimeSecretsProvider(ProcessBuilder processBuilder, Function.FunctionDetails functionDetails) {
        throw new RuntimeException("KubernetesSecretsProviderConfigurator should only be setup for Kubernetes Runtime");
    }

    @Override
    public Type getSecretObjectType() {
        return new TypeToken<Map<String, String>>(){}.getType();
    }

    @Override
    public void doAdmissionChecks(AppsV1Api appsV1Api, CoreV1Api coreV1Api, String jobNamespace, String jobName, Function.FunctionDetails functionDetails) {
        if (!StringUtils.isEmpty((CharSequence)functionDetails.getSecretsMap())) {
            Type type = new TypeToken<Map<String, Object>>(){}.getType();
            Map secretsMap = (Map)new Gson().fromJson(functionDetails.getSecretsMap(), type);
            for (Object object : secretsMap.values()) {
                if (object instanceof Map) {
                    Map kubernetesSecret = (Map)object;
                    if (kubernetesSecret.size() < 2) {
                        throw new IllegalArgumentException("Kubernetes Secret should contain id and key");
                    }
                    if (!kubernetesSecret.containsKey(ID_KEY)) {
                        throw new IllegalArgumentException("Kubernetes Secret should contain id information");
                    }
                    if (kubernetesSecret.containsKey(KEY_KEY)) continue;
                    throw new IllegalArgumentException("Kubernetes Secret should contain key information");
                }
                throw new IllegalArgumentException("Kubernetes Secret should be a Map containing id/key pairs");
            }
        }
    }
}

