/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.aerospike;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import lombok.Generated;

public class AerospikeSinkConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String seedHosts;
    private String keyspace;
    private String columnName;
    private String userName;
    private String password;
    private String keySet;
    private int maxConcurrentRequests = 100;
    private int timeoutMs = 100;
    private int retries = 1;

    public static AerospikeSinkConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (AerospikeSinkConfig)mapper.readValue(new File(yamlFile), AerospikeSinkConfig.class);
    }

    public static AerospikeSinkConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (AerospikeSinkConfig)mapper.readValue(mapper.writeValueAsString(map), AerospikeSinkConfig.class);
    }

    @Generated
    public AerospikeSinkConfig() {
    }

    @Generated
    public String getSeedHosts() {
        return this.seedHosts;
    }

    @Generated
    public String getKeyspace() {
        return this.keyspace;
    }

    @Generated
    public String getColumnName() {
        return this.columnName;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getKeySet() {
        return this.keySet;
    }

    @Generated
    public int getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    @Generated
    public int getTimeoutMs() {
        return this.timeoutMs;
    }

    @Generated
    public int getRetries() {
        return this.retries;
    }

    @Generated
    public AerospikeSinkConfig setSeedHosts(String seedHosts) {
        this.seedHosts = seedHosts;
        return this;
    }

    @Generated
    public AerospikeSinkConfig setKeyspace(String keyspace) {
        this.keyspace = keyspace;
        return this;
    }

    @Generated
    public AerospikeSinkConfig setColumnName(String columnName) {
        this.columnName = columnName;
        return this;
    }

    @Generated
    public AerospikeSinkConfig setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    @Generated
    public AerospikeSinkConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    @Generated
    public AerospikeSinkConfig setKeySet(String keySet) {
        this.keySet = keySet;
        return this;
    }

    @Generated
    public AerospikeSinkConfig setMaxConcurrentRequests(int maxConcurrentRequests) {
        this.maxConcurrentRequests = maxConcurrentRequests;
        return this;
    }

    @Generated
    public AerospikeSinkConfig setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
        return this;
    }

    @Generated
    public AerospikeSinkConfig setRetries(int retries) {
        this.retries = retries;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AerospikeSinkConfig)) {
            return false;
        }
        AerospikeSinkConfig other = (AerospikeSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxConcurrentRequests() != other.getMaxConcurrentRequests()) {
            return false;
        }
        if (this.getTimeoutMs() != other.getTimeoutMs()) {
            return false;
        }
        if (this.getRetries() != other.getRetries()) {
            return false;
        }
        String this$seedHosts = this.getSeedHosts();
        String other$seedHosts = other.getSeedHosts();
        if (this$seedHosts == null ? other$seedHosts != null : !this$seedHosts.equals(other$seedHosts)) {
            return false;
        }
        String this$keyspace = this.getKeyspace();
        String other$keyspace = other.getKeyspace();
        if (this$keyspace == null ? other$keyspace != null : !this$keyspace.equals(other$keyspace)) {
            return false;
        }
        String this$columnName = this.getColumnName();
        String other$columnName = other.getColumnName();
        if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$keySet = this.getKeySet();
        String other$keySet = other.getKeySet();
        return !(this$keySet == null ? other$keySet != null : !this$keySet.equals(other$keySet));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AerospikeSinkConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxConcurrentRequests();
        result = result * 59 + this.getTimeoutMs();
        result = result * 59 + this.getRetries();
        String $seedHosts = this.getSeedHosts();
        result = result * 59 + ($seedHosts == null ? 43 : $seedHosts.hashCode());
        String $keyspace = this.getKeyspace();
        result = result * 59 + ($keyspace == null ? 43 : $keyspace.hashCode());
        String $columnName = this.getColumnName();
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $keySet = this.getKeySet();
        result = result * 59 + ($keySet == null ? 43 : $keySet.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AerospikeSinkConfig(seedHosts=" + this.getSeedHosts() + ", keyspace=" + this.getKeyspace() + ", columnName=" + this.getColumnName() + ", userName=" + this.getUserName() + ", password=" + this.getPassword() + ", keySet=" + this.getKeySet() + ", maxConcurrentRequests=" + this.getMaxConcurrentRequests() + ", timeoutMs=" + this.getTimeoutMs() + ", retries=" + this.getRetries() + ")";
    }
}

