/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.datagenerator;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Map;
import org.apache.pulsar.config.validation.ConfigValidationAnnotations;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class DataGeneratorSourceConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=true, defaultValue="50", sensitive=false, help="How long to sleep between emitting messages")
    @ConfigValidationAnnotations.PositiveNumber
    private long sleepBetweenMessages = 50L;

    public static DataGeneratorSourceConfig loadOrGetDefault(Map<String, Object> configMap) {
        if (configMap.isEmpty()) {
            return new DataGeneratorSourceConfig();
        }
        ObjectMapper mapper = new ObjectMapper();
        return (DataGeneratorSourceConfig)mapper.convertValue(configMap, DataGeneratorSourceConfig.class);
    }

    public long getSleepBetweenMessages() {
        return this.sleepBetweenMessages;
    }

    public void setSleepBetweenMessages(long sleepBetweenMessages) {
        this.sleepBetweenMessages = sleepBetweenMessages;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataGeneratorSourceConfig)) {
            return false;
        }
        DataGeneratorSourceConfig other = (DataGeneratorSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getSleepBetweenMessages() == other.getSleepBetweenMessages();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataGeneratorSourceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $sleepBetweenMessages = this.getSleepBetweenMessages();
        result = result * 59 + (int)($sleepBetweenMessages >>> 32 ^ $sleepBetweenMessages);
        return result;
    }

    public String toString() {
        return "DataGeneratorSourceConfig(sleepBetweenMessages=" + this.getSleepBetweenMessages() + ")";
    }
}

