/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.elasticsearch.client;

import com.google.common.base.Strings;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.pulsar.io.elasticsearch.ElasticSearchConfig;
import org.apache.pulsar.io.elasticsearch.ElasticSearchConnectionException;
import org.apache.pulsar.io.elasticsearch.ElasticSearchSslConfig;
import org.apache.pulsar.io.elasticsearch.client.BulkProcessor;
import org.elasticsearch.client.RestClientBuilder;
import org.opensearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(RestClient.class);
    protected final ElasticSearchConfig config;
    protected final ConfigCallback configCallback;
    private final ScheduledExecutorService executorService;

    public RestClient(ElasticSearchConfig elasticSearchConfig, BulkProcessor.Listener bulkProcessorListener) {
        this.config = elasticSearchConfig;
        this.configCallback = new ConfigCallback();
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.executorService.scheduleAtFixedRate(() -> this.configCallback.connectionManager.closeIdleConnections((long)this.config.getConnectionIdleTimeoutInMs(), TimeUnit.MILLISECONDS), this.config.getConnectionIdleTimeoutInMs(), this.config.getConnectionIdleTimeoutInMs(), TimeUnit.MILLISECONDS);
    }

    public abstract boolean indexExists(String var1) throws IOException;

    public abstract boolean createIndex(String var1) throws IOException;

    public abstract boolean deleteIndex(String var1) throws IOException;

    public abstract boolean indexDocument(String var1, String var2, String var3) throws IOException;

    public abstract boolean deleteDocument(String var1, String var2) throws IOException;

    public abstract long totalHits(String var1) throws IOException;

    public abstract long totalHits(String var1, String var2) throws IOException;

    public abstract BulkProcessor getBulkProcessor();

    protected HttpHost[] getHttpHosts() {
        String url = this.config.getElasticSearchUrl();
        return (HttpHost[])Arrays.stream(url.split(",")).map(host -> {
            try {
                URL hostUrl = new URL((String)host);
                return new HttpHost(hostUrl.getHost(), hostUrl.getPort(), hostUrl.getProtocol());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Invalid elasticSearch url :" + host);
            }
        }).toArray(HttpHost[]::new);
    }

    protected abstract void closeClient();

    @Override
    public void close() {
        this.executorService.shutdown();
        this.closeClient();
    }

    public class ConfigCallback
    implements RestClientBuilder.HttpClientConfigCallback,
    RestClientBuilder.HttpClientConfigCallback {
        final NHttpClientConnectionManager connectionManager;
        final CredentialsProvider credentialsProvider;
        final List<Header> defaultHeaders;

        public ConfigCallback() {
            this.connectionManager = this.buildConnectionManager(RestClient.this.config);
            this.credentialsProvider = this.buildCredentialsProvider(RestClient.this.config);
            this.defaultHeaders = this.buildDefaultHeaders(RestClient.this.config);
        }

        public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder builder) {
            builder.setMaxConnPerRoute(RestClient.this.config.getBulkConcurrentRequests());
            builder.setMaxConnTotal(RestClient.this.config.getBulkConcurrentRequests());
            builder.setConnectionManager(this.connectionManager);
            if (this.credentialsProvider != null) {
                builder.setDefaultCredentialsProvider(this.credentialsProvider);
            }
            if (this.defaultHeaders != null) {
                builder.setDefaultHeaders(this.defaultHeaders);
            }
            return builder;
        }

        public NHttpClientConnectionManager buildConnectionManager(ElasticSearchConfig config) {
            try {
                PoolingNHttpClientConnectionManager connManager;
                IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setConnectTimeout(config.getConnectTimeoutInMs()).setSoTimeout(config.getSocketTimeoutInMs()).build();
                DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
                if (config.getSsl().isEnabled()) {
                    HostnameVerifier hostnameVerifier;
                    ElasticSearchSslConfig sslConfig = config.getSsl();
                    boolean hostnameVerification = config.getSsl().isHostnameVerification();
                    if (hostnameVerification) {
                        hostnameVerifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
                    } else {
                        hostnameVerifier = NoopHostnameVerifier.INSTANCE;
                        log.warn("Hostname verification is disabled.");
                    }
                    String[] cipherSuites = null;
                    if (!Strings.isNullOrEmpty((String)sslConfig.getCipherSuites())) {
                        cipherSuites = sslConfig.getCipherSuites().split(",");
                    }
                    String[] protocols = null;
                    if (!Strings.isNullOrEmpty((String)sslConfig.getProtocols())) {
                        protocols = sslConfig.getProtocols().split(",");
                    }
                    Registry registry = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)new SSLIOSessionStrategy(this.buildSslContext(config), protocols, cipherSuites, hostnameVerifier)).build();
                    connManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor, registry);
                } else {
                    connManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
                }
                return connManager;
            }
            catch (Exception e) {
                throw new ElasticSearchConnectionException(e);
            }
        }

        private SSLContext buildSslContext(ElasticSearchConfig config) throws NoSuchAlgorithmException, KeyManagementException, CertificateException, KeyStoreException, IOException, UnrecoverableKeyException {
            ElasticSearchSslConfig sslConfig = config.getSsl();
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            if (!Strings.isNullOrEmpty((String)sslConfig.getProvider())) {
                sslContextBuilder.setProvider(sslConfig.getProvider());
            }
            if (!Strings.isNullOrEmpty((String)sslConfig.getProtocols())) {
                sslContextBuilder.setProtocol(sslConfig.getProtocols());
            }
            if (!Strings.isNullOrEmpty((String)sslConfig.getTruststorePath()) && !Strings.isNullOrEmpty((String)sslConfig.getTruststorePassword())) {
                sslContextBuilder.loadTrustMaterial(new File(sslConfig.getTruststorePath()), sslConfig.getTruststorePassword().toCharArray());
            }
            if (sslConfig.isDisableCertificateValidation()) {
                sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)TrustAllStrategy.INSTANCE);
                log.warn("Certificate validation is disabled, the identity of the target server will not be verified.");
            }
            if (!Strings.isNullOrEmpty((String)sslConfig.getKeystorePath()) && !Strings.isNullOrEmpty((String)sslConfig.getKeystorePassword())) {
                sslContextBuilder.loadKeyMaterial(new File(sslConfig.getKeystorePath()), sslConfig.getKeystorePassword().toCharArray(), sslConfig.getKeystorePassword().toCharArray());
            }
            return sslContextBuilder.build();
        }

        private CredentialsProvider buildCredentialsProvider(ElasticSearchConfig config) {
            if (StringUtils.isEmpty((CharSequence)config.getUsername()) || StringUtils.isEmpty((CharSequence)config.getPassword())) {
                return null;
            }
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(config.getUsername(), config.getPassword()));
            return credentialsProvider;
        }

        private List<Header> buildDefaultHeaders(ElasticSearchConfig config) {
            if (StringUtils.isEmpty((CharSequence)config.getToken()) && StringUtils.isEmpty((CharSequence)config.getApiKey())) {
                return null;
            }
            ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
            String authHeaderValue = !StringUtils.isEmpty((CharSequence)config.getToken()) ? "Bearer " + config.getToken() : "ApiKey " + config.getApiKey();
            headers.add(new BasicHeader("Authorization", authHeaderValue));
            return Collections.unmodifiableList(headers);
        }
    }
}

