/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.flume;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class FlumeConfig {
    @FieldDoc(required=true, defaultValue="", help="the name of this agent")
    private String name;
    @FieldDoc(required=true, defaultValue="", help="specify a config file (required if -z missing)")
    private String confFile;
    @FieldDoc(defaultValue="false", help="do not reload config file if changed")
    private Boolean noReloadConf;
    @FieldDoc(required=true, defaultValue="", help="specify the ZooKeeper connection to use (required if -f missing)")
    private String zkConnString;
    @FieldDoc(required=true, defaultValue="", help="specify the base path in ZooKeeper for agent configs")
    private String zkBasePath;

    public static FlumeConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (FlumeConfig)mapper.readValue(new File(yamlFile), FlumeConfig.class);
    }

    public static FlumeConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (FlumeConfig)mapper.readValue(mapper.writeValueAsString(map), FlumeConfig.class);
    }

    @Generated
    public FlumeConfig() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getConfFile() {
        return this.confFile;
    }

    @Generated
    public Boolean getNoReloadConf() {
        return this.noReloadConf;
    }

    @Generated
    public String getZkConnString() {
        return this.zkConnString;
    }

    @Generated
    public String getZkBasePath() {
        return this.zkBasePath;
    }

    @Generated
    public FlumeConfig setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public FlumeConfig setConfFile(String confFile) {
        this.confFile = confFile;
        return this;
    }

    @Generated
    public FlumeConfig setNoReloadConf(Boolean noReloadConf) {
        this.noReloadConf = noReloadConf;
        return this;
    }

    @Generated
    public FlumeConfig setZkConnString(String zkConnString) {
        this.zkConnString = zkConnString;
        return this;
    }

    @Generated
    public FlumeConfig setZkBasePath(String zkBasePath) {
        this.zkBasePath = zkBasePath;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlumeConfig)) {
            return false;
        }
        FlumeConfig other = (FlumeConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$noReloadConf = this.getNoReloadConf();
        Boolean other$noReloadConf = other.getNoReloadConf();
        if (this$noReloadConf == null ? other$noReloadConf != null : !((Object)this$noReloadConf).equals(other$noReloadConf)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$confFile = this.getConfFile();
        String other$confFile = other.getConfFile();
        if (this$confFile == null ? other$confFile != null : !this$confFile.equals(other$confFile)) {
            return false;
        }
        String this$zkConnString = this.getZkConnString();
        String other$zkConnString = other.getZkConnString();
        if (this$zkConnString == null ? other$zkConnString != null : !this$zkConnString.equals(other$zkConnString)) {
            return false;
        }
        String this$zkBasePath = this.getZkBasePath();
        String other$zkBasePath = other.getZkBasePath();
        return !(this$zkBasePath == null ? other$zkBasePath != null : !this$zkBasePath.equals(other$zkBasePath));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FlumeConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $noReloadConf = this.getNoReloadConf();
        result = result * 59 + ($noReloadConf == null ? 43 : ((Object)$noReloadConf).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $confFile = this.getConfFile();
        result = result * 59 + ($confFile == null ? 43 : $confFile.hashCode());
        String $zkConnString = this.getZkConnString();
        result = result * 59 + ($zkConnString == null ? 43 : $zkConnString.hashCode());
        String $zkBasePath = this.getZkBasePath();
        result = result * 59 + ($zkBasePath == null ? 43 : $zkBasePath.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FlumeConfig(name=" + this.getName() + ", confFile=" + this.getConfFile() + ", noReloadConf=" + this.getNoReloadConf() + ", zkConnString=" + this.getZkConnString() + ", zkBasePath=" + this.getZkBasePath() + ")";
    }
}

