/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.hbase.sink;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.io.core.annotations.FieldDoc;
import org.apache.pulsar.io.hbase.HbaseAbstractConfig;

public class HbaseSinkConfig
extends HbaseAbstractConfig {
    private static final long serialVersionUID = 1245636479605735555L;
    @FieldDoc(required=true, defaultValue="", help="The hbase table rowkey name")
    private String rowKeyName;
    @FieldDoc(required=true, defaultValue="", help="The hbase table column family name")
    private String familyName;
    @FieldDoc(required=true, defaultValue="", help="The hbase table column qualifier names")
    private List<String> qualifierNames;
    @FieldDoc(defaultValue="1000l", help="The hbase operation time in milliseconds")
    private long batchTimeMs = 1000L;
    @FieldDoc(defaultValue="200", help="The batch size of write to the hbase table")
    private int batchSize = 200;

    public static HbaseSinkConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (HbaseSinkConfig)mapper.readValue(new File(yamlFile), HbaseSinkConfig.class);
    }

    public static HbaseSinkConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (HbaseSinkConfig)mapper.readValue(mapper.writeValueAsString(map), HbaseSinkConfig.class);
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkNotNull((Object)this.rowKeyName, (Object)"rowKeyName property not set.");
        Preconditions.checkNotNull((Object)this.familyName, (Object)"familyName property not set.");
        Preconditions.checkNotNull(this.qualifierNames, (Object)"qualifierNames property not set.");
        Preconditions.checkArgument((this.batchTimeMs > 0L ? 1 : 0) != 0, (Object)"batchTimeMs must be a positive long.");
        Preconditions.checkArgument((this.batchSize > 0 ? 1 : 0) != 0, (Object)"batchSize must be a positive integer.");
    }

    public String getRowKeyName() {
        return this.rowKeyName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public List<String> getQualifierNames() {
        return this.qualifierNames;
    }

    public long getBatchTimeMs() {
        return this.batchTimeMs;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public HbaseSinkConfig setRowKeyName(String rowKeyName) {
        this.rowKeyName = rowKeyName;
        return this;
    }

    public HbaseSinkConfig setFamilyName(String familyName) {
        this.familyName = familyName;
        return this;
    }

    public HbaseSinkConfig setQualifierNames(List<String> qualifierNames) {
        this.qualifierNames = qualifierNames;
        return this;
    }

    public HbaseSinkConfig setBatchTimeMs(long batchTimeMs) {
        this.batchTimeMs = batchTimeMs;
        return this;
    }

    public HbaseSinkConfig setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public String toString() {
        return "HbaseSinkConfig(rowKeyName=" + this.getRowKeyName() + ", familyName=" + this.getFamilyName() + ", qualifierNames=" + String.valueOf(this.getQualifierNames()) + ", batchTimeMs=" + this.getBatchTimeMs() + ", batchSize=" + this.getBatchSize() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HbaseSinkConfig)) {
            return false;
        }
        HbaseSinkConfig other = (HbaseSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBatchTimeMs() != other.getBatchTimeMs()) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        String this$rowKeyName = this.getRowKeyName();
        String other$rowKeyName = other.getRowKeyName();
        if (this$rowKeyName == null ? other$rowKeyName != null : !this$rowKeyName.equals(other$rowKeyName)) {
            return false;
        }
        String this$familyName = this.getFamilyName();
        String other$familyName = other.getFamilyName();
        if (this$familyName == null ? other$familyName != null : !this$familyName.equals(other$familyName)) {
            return false;
        }
        List<String> this$qualifierNames = this.getQualifierNames();
        List<String> other$qualifierNames = other.getQualifierNames();
        return !(this$qualifierNames == null ? other$qualifierNames != null : !((Object)this$qualifierNames).equals(other$qualifierNames));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HbaseSinkConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $batchTimeMs = this.getBatchTimeMs();
        result = result * 59 + (int)($batchTimeMs >>> 32 ^ $batchTimeMs);
        result = result * 59 + this.getBatchSize();
        String $rowKeyName = this.getRowKeyName();
        result = result * 59 + ($rowKeyName == null ? 43 : $rowKeyName.hashCode());
        String $familyName = this.getFamilyName();
        result = result * 59 + ($familyName == null ? 43 : $familyName.hashCode());
        List<String> $qualifierNames = this.getQualifierNames();
        result = result * 59 + ($qualifierNames == null ? 43 : ((Object)$qualifierNames).hashCode());
        return result;
    }
}

