/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.hdfs2.sink;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hadoop.fs.Syncable;
import org.apache.pulsar.functions.api.Record;

public class HdfsSyncThread<V>
extends Thread {
    private final Syncable stream;
    private final BlockingQueue<Record<V>> unackedRecords;
    private final long syncInterval;
    private boolean keepRunning = true;

    public HdfsSyncThread(Syncable stream, BlockingQueue<Record<V>> unackedRecords, long syncInterval) {
        this.stream = stream;
        this.unackedRecords = unackedRecords;
        this.syncInterval = syncInterval;
    }

    @Override
    public void run() {
        while (this.keepRunning) {
            try {
                Thread.sleep(this.syncInterval);
                this.ackRecords();
            }
            catch (InterruptedException e) {
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public final void halt() throws IOException, InterruptedException {
        this.keepRunning = false;
        this.ackRecords();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ackRecords() throws IOException, InterruptedException {
        if (CollectionUtils.isEmpty(this.unackedRecords)) {
            return;
        }
        Syncable syncable = this.stream;
        synchronized (syncable) {
            this.stream.hsync();
        }
        while (!this.unackedRecords.isEmpty()) {
            this.unackedRecords.take().ack();
        }
    }
}

