/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.http;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class HttpSinkConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(defaultValue="http://localhost", help="The URL of the HTTP server")
    private String url = "http://localhost";
    @FieldDoc(defaultValue="", help="The list of default headers added to each request")
    private Map<String, String> headers = new HashMap<String, String>();

    public static HttpSinkConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (HttpSinkConfig)mapper.readValue(new File(yamlFile), HttpSinkConfig.class);
    }

    public static HttpSinkConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (HttpSinkConfig)mapper.readValue(mapper.writeValueAsString(map), HttpSinkConfig.class);
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public HttpSinkConfig setUrl(String url) {
        this.url = url;
        return this;
    }

    public HttpSinkConfig setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpSinkConfig)) {
            return false;
        }
        HttpSinkConfig other = (HttpSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpSinkConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    public String toString() {
        return "HttpSinkConfig(url=" + this.getUrl() + ", headers=" + this.getHeaders() + ")";
    }
}

