/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kafka.connect.schema;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.DataException;
import org.apache.pulsar.client.api.schema.KeyValueSchema;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.kafka.shade.avro.Schema;
import org.apache.pulsar.kafka.shade.io.confluent.connect.avro.AvroData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarSchemaToKafkaSchema {
    private static final Logger log = LoggerFactory.getLogger(PulsarSchemaToKafkaSchema.class);
    private static final ImmutableMap<SchemaType, org.apache.kafka.connect.data.Schema> pulsarSchemaTypeToKafkaSchema;
    private static final ImmutableSet<String> kafkaLogicalSchemas;
    private static final AvroData avroData;
    private static final Cache<byte[], org.apache.kafka.connect.data.Schema> schemaCache;

    public static boolean matchesToKafkaLogicalSchema(org.apache.kafka.connect.data.Schema kafkaSchema) {
        return kafkaLogicalSchemas.contains((Object)kafkaSchema.name());
    }

    private static Schema parseAvroSchema(String schemaJson) {
        Schema.Parser parser = new Schema.Parser();
        parser.setValidateDefaults(false);
        return parser.parse(schemaJson);
    }

    public static org.apache.kafka.connect.data.Schema getKafkaConnectSchema(org.apache.pulsar.client.api.Schema pulsarSchema) {
        if (pulsarSchema == null || pulsarSchema.getSchemaInfo() == null) {
            throw PulsarSchemaToKafkaSchema.logAndThrowOnUnsupportedSchema(pulsarSchema, "Schema is required.", null);
        }
        String logicalSchemaName = pulsarSchema.getSchemaInfo().getName();
        if (kafkaLogicalSchemas.contains((Object)logicalSchemaName)) {
            if ("org.apache.kafka.connect.data.Timestamp".equals(logicalSchemaName)) {
                return Timestamp.SCHEMA;
            }
            if ("org.apache.kafka.connect.data.Date".equals(logicalSchemaName)) {
                return Date.SCHEMA;
            }
            if ("org.apache.kafka.connect.data.Time".equals(logicalSchemaName)) {
                return Time.SCHEMA;
            }
            if ("org.apache.kafka.connect.data.Decimal".equals(logicalSchemaName)) {
                int scale;
                String scaleString = null;
                if (pulsarSchema.getSchemaInfo().getProperties() != null) {
                    scaleString = (String)pulsarSchema.getSchemaInfo().getProperties().get("scale");
                }
                if (scaleString == null) {
                    throw new DataException("Invalid Decimal schema: scale parameter not found.");
                }
                try {
                    scale = Integer.parseInt(scaleString);
                }
                catch (NumberFormatException nfe) {
                    throw new DataException("Invalid scale parameter found in Decimal schema: ", (Throwable)nfe);
                }
                return Decimal.schema((int)scale);
            }
            throw new IllegalStateException("Unsupported Kafka Logical Schema " + logicalSchemaName);
        }
        if (pulsarSchemaTypeToKafkaSchema.containsKey((Object)pulsarSchema.getSchemaInfo().getType())) {
            return (org.apache.kafka.connect.data.Schema)pulsarSchemaTypeToKafkaSchema.get((Object)pulsarSchema.getSchemaInfo().getType());
        }
        try {
            return (org.apache.kafka.connect.data.Schema)schemaCache.get((Object)pulsarSchema.getSchemaInfo().getSchema(), () -> {
                if (pulsarSchema.getSchemaInfo().getType() == SchemaType.KEY_VALUE) {
                    KeyValueSchema kvSchema = (KeyValueSchema)pulsarSchema;
                    return SchemaBuilder.map((org.apache.kafka.connect.data.Schema)PulsarSchemaToKafkaSchema.getKafkaConnectSchema(kvSchema.getKeySchema()), (org.apache.kafka.connect.data.Schema)PulsarSchemaToKafkaSchema.getKafkaConnectSchema(kvSchema.getValueSchema())).build();
                }
                Schema avroSchema = PulsarSchemaToKafkaSchema.parseAvroSchema(new String(pulsarSchema.getSchemaInfo().getSchema(), StandardCharsets.UTF_8));
                return avroData.toConnectSchema(avroSchema);
            });
        }
        catch (ExecutionError | UncheckedExecutionException | ExecutionException ee) {
            throw PulsarSchemaToKafkaSchema.logAndThrowOnUnsupportedSchema(pulsarSchema, "Failed to convert to Kafka Schema.", ee);
        }
    }

    private static IllegalStateException logAndThrowOnUnsupportedSchema(org.apache.pulsar.client.api.Schema pulsarSchema, String prefix, Throwable cause) {
        String msg = prefix + " Pulsar Schema: " + (pulsarSchema == null || pulsarSchema.getSchemaInfo() == null ? "null" : pulsarSchema.getSchemaInfo().toString());
        log.error(msg);
        return new IllegalStateException(msg, cause);
    }

    static {
        avroData = new AvroData(1000);
        schemaCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(30L, TimeUnit.MINUTES).build();
        pulsarSchemaTypeToKafkaSchema = ImmutableMap.builder().put((Object)SchemaType.BOOLEAN, (Object)org.apache.kafka.connect.data.Schema.BOOLEAN_SCHEMA).put((Object)SchemaType.INT8, (Object)org.apache.kafka.connect.data.Schema.INT8_SCHEMA).put((Object)SchemaType.INT16, (Object)org.apache.kafka.connect.data.Schema.INT16_SCHEMA).put((Object)SchemaType.INT32, (Object)org.apache.kafka.connect.data.Schema.INT32_SCHEMA).put((Object)SchemaType.INT64, (Object)org.apache.kafka.connect.data.Schema.INT64_SCHEMA).put((Object)SchemaType.FLOAT, (Object)org.apache.kafka.connect.data.Schema.FLOAT32_SCHEMA).put((Object)SchemaType.DOUBLE, (Object)org.apache.kafka.connect.data.Schema.FLOAT64_SCHEMA).put((Object)SchemaType.STRING, (Object)org.apache.kafka.connect.data.Schema.STRING_SCHEMA).put((Object)SchemaType.BYTES, (Object)org.apache.kafka.connect.data.Schema.BYTES_SCHEMA).put((Object)SchemaType.DATE, (Object)Date.SCHEMA).build();
        kafkaLogicalSchemas = ImmutableSet.builder().add((Object)"org.apache.kafka.connect.data.Timestamp").add((Object)"org.apache.kafka.connect.data.Date").add((Object)"org.apache.kafka.connect.data.Time").add((Object)"org.apache.kafka.connect.data.Decimal").build();
    }
}

