/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kafka.connect.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avro.generic.GenericData;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;

public class KafkaConnectData {
    public static Object getKafkaConnectData(Object nativeObject, Schema kafkaSchema) {
        if (kafkaSchema == null) {
            return nativeObject;
        }
        if (nativeObject == null) {
            return KafkaConnectData.defaultOrThrow(kafkaSchema);
        }
        if (nativeObject instanceof JsonNode) {
            JsonNode node = (JsonNode)nativeObject;
            return KafkaConnectData.jsonAsConnectData(node, kafkaSchema);
        }
        if (nativeObject instanceof GenericData.Record) {
            GenericData.Record avroRecord = (GenericData.Record)nativeObject;
            return KafkaConnectData.avroAsConnectData(avroRecord, kafkaSchema);
        }
        return nativeObject;
    }

    static Object avroAsConnectData(GenericData.Record avroRecord, Schema kafkaSchema) {
        if (kafkaSchema == null) {
            if (avroRecord == null) {
                return null;
            }
            throw new DataException("Don't know how to convert " + avroRecord + " to Connect data (schema is null).");
        }
        Struct struct = new Struct(kafkaSchema);
        for (Field field : kafkaSchema.fields()) {
            struct.put(field, KafkaConnectData.getKafkaConnectData(avroRecord.get(field.name()), field.schema()));
        }
        return struct;
    }

    static Object jsonAsConnectData(JsonNode jsonNode, Schema kafkaSchema) {
        if (kafkaSchema == null) {
            if (jsonNode == null || jsonNode.isNull()) {
                return null;
            }
            switch (jsonNode.getNodeType()) {
                case BINARY: {
                    try {
                        return jsonNode.binaryValue();
                    }
                    catch (IOException e) {
                        throw new DataException("Cannot get binary value for " + jsonNode);
                    }
                }
                case BOOLEAN: {
                    return jsonNode.booleanValue();
                }
                case NUMBER: {
                    jsonNode.doubleValue();
                }
                case STRING: {
                    jsonNode.textValue();
                }
            }
            throw new DataException("Don't know how to convert " + jsonNode + " to Connect data (schema is null).");
        }
        if (jsonNode == null || jsonNode.isNull()) {
            return KafkaConnectData.defaultOrThrow(kafkaSchema);
        }
        switch (kafkaSchema.type()) {
            case INT8: {
                return (byte)jsonNode.shortValue();
            }
            case INT16: {
                return jsonNode.shortValue();
            }
            case INT32: {
                return jsonNode.intValue();
            }
            case INT64: {
                return jsonNode.longValue();
            }
            case FLOAT32: {
                return Float.valueOf(jsonNode.floatValue());
            }
            case FLOAT64: {
                return jsonNode.doubleValue();
            }
            case BOOLEAN: {
                return jsonNode.booleanValue();
            }
            case STRING: {
                return jsonNode.textValue();
            }
            case BYTES: {
                try {
                    return jsonNode.binaryValue();
                }
                catch (IOException e) {
                    throw new DataException("Cannot get binary value for " + jsonNode + " with schema " + kafkaSchema);
                }
            }
            case ARRAY: {
                ArrayList<Object> list = new ArrayList<Object>();
                Preconditions.checkArgument((boolean)jsonNode.isArray(), (Object)"jsonNode has to be an array");
                Iterator it = jsonNode.elements();
                while (it.hasNext()) {
                    list.add(KafkaConnectData.jsonAsConnectData((JsonNode)it.next(), kafkaSchema.valueSchema()));
                }
                return list;
            }
            case MAP: {
                HashMap<String, Object> map = new HashMap<String, Object>();
                Iterator it = jsonNode.fields();
                while (it.hasNext()) {
                    Map.Entry elem = (Map.Entry)it.next();
                    map.put((String)elem.getKey(), KafkaConnectData.jsonAsConnectData((JsonNode)elem.getValue(), kafkaSchema.valueSchema()));
                }
                return map;
            }
            case STRUCT: {
                Struct struct = new Struct(kafkaSchema);
                for (Field field : kafkaSchema.fields()) {
                    struct.put(field, KafkaConnectData.jsonAsConnectData(jsonNode.get(field.name()), field.schema()));
                }
                return struct;
            }
        }
        throw new DataException("Unknown schema type " + kafkaSchema.type());
    }

    private static Object defaultOrThrow(Schema kafkaSchema) {
        if (kafkaSchema.defaultValue() != null) {
            return kafkaSchema.defaultValue();
        }
        if (kafkaSchema.isOptional()) {
            return null;
        }
        throw new DataException("Invalid null value for required " + kafkaSchema.type() + " field");
    }
}

