/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kinesis;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.io.common.IOConfigUtils;
import org.apache.pulsar.io.core.SinkContext;
import org.apache.pulsar.io.core.annotations.FieldDoc;
import org.apache.pulsar.io.kinesis.BaseKinesisConfig;

public class KinesisSinkConfig
extends BaseKinesisConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=false, defaultValue="", help="Kinesis end-point port. It can be found at https://docs.aws.amazon.com/general/latest/gr/rande.html")
    private Integer awsEndpointPort;
    @FieldDoc(required=false, defaultValue="false", help="Tell to Kinesis Client to skip certificate validation. This is useful while performing local tests, it's recommended to always validate certificates in production environments.")
    private Boolean skipCertificateValidation = false;
    @FieldDoc(required=false, defaultValue="ONLY_RAW_PAYLOAD", help="Message format in which kinesis sink converts pulsar messages and publishes to kinesis streams.\n  #\n  # The available messages formats are: \n  #\n  # - ONLY_RAW_PAYLOAD \n  #\n  #   Kinesis sink directly publishes pulsar message payload as a message into the configured kinesis stream. \n  #\n  # - FULL_MESSAGE_IN_JSON \n  #\n  #   Kinesis sink creates a json payload with pulsar message payload, properties and encryptionCtx, \n  #   and publishes json payload into the configured kinesis stream.\n  #\n  # - FULL_MESSAGE_IN_FB \n  #\n  #   Kinesis sink creates a flatbuffer serialized paylaod with pulsar message payload, \n  #   properties and encryptionCtx, and publishes flatbuffer payload into the configured kinesis stream.  #\n  # - FULL_MESSAGE_IN_JSON_EXPAND_VALUE \n  #\n  #   Kinesis sink sends a JSON structure containing the record topic name, key, payload, properties and event time.\n  #   The record schema is used to convert the value to JSON.")
    private MessageFormat messageFormat = MessageFormat.ONLY_RAW_PAYLOAD;
    @FieldDoc(defaultValue="true", help="Value that indicates that only properties with non-null values are to be included when using MessageFormat.FULL_MESSAGE_IN_JSON_EXPAND_VALUE.")
    private boolean jsonIncludeNonNulls = true;
    @FieldDoc(defaultValue="false", help="When set to true and the message format is FULL_MESSAGE_IN_JSON_EXPAND_VALUE the output JSON will be flattened.")
    private boolean jsonFlatten = false;
    @FieldDoc(defaultValue="false", help="A flag to tell Pulsar IO to retain ordering when moving messages from Pulsar to Kinesis")
    private boolean retainOrdering = false;
    @FieldDoc(defaultValue="100", help="The initial delay(in milliseconds) between retries.")
    private long retryInitialDelayInMillis = 100L;
    @FieldDoc(defaultValue="60000", help="The maximum delay(in milliseconds) between retries.")
    private long retryMaxDelayInMillis = 60000L;

    public static KinesisSinkConfig load(Map<String, Object> config, SinkContext sinkContext) {
        KinesisSinkConfig kinesisSinkConfig = (KinesisSinkConfig)IOConfigUtils.loadWithSecrets(config, KinesisSinkConfig.class, (SinkContext)sinkContext);
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)kinesisSinkConfig.getAwsRegion()) || StringUtils.isNotBlank((CharSequence)kinesisSinkConfig.getAwsEndpoint()) && StringUtils.isNotBlank((CharSequence)kinesisSinkConfig.getCloudwatchEndpoint()) ? 1 : 0) != 0, (Object)"Either \"awsRegion\" must be set OR all of [\"awsEndpoint\", \"cloudwatchEndpoint\"] must be set.");
        return kinesisSinkConfig;
    }

    public Integer getAwsEndpointPort() {
        return this.awsEndpointPort;
    }

    public Boolean getSkipCertificateValidation() {
        return this.skipCertificateValidation;
    }

    public MessageFormat getMessageFormat() {
        return this.messageFormat;
    }

    public boolean isJsonIncludeNonNulls() {
        return this.jsonIncludeNonNulls;
    }

    public boolean isJsonFlatten() {
        return this.jsonFlatten;
    }

    public boolean isRetainOrdering() {
        return this.retainOrdering;
    }

    public long getRetryInitialDelayInMillis() {
        return this.retryInitialDelayInMillis;
    }

    public long getRetryMaxDelayInMillis() {
        return this.retryMaxDelayInMillis;
    }

    public void setAwsEndpointPort(Integer awsEndpointPort) {
        this.awsEndpointPort = awsEndpointPort;
    }

    public void setSkipCertificateValidation(Boolean skipCertificateValidation) {
        this.skipCertificateValidation = skipCertificateValidation;
    }

    public void setMessageFormat(MessageFormat messageFormat) {
        this.messageFormat = messageFormat;
    }

    public void setJsonIncludeNonNulls(boolean jsonIncludeNonNulls) {
        this.jsonIncludeNonNulls = jsonIncludeNonNulls;
    }

    public void setJsonFlatten(boolean jsonFlatten) {
        this.jsonFlatten = jsonFlatten;
    }

    public void setRetainOrdering(boolean retainOrdering) {
        this.retainOrdering = retainOrdering;
    }

    public void setRetryInitialDelayInMillis(long retryInitialDelayInMillis) {
        this.retryInitialDelayInMillis = retryInitialDelayInMillis;
    }

    public void setRetryMaxDelayInMillis(long retryMaxDelayInMillis) {
        this.retryMaxDelayInMillis = retryMaxDelayInMillis;
    }

    @Override
    public String toString() {
        return "KinesisSinkConfig(awsEndpointPort=" + this.getAwsEndpointPort() + ", skipCertificateValidation=" + this.getSkipCertificateValidation() + ", messageFormat=" + this.getMessageFormat() + ", jsonIncludeNonNulls=" + this.isJsonIncludeNonNulls() + ", jsonFlatten=" + this.isJsonFlatten() + ", retainOrdering=" + this.isRetainOrdering() + ", retryInitialDelayInMillis=" + this.getRetryInitialDelayInMillis() + ", retryMaxDelayInMillis=" + this.getRetryMaxDelayInMillis() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KinesisSinkConfig)) {
            return false;
        }
        KinesisSinkConfig other = (KinesisSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isJsonIncludeNonNulls() != other.isJsonIncludeNonNulls()) {
            return false;
        }
        if (this.isJsonFlatten() != other.isJsonFlatten()) {
            return false;
        }
        if (this.isRetainOrdering() != other.isRetainOrdering()) {
            return false;
        }
        if (this.getRetryInitialDelayInMillis() != other.getRetryInitialDelayInMillis()) {
            return false;
        }
        if (this.getRetryMaxDelayInMillis() != other.getRetryMaxDelayInMillis()) {
            return false;
        }
        Integer this$awsEndpointPort = this.getAwsEndpointPort();
        Integer other$awsEndpointPort = other.getAwsEndpointPort();
        if (this$awsEndpointPort == null ? other$awsEndpointPort != null : !((Object)this$awsEndpointPort).equals(other$awsEndpointPort)) {
            return false;
        }
        Boolean this$skipCertificateValidation = this.getSkipCertificateValidation();
        Boolean other$skipCertificateValidation = other.getSkipCertificateValidation();
        if (this$skipCertificateValidation == null ? other$skipCertificateValidation != null : !((Object)this$skipCertificateValidation).equals(other$skipCertificateValidation)) {
            return false;
        }
        MessageFormat this$messageFormat = this.getMessageFormat();
        MessageFormat other$messageFormat = other.getMessageFormat();
        return !(this$messageFormat == null ? other$messageFormat != null : !((Object)((Object)this$messageFormat)).equals((Object)other$messageFormat));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KinesisSinkConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isJsonIncludeNonNulls() ? 79 : 97);
        result = result * 59 + (this.isJsonFlatten() ? 79 : 97);
        result = result * 59 + (this.isRetainOrdering() ? 79 : 97);
        long $retryInitialDelayInMillis = this.getRetryInitialDelayInMillis();
        result = result * 59 + (int)($retryInitialDelayInMillis >>> 32 ^ $retryInitialDelayInMillis);
        long $retryMaxDelayInMillis = this.getRetryMaxDelayInMillis();
        result = result * 59 + (int)($retryMaxDelayInMillis >>> 32 ^ $retryMaxDelayInMillis);
        Integer $awsEndpointPort = this.getAwsEndpointPort();
        result = result * 59 + ($awsEndpointPort == null ? 43 : ((Object)$awsEndpointPort).hashCode());
        Boolean $skipCertificateValidation = this.getSkipCertificateValidation();
        result = result * 59 + ($skipCertificateValidation == null ? 43 : ((Object)$skipCertificateValidation).hashCode());
        MessageFormat $messageFormat = this.getMessageFormat();
        result = result * 59 + ($messageFormat == null ? 43 : ((Object)((Object)$messageFormat)).hashCode());
        return result;
    }

    public static enum MessageFormat {
        ONLY_RAW_PAYLOAD,
        FULL_MESSAGE_IN_JSON,
        FULL_MESSAGE_IN_FB,
        FULL_MESSAGE_IN_JSON_EXPAND_VALUE;

    }
}

