/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kinesis;

import java.io.Serializable;
import org.apache.pulsar.io.core.annotations.FieldDoc;
import software.amazon.awssdk.regions.Region;

public abstract class BaseKinesisConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=false, defaultValue="", help="Kinesis end-point url. It can be found at https://docs.aws.amazon.com/general/latest/gr/rande.html")
    private String awsEndpoint = "";
    @FieldDoc(required=false, defaultValue="", help="Cloudwatch end-point url. It can be found at https://docs.aws.amazon.com/general/latest/gr/rande.html")
    private String cloudwatchEndpoint = "";
    @FieldDoc(required=false, defaultValue="", help="Appropriate aws region. E.g. us-west-1, us-west-2")
    private String awsRegion = "";
    @FieldDoc(required=true, defaultValue="", help="Kinesis stream name")
    private String awsKinesisStreamName = "";
    @FieldDoc(required=false, defaultValue="", help="Fully-Qualified class name of implementation of AwsCredentialProviderPlugin. It is a factory class which creates an AWSCredentialsProvider that will be used by Kinesis Sink. If it is empty then KinesisSink will create a default AWSCredentialsProvider which accepts json-map of credentials in `awsCredentialPluginParam`")
    private String awsCredentialPluginName = "";
    @FieldDoc(required=true, defaultValue="", sensitive=true, help="json-parameters to initialize `AwsCredentialsProviderPlugin`")
    private String awsCredentialPluginParam = "";

    protected Region regionAsV2Region() {
        return Region.of((String)this.getAwsRegion());
    }

    public String getAwsEndpoint() {
        return this.awsEndpoint;
    }

    public String getCloudwatchEndpoint() {
        return this.cloudwatchEndpoint;
    }

    public String getAwsRegion() {
        return this.awsRegion;
    }

    public String getAwsKinesisStreamName() {
        return this.awsKinesisStreamName;
    }

    public String getAwsCredentialPluginName() {
        return this.awsCredentialPluginName;
    }

    public String getAwsCredentialPluginParam() {
        return this.awsCredentialPluginParam;
    }

    public void setAwsEndpoint(String awsEndpoint) {
        this.awsEndpoint = awsEndpoint;
    }

    public void setCloudwatchEndpoint(String cloudwatchEndpoint) {
        this.cloudwatchEndpoint = cloudwatchEndpoint;
    }

    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }

    public void setAwsKinesisStreamName(String awsKinesisStreamName) {
        this.awsKinesisStreamName = awsKinesisStreamName;
    }

    public void setAwsCredentialPluginName(String awsCredentialPluginName) {
        this.awsCredentialPluginName = awsCredentialPluginName;
    }

    public void setAwsCredentialPluginParam(String awsCredentialPluginParam) {
        this.awsCredentialPluginParam = awsCredentialPluginParam;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseKinesisConfig)) {
            return false;
        }
        BaseKinesisConfig other = (BaseKinesisConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$awsEndpoint = this.getAwsEndpoint();
        String other$awsEndpoint = other.getAwsEndpoint();
        if (this$awsEndpoint == null ? other$awsEndpoint != null : !this$awsEndpoint.equals(other$awsEndpoint)) {
            return false;
        }
        String this$cloudwatchEndpoint = this.getCloudwatchEndpoint();
        String other$cloudwatchEndpoint = other.getCloudwatchEndpoint();
        if (this$cloudwatchEndpoint == null ? other$cloudwatchEndpoint != null : !this$cloudwatchEndpoint.equals(other$cloudwatchEndpoint)) {
            return false;
        }
        String this$awsRegion = this.getAwsRegion();
        String other$awsRegion = other.getAwsRegion();
        if (this$awsRegion == null ? other$awsRegion != null : !this$awsRegion.equals(other$awsRegion)) {
            return false;
        }
        String this$awsKinesisStreamName = this.getAwsKinesisStreamName();
        String other$awsKinesisStreamName = other.getAwsKinesisStreamName();
        if (this$awsKinesisStreamName == null ? other$awsKinesisStreamName != null : !this$awsKinesisStreamName.equals(other$awsKinesisStreamName)) {
            return false;
        }
        String this$awsCredentialPluginName = this.getAwsCredentialPluginName();
        String other$awsCredentialPluginName = other.getAwsCredentialPluginName();
        if (this$awsCredentialPluginName == null ? other$awsCredentialPluginName != null : !this$awsCredentialPluginName.equals(other$awsCredentialPluginName)) {
            return false;
        }
        String this$awsCredentialPluginParam = this.getAwsCredentialPluginParam();
        String other$awsCredentialPluginParam = other.getAwsCredentialPluginParam();
        return !(this$awsCredentialPluginParam == null ? other$awsCredentialPluginParam != null : !this$awsCredentialPluginParam.equals(other$awsCredentialPluginParam));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseKinesisConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $awsEndpoint = this.getAwsEndpoint();
        result = result * 59 + ($awsEndpoint == null ? 43 : $awsEndpoint.hashCode());
        String $cloudwatchEndpoint = this.getCloudwatchEndpoint();
        result = result * 59 + ($cloudwatchEndpoint == null ? 43 : $cloudwatchEndpoint.hashCode());
        String $awsRegion = this.getAwsRegion();
        result = result * 59 + ($awsRegion == null ? 43 : $awsRegion.hashCode());
        String $awsKinesisStreamName = this.getAwsKinesisStreamName();
        result = result * 59 + ($awsKinesisStreamName == null ? 43 : $awsKinesisStreamName.hashCode());
        String $awsCredentialPluginName = this.getAwsCredentialPluginName();
        result = result * 59 + ($awsCredentialPluginName == null ? 43 : $awsCredentialPluginName.hashCode());
        String $awsCredentialPluginParam = this.getAwsCredentialPluginParam();
        result = result * 59 + ($awsCredentialPluginParam == null ? 43 : $awsCredentialPluginParam.hashCode());
        return result;
    }

    public String toString() {
        return "BaseKinesisConfig(awsEndpoint=" + this.getAwsEndpoint() + ", cloudwatchEndpoint=" + this.getCloudwatchEndpoint() + ", awsRegion=" + this.getAwsRegion() + ", awsKinesisStreamName=" + this.getAwsKinesisStreamName() + ", awsCredentialPluginName=" + this.getAwsCredentialPluginName() + ", awsCredentialPluginParam=" + this.getAwsCredentialPluginParam() + ")";
    }
}

