/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.mongodb;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.io.common.IOConfigUtils;
import org.apache.pulsar.io.core.SourceContext;
import org.apache.pulsar.io.core.annotations.FieldDoc;
import org.apache.pulsar.io.mongodb.MongoAbstractConfig;
import org.apache.pulsar.io.mongodb.SyncType;

public class MongoSourceConfig
extends MongoAbstractConfig {
    private static final long serialVersionUID = 1152890092264945317L;
    public static final SyncType DEFAULT_SYNC_TYPE = SyncType.INCR_SYNC;
    public static final String DEFAULT_SYNC_TYPE_STR = "INCR_SYNC";
    @FieldDoc(defaultValue="INCR_SYNC", help="The message synchronization type of the source connector. The field values can be of two types: incr and full. When it is set to incr, the source connector will only watch for changes made from now on. When it is set to full, the source connector will synchronize currently existing messages and watch for future changes.")
    private SyncType syncType = DEFAULT_SYNC_TYPE;

    @JsonCreator
    public MongoSourceConfig(@JsonProperty(value="mongoUri") String mongoUri, @JsonProperty(value="database") String database, @JsonProperty(value="collection") String collection, @JsonProperty(value="batchSize") int batchSize, @JsonProperty(value="batchTimeMs") long batchTimeMs, @JsonProperty(value="syncType") String syncType) {
        super(mongoUri, database, collection, batchSize, batchTimeMs);
        this.setSyncType(syncType);
    }

    public static MongoSourceConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        MongoSourceConfig cfg = (MongoSourceConfig)mapper.readValue(new File(yamlFile), MongoSourceConfig.class);
        return cfg;
    }

    public static MongoSourceConfig load(Map<String, Object> map, SourceContext sourceContext) throws IOException {
        return (MongoSourceConfig)IOConfigUtils.loadWithSecrets(map, MongoSourceConfig.class, (SourceContext)sourceContext);
    }

    private void setSyncType(String syncTypeStr) {
        if (StringUtils.isEmpty((CharSequence)syncTypeStr)) {
            this.syncType = DEFAULT_SYNC_TYPE;
            return;
        }
        try {
            this.syncType = SyncType.valueOf(syncTypeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The value of the syncType field is incorrect.");
        }
    }

    @Override
    public void validate() {
        super.validate();
    }

    public SyncType getSyncType() {
        return this.syncType;
    }

    @Override
    public String toString() {
        return "MongoSourceConfig(syncType=" + String.valueOf((Object)this.getSyncType()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MongoSourceConfig)) {
            return false;
        }
        MongoSourceConfig other = (MongoSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SyncType this$syncType = this.getSyncType();
        SyncType other$syncType = other.getSyncType();
        return !(this$syncType == null ? other$syncType != null : !((Object)((Object)this$syncType)).equals((Object)other$syncType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MongoSourceConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SyncType $syncType = this.getSyncType();
        result = result * 59 + ($syncType == null ? 43 : ((Object)((Object)$syncType)).hashCode());
        return result;
    }
}

