/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.netty.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslContext;

public class NettyHttpChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private final SslContext sslCtx;
    private ChannelInboundHandlerAdapter handler;

    public NettyHttpChannelInitializer(ChannelInboundHandlerAdapter handler, SslContext sslCtx) {
        this.handler = handler;
        this.sslCtx = sslCtx;
    }

    protected void initChannel(SocketChannel socketChannel) throws Exception {
        if (this.sslCtx != null) {
            socketChannel.pipeline().addLast(new ChannelHandler[]{this.sslCtx.newHandler(socketChannel.alloc())});
        }
        socketChannel.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()});
        socketChannel.pipeline().addLast(new ChannelHandler[]{this.handler});
    }
}

