/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.netty.udp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.netty.NettySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class NettyUDPServerHandler
extends SimpleChannelInboundHandler<DatagramPacket> {
    private static final Logger logger = LoggerFactory.getLogger(NettyUDPServerHandler.class);
    private NettySource nettySource;

    public NettyUDPServerHandler(NettySource nettySource) {
        this.nettySource = nettySource;
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, DatagramPacket packet) throws Exception {
        byte[] bytes = ByteBufUtil.getBytes((ByteBuf)((ByteBuf)packet.content()));
        this.nettySource.consume(new NettyUDPRecord(Optional.of(""), bytes));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("Error when processing incoming data", cause);
        ctx.close();
    }

    private static class NettyUDPRecord
    implements Record<byte[]>,
    Serializable {
        private final Optional<String> key;
        private final byte[] value;

        public NettyUDPRecord(Optional<String> key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        public Optional<String> getKey() {
            return this.key;
        }

        public byte[] getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NettyUDPRecord)) {
                return false;
            }
            NettyUDPRecord other = (NettyUDPRecord)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Optional<String> this$key = this.getKey();
            Optional<String> other$key = other.getKey();
            if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        protected boolean canEqual(Object other) {
            return other instanceof NettyUDPRecord;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        public String toString() {
            return "NettyUDPServerHandler.NettyUDPRecord(key=" + this.getKey() + ", value=" + Arrays.toString(this.getValue()) + ")";
        }
    }
}

