/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.rabbitmq;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.pulsar.io.common.IOConfigUtils;
import org.apache.pulsar.io.core.SinkContext;
import org.apache.pulsar.io.core.annotations.FieldDoc;
import org.apache.pulsar.io.rabbitmq.RabbitMQAbstractConfig;

public class RabbitMQSinkConfig
extends RabbitMQAbstractConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=true, defaultValue="", help="The exchange to publish the messages on")
    private String exchangeName;
    @FieldDoc(required=false, defaultValue="", help="The routing key used for publishing the messages")
    private String routingKey;
    @FieldDoc(required=false, defaultValue="topic", help="The exchange type to publish the messages on")
    private String exchangeType = "topic";

    public static RabbitMQSinkConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (RabbitMQSinkConfig)mapper.readValue(new File(yamlFile), RabbitMQSinkConfig.class);
    }

    public static RabbitMQSinkConfig load(Map<String, Object> map, SinkContext sinkContext) throws IOException {
        return (RabbitMQSinkConfig)IOConfigUtils.loadWithSecrets(map, RabbitMQSinkConfig.class, (SinkContext)sinkContext);
    }

    @Override
    public void validate() {
        super.validate();
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public String getExchangeType() {
        return this.exchangeType;
    }

    public RabbitMQSinkConfig setExchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
        return this;
    }

    public RabbitMQSinkConfig setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
        return this;
    }

    public RabbitMQSinkConfig setExchangeType(String exchangeType) {
        this.exchangeType = exchangeType;
        return this;
    }

    @Override
    public String toString() {
        return "RabbitMQSinkConfig(exchangeName=" + this.getExchangeName() + ", routingKey=" + this.getRoutingKey() + ", exchangeType=" + this.getExchangeType() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RabbitMQSinkConfig)) {
            return false;
        }
        RabbitMQSinkConfig other = (RabbitMQSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$exchangeName = this.getExchangeName();
        String other$exchangeName = other.getExchangeName();
        if (this$exchangeName == null ? other$exchangeName != null : !this$exchangeName.equals(other$exchangeName)) {
            return false;
        }
        String this$routingKey = this.getRoutingKey();
        String other$routingKey = other.getRoutingKey();
        if (this$routingKey == null ? other$routingKey != null : !this$routingKey.equals(other$routingKey)) {
            return false;
        }
        String this$exchangeType = this.getExchangeType();
        String other$exchangeType = other.getExchangeType();
        return !(this$exchangeType == null ? other$exchangeType != null : !this$exchangeType.equals(other$exchangeType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RabbitMQSinkConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $exchangeName = this.getExchangeName();
        result = result * 59 + ($exchangeName == null ? 43 : $exchangeName.hashCode());
        String $routingKey = this.getRoutingKey();
        result = result * 59 + ($routingKey == null ? 43 : $routingKey.hashCode());
        String $exchangeType = this.getExchangeType();
        result = result * 59 + ($exchangeType == null ? 43 : $exchangeType.hashCode());
        return result;
    }
}

