/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.twitter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class TwitterFireHoseConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=true, defaultValue="", sensitive=true, help="Your twitter app consumer key. See https://developer.twitter.com/en/docs/basics/authentication/guides/access-tokens for details")
    private String consumerKey;
    @FieldDoc(required=true, defaultValue="", sensitive=true, help="Your twitter app consumer secret. See https://developer.twitter.com/en/docs/basics/authentication/guides/access-tokens for details")
    private String consumerSecret;
    @FieldDoc(required=true, defaultValue="", sensitive=true, help="Your twitter app token. See https://developer.twitter.com/en/docs/basics/authentication/guides/access-tokens for details")
    private String token;
    @FieldDoc(required=true, defaultValue="", sensitive=true, help="Your twitter app token secret. See https://developer.twitter.com/en/docs/basics/authentication/guides/access-tokens for details")
    private String tokenSecret;
    @FieldDoc(required=false, defaultValue="false", help="Most firehose events have null createdAt time.If this parameter is set to true, the connector estimates the createdTime of each firehose event to be current time.")
    private Boolean guestimateTweetTime = false;
    @FieldDoc(required=false, defaultValue="pulsario-twitter-source", help="The Twitter Firehose Client name")
    private String clientName = "pulsario-twitter-source";
    @FieldDoc(required=false, defaultValue="https://stream.twitter.com", help="The Twitter Firehose stream hosts that the connector connects to")
    private String clientHosts = "https://stream.twitter.com";
    @FieldDoc(required=false, defaultValue="50000", help="The Twitter Firehose client buffer size")
    private int clientBufferSize = 50000;
    @FieldDoc(required=false, defaultValue="", help="A comma separated list of user IDs, indicating the users to return statuses for in the stream.")
    private String followings;
    @FieldDoc(required=false, defaultValue="", help="Keywords to track. Phrases of keywords are specified by a comma-separated list.")
    private String terms;

    public static TwitterFireHoseConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (TwitterFireHoseConfig)mapper.readValue(new File(yamlFile), TwitterFireHoseConfig.class);
    }

    public static TwitterFireHoseConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (TwitterFireHoseConfig)mapper.readValue(mapper.writeValueAsString(map), TwitterFireHoseConfig.class);
    }

    public void validate() throws IllegalArgumentException {
        if (this.getConsumerKey() == null || this.getConsumerSecret() == null || this.getToken() == null || this.getTokenSecret() == null) {
            throw new IllegalArgumentException("Required property not set.");
        }
    }

    public List<Long> getFollowings() {
        if (StringUtils.isBlank((CharSequence)this.followings)) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        for (String s : StringUtils.split((String)this.followings, (String)",")) {
            try {
                result.add(Long.parseLong(StringUtils.trim((String)s)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return CollectionUtils.isEmpty(result) ? Collections.emptyList() : result;
    }

    public List<String> getTrackTerms() {
        if (StringUtils.isBlank((CharSequence)this.terms)) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])StringUtils.split((String)this.terms, (String)","));
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public String getToken() {
        return this.token;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    public Boolean getGuestimateTweetTime() {
        return this.guestimateTweetTime;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getClientHosts() {
        return this.clientHosts;
    }

    public int getClientBufferSize() {
        return this.clientBufferSize;
    }

    public String getTerms() {
        return this.terms;
    }

    public TwitterFireHoseConfig setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
        return this;
    }

    public TwitterFireHoseConfig setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
        return this;
    }

    public TwitterFireHoseConfig setToken(String token) {
        this.token = token;
        return this;
    }

    public TwitterFireHoseConfig setTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
        return this;
    }

    public TwitterFireHoseConfig setGuestimateTweetTime(Boolean guestimateTweetTime) {
        this.guestimateTweetTime = guestimateTweetTime;
        return this;
    }

    public TwitterFireHoseConfig setClientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    public TwitterFireHoseConfig setClientHosts(String clientHosts) {
        this.clientHosts = clientHosts;
        return this;
    }

    public TwitterFireHoseConfig setClientBufferSize(int clientBufferSize) {
        this.clientBufferSize = clientBufferSize;
        return this;
    }

    public TwitterFireHoseConfig setFollowings(String followings) {
        this.followings = followings;
        return this;
    }

    public TwitterFireHoseConfig setTerms(String terms) {
        this.terms = terms;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TwitterFireHoseConfig)) {
            return false;
        }
        TwitterFireHoseConfig other = (TwitterFireHoseConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getClientBufferSize() != other.getClientBufferSize()) {
            return false;
        }
        Boolean this$guestimateTweetTime = this.getGuestimateTweetTime();
        Boolean other$guestimateTweetTime = other.getGuestimateTweetTime();
        if (this$guestimateTweetTime == null ? other$guestimateTweetTime != null : !((Object)this$guestimateTweetTime).equals(other$guestimateTweetTime)) {
            return false;
        }
        String this$consumerKey = this.getConsumerKey();
        String other$consumerKey = other.getConsumerKey();
        if (this$consumerKey == null ? other$consumerKey != null : !this$consumerKey.equals(other$consumerKey)) {
            return false;
        }
        String this$consumerSecret = this.getConsumerSecret();
        String other$consumerSecret = other.getConsumerSecret();
        if (this$consumerSecret == null ? other$consumerSecret != null : !this$consumerSecret.equals(other$consumerSecret)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$tokenSecret = this.getTokenSecret();
        String other$tokenSecret = other.getTokenSecret();
        if (this$tokenSecret == null ? other$tokenSecret != null : !this$tokenSecret.equals(other$tokenSecret)) {
            return false;
        }
        String this$clientName = this.getClientName();
        String other$clientName = other.getClientName();
        if (this$clientName == null ? other$clientName != null : !this$clientName.equals(other$clientName)) {
            return false;
        }
        String this$clientHosts = this.getClientHosts();
        String other$clientHosts = other.getClientHosts();
        if (this$clientHosts == null ? other$clientHosts != null : !this$clientHosts.equals(other$clientHosts)) {
            return false;
        }
        List<Long> this$followings = this.getFollowings();
        List<Long> other$followings = other.getFollowings();
        if (this$followings == null ? other$followings != null : !((Object)this$followings).equals(other$followings)) {
            return false;
        }
        String this$terms = this.getTerms();
        String other$terms = other.getTerms();
        return !(this$terms == null ? other$terms != null : !this$terms.equals(other$terms));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TwitterFireHoseConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getClientBufferSize();
        Boolean $guestimateTweetTime = this.getGuestimateTweetTime();
        result = result * 59 + ($guestimateTweetTime == null ? 43 : ((Object)$guestimateTweetTime).hashCode());
        String $consumerKey = this.getConsumerKey();
        result = result * 59 + ($consumerKey == null ? 43 : $consumerKey.hashCode());
        String $consumerSecret = this.getConsumerSecret();
        result = result * 59 + ($consumerSecret == null ? 43 : $consumerSecret.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $tokenSecret = this.getTokenSecret();
        result = result * 59 + ($tokenSecret == null ? 43 : $tokenSecret.hashCode());
        String $clientName = this.getClientName();
        result = result * 59 + ($clientName == null ? 43 : $clientName.hashCode());
        String $clientHosts = this.getClientHosts();
        result = result * 59 + ($clientHosts == null ? 43 : $clientHosts.hashCode());
        List<Long> $followings = this.getFollowings();
        result = result * 59 + ($followings == null ? 43 : ((Object)$followings).hashCode());
        String $terms = this.getTerms();
        result = result * 59 + ($terms == null ? 43 : $terms.hashCode());
        return result;
    }

    public String toString() {
        return "TwitterFireHoseConfig(consumerKey=" + this.getConsumerKey() + ", consumerSecret=" + this.getConsumerSecret() + ", token=" + this.getToken() + ", tokenSecret=" + this.getTokenSecret() + ", guestimateTweetTime=" + this.getGuestimateTweetTime() + ", clientName=" + this.getClientName() + ", clientHosts=" + this.getClientHosts() + ", clientBufferSize=" + this.getClientBufferSize() + ", followings=" + String.valueOf(this.getFollowings()) + ", terms=" + this.getTerms() + ")";
    }
}

