/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cli;

import com.google.common.io.Closer;
import io.prestosql.cli.InputHighlighter;
import io.prestosql.cli.InputParser;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import org.jline.reader.Completer;
import org.jline.reader.Highlighter;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;

public class InputReader
implements Closeable {
    private final LineReader reader;

    public InputReader(Path historyFile, Completer ... completers) throws IOException {
        Terminal terminal = TerminalBuilder.builder().name("Presto").build();
        this.reader = LineReaderBuilder.builder().terminal(terminal).variable("history-file", (Object)historyFile).variable("secondary-prompt-pattern", (Object)InputReader.colored("%P -> ")).variable("blink-matching-paren", (Object)0).parser((Parser)new InputParser()).highlighter((Highlighter)new InputHighlighter()).completer((Completer)new AggregateCompleter(completers)).build();
        this.reader.unsetOpt(LineReader.Option.HISTORY_TIMESTAMPED);
    }

    public String readLine(String prompt, String buffer) {
        return this.reader.readLine(InputReader.colored(prompt), null, buffer);
    }

    @Override
    public void close() throws IOException {
        try (Closer closer = Closer.create();){
            closer.register(() -> ((History)this.getHistory()).save());
            closer.register((Closeable)this.getTerminal());
        }
    }

    public History getHistory() {
        return this.reader.getHistory();
    }

    public Terminal getTerminal() {
        return this.reader.getTerminal();
    }

    private static String colored(String value) {
        return new AttributedString((CharSequence)value, AttributedStyle.DEFAULT.foreground(8)).toAnsi();
    }
}

