/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.matching.pattern;

import io.prestosql.matching.Captures;
import io.prestosql.matching.Match;
import io.prestosql.matching.Pattern;
import io.prestosql.matching.PatternVisitor;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Stream;

public class FilterPattern<T>
extends Pattern<T> {
    private final BiPredicate<? super T, ?> predicate;

    public FilterPattern(BiPredicate<? super T, ?> predicate, Optional<Pattern<?>> previous) {
        super(previous);
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
    }

    public BiPredicate<? super T, ?> predicate() {
        return this.predicate;
    }

    @Override
    public <C> Stream<Match> accept(Object object, Captures captures, C context) {
        BiPredicate predicate = this.predicate;
        return Stream.of(Match.of(captures)).filter(match -> predicate.test(object, context));
    }

    @Override
    public void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitFilter(this);
    }
}

