/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.predicate;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.predicate.AllOrNoneValueSet;
import io.prestosql.spi.predicate.DiscreteValues;
import io.prestosql.spi.predicate.EquatableValueSet;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.Ranges;
import io.prestosql.spi.predicate.SortedRangeSet;
import io.prestosql.spi.predicate.ValuesProcessor;
import io.prestosql.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="@type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=EquatableValueSet.class, name="equatable"), @JsonSubTypes.Type(value=SortedRangeSet.class, name="sortable"), @JsonSubTypes.Type(value=AllOrNoneValueSet.class, name="allOrNone")})
public interface ValueSet {
    public static ValueSet none(Type type) {
        if (type.isOrderable()) {
            return SortedRangeSet.none(type);
        }
        if (type.isComparable()) {
            return EquatableValueSet.none(type);
        }
        return AllOrNoneValueSet.none(type);
    }

    public static ValueSet all(Type type) {
        if (type.isOrderable()) {
            return SortedRangeSet.all(type);
        }
        if (type.isComparable()) {
            return EquatableValueSet.all(type);
        }
        return AllOrNoneValueSet.all(type);
    }

    public static ValueSet of(Type type, Object first, Object ... rest) {
        if (type.isOrderable()) {
            return SortedRangeSet.of(type, first, rest);
        }
        if (type.isComparable()) {
            return EquatableValueSet.of(type, first, rest);
        }
        throw new IllegalArgumentException("Cannot create discrete ValueSet with non-comparable type: " + type);
    }

    public static ValueSet copyOf(Type type, Collection<Object> values) {
        if (type.isOrderable()) {
            return SortedRangeSet.copyOf(type, values.stream().map(value -> Range.equal(type, value)).collect(Collectors.toList()));
        }
        if (type.isComparable()) {
            return EquatableValueSet.copyOf(type, values);
        }
        throw new IllegalArgumentException("Cannot create discrete ValueSet with non-comparable type: " + type);
    }

    public static ValueSet ofRanges(Range first, Range ... rest) {
        return SortedRangeSet.of(first, rest);
    }

    public static ValueSet copyOfRanges(Type type, Collection<Range> ranges) {
        return SortedRangeSet.copyOf(type, ranges);
    }

    public Type getType();

    public boolean isNone();

    public boolean isAll();

    public boolean isSingleValue();

    public Object getSingleValue();

    public boolean isDiscreteSet();

    public List<Object> getDiscreteSet();

    public boolean containsValue(Object var1);

    default public DiscreteValues getDiscreteValues() {
        throw new UnsupportedOperationException();
    }

    default public Ranges getRanges() {
        throw new UnsupportedOperationException();
    }

    public ValuesProcessor getValuesProcessor();

    public ValueSet intersect(ValueSet var1);

    public ValueSet union(ValueSet var1);

    default public ValueSet union(Collection<ValueSet> valueSets) {
        ValueSet current = this;
        for (ValueSet valueSet : valueSets) {
            current = current.union(valueSet);
        }
        return current;
    }

    public ValueSet complement();

    default public boolean overlaps(ValueSet other) {
        return !this.intersect(other).isNone();
    }

    default public ValueSet subtract(ValueSet other) {
        return this.intersect(other.complement());
    }

    default public boolean contains(ValueSet other) {
        return this.union(other).equals(this);
    }

    public String toString(ConnectorSession var1);
}

