/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.base.Preconditions;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.FastThreadLocal;
import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.ConsumerBase;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnAckedMessageTracker
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(UnAckedMessageTracker.class);
    protected final ConcurrentHashMap<MessageId, ConcurrentOpenHashSet<MessageId>> messageIdPartitionMap;
    protected final ArrayDeque<ConcurrentOpenHashSet<MessageId>> timePartitions;
    protected final Lock readLock;
    protected final Lock writeLock;
    public static final UnAckedMessageTrackerDisabled UNACKED_MESSAGE_TRACKER_DISABLED = new UnAckedMessageTrackerDisabled();
    private final long ackTimeoutMillis;
    private final long tickDurationInMs;
    private Timeout timeout;
    private static final FastThreadLocal<HashSet<MessageId>> TL_MESSAGE_IDS_SET = new FastThreadLocal<HashSet<MessageId>>(){

        protected HashSet<MessageId> initialValue() throws Exception {
            return new HashSet<MessageId>();
        }
    };

    public UnAckedMessageTracker() {
        this.readLock = null;
        this.writeLock = null;
        this.timePartitions = null;
        this.messageIdPartitionMap = null;
        this.ackTimeoutMillis = 0L;
        this.tickDurationInMs = 0L;
    }

    public UnAckedMessageTracker(PulsarClientImpl client, ConsumerBase<?> consumerBase, long ackTimeoutMillis) {
        this(client, consumerBase, ackTimeoutMillis, ackTimeoutMillis);
    }

    public UnAckedMessageTracker(final PulsarClientImpl client, final ConsumerBase<?> consumerBase, long ackTimeoutMillis, final long tickDurationInMs) {
        Preconditions.checkArgument((tickDurationInMs > 0L && ackTimeoutMillis >= tickDurationInMs ? 1 : 0) != 0);
        this.ackTimeoutMillis = ackTimeoutMillis;
        this.tickDurationInMs = tickDurationInMs;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.messageIdPartitionMap = new ConcurrentHashMap();
        this.timePartitions = new ArrayDeque();
        int blankPartitions = (int)Math.ceil((double)this.ackTimeoutMillis / (double)this.tickDurationInMs);
        for (int i = 0; i < blankPartitions + 1; ++i) {
            this.timePartitions.add((ConcurrentOpenHashSet<MessageId>)new ConcurrentOpenHashSet(16, 1));
        }
        this.timeout = client.timer().newTimeout(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(Timeout t) throws Exception {
                Set messageIds = (Set)TL_MESSAGE_IDS_SET.get();
                messageIds.clear();
                UnAckedMessageTracker.this.writeLock.lock();
                try {
                    ConcurrentOpenHashSet<MessageId> headPartition = UnAckedMessageTracker.this.timePartitions.removeFirst();
                    if (!headPartition.isEmpty()) {
                        log.warn("[{}] {} messages have timed-out", (Object)consumerBase, (Object)headPartition.size());
                        headPartition.forEach(messageId -> {
                            UnAckedMessageTracker.addChunkedMessageIdsAndRemoveFromSequenceMap(messageId, messageIds, consumerBase);
                            messageIds.add(messageId);
                            UnAckedMessageTracker.this.messageIdPartitionMap.remove(messageId);
                        });
                    }
                    headPartition.clear();
                    UnAckedMessageTracker.this.timePartitions.addLast(headPartition);
                }
                finally {
                    UnAckedMessageTracker.this.writeLock.unlock();
                    if (messageIds.size() > 0) {
                        consumerBase.onAckTimeoutSend(messageIds);
                        consumerBase.redeliverUnacknowledgedMessages(messageIds);
                    }
                    UnAckedMessageTracker.this.timeout = client.timer().newTimeout((TimerTask)this, tickDurationInMs, TimeUnit.MILLISECONDS);
                }
            }
        }, this.tickDurationInMs, TimeUnit.MILLISECONDS);
    }

    public static void addChunkedMessageIdsAndRemoveFromSequenceMap(MessageId messageId, Set<MessageId> messageIds, ConsumerBase<?> consumerBase) {
        if (messageId instanceof MessageIdImpl) {
            MessageIdImpl[] chunkedMsgIds = (MessageIdImpl[])consumerBase.unAckedChunkedMessageIdSequenceMap.get((Object)((MessageIdImpl)messageId));
            if (chunkedMsgIds != null && chunkedMsgIds.length > 0) {
                Collections.addAll(messageIds, chunkedMsgIds);
            }
            consumerBase.unAckedChunkedMessageIdSequenceMap.remove((Object)((MessageIdImpl)messageId));
        }
    }

    public void clear() {
        this.writeLock.lock();
        try {
            this.messageIdPartitionMap.clear();
            this.timePartitions.forEach((Consumer<ConcurrentOpenHashSet<MessageId>>)((Consumer<ConcurrentOpenHashSet>)tp -> tp.clear()));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(MessageId messageId) {
        this.writeLock.lock();
        try {
            ConcurrentOpenHashSet<MessageId> partition = this.timePartitions.peekLast();
            ConcurrentOpenHashSet<MessageId> previousPartition = this.messageIdPartitionMap.putIfAbsent(messageId, partition);
            if (previousPartition == null) {
                boolean bl = partition.add((Object)messageId);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.messageIdPartitionMap.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(MessageId messageId) {
        this.writeLock.lock();
        try {
            boolean removed = false;
            ConcurrentOpenHashSet<MessageId> exist = this.messageIdPartitionMap.remove(messageId);
            if (exist != null) {
                removed = exist.remove((Object)messageId);
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    long size() {
        this.readLock.lock();
        try {
            long l = this.messageIdPartitionMap.size();
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeMessagesTill(MessageId msgId) {
        this.writeLock.lock();
        try {
            int removed = 0;
            Iterator iterator = ((ConcurrentHashMap.KeySetView)this.messageIdPartitionMap.keySet()).iterator();
            while (iterator.hasNext()) {
                MessageId messageId = (MessageId)iterator.next();
                if (messageId.compareTo((Object)msgId) > 0) continue;
                ConcurrentOpenHashSet<MessageId> exist = this.messageIdPartitionMap.get(messageId);
                if (exist != null) {
                    exist.remove((Object)messageId);
                }
                iterator.remove();
                ++removed;
            }
            int n = removed;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void stop() {
        this.writeLock.lock();
        try {
            if (this.timeout != null && !this.timeout.isCancelled()) {
                this.timeout.cancel();
                this.timeout = null;
            }
            this.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    private static class UnAckedMessageTrackerDisabled
    extends UnAckedMessageTracker {
        private UnAckedMessageTrackerDisabled() {
        }

        @Override
        public void clear() {
        }

        @Override
        long size() {
            return 0L;
        }

        @Override
        public boolean add(MessageId m) {
            return true;
        }

        @Override
        public boolean remove(MessageId m) {
            return true;
        }

        @Override
        public int removeMessagesTill(MessageId msgId) {
            return 0;
        }

        @Override
        public void close() {
        }
    }
}

