/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.spnego;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.sun.security.auth.module.Krb5LoginModule;
import io.airlift.http.client.KerberosNameType;
import io.airlift.http.client.spnego.UriUtil;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.io.File;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.Principal;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.Attributes;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SpnegoAuthentication
implements Authentication {
    private static final String NEGOTIATE = HttpHeader.NEGOTIATE.asString();
    private static final Logger LOG = Logger.get(SpnegoAuthentication.class);
    private static final Duration MIN_CREDENTIAL_LIFE_TIME = new Duration(60.0, TimeUnit.SECONDS);
    private static final GSSManager GSS_MANAGER = GSSManager.getInstance();
    private static final Oid SPNEGO_OID;
    private static final Oid KERBEROS_OID;
    private static final RetryPolicy<?> AUTHENTICATION_RETRY_POLICY;
    private final File keytab;
    private final File credentialCache;
    private final String servicePrincipalPattern;
    private final String principal;
    private final String remoteServiceName;
    private final boolean useCanonicalHostname;
    private final Oid nameType;
    @GuardedBy(value="this")
    private Session clientSession;

    public SpnegoAuthentication(File keytab, File kerberosConfig, File credentialCache, String servicePrincipalPattern, String principal, String remoteServiceName, KerberosNameType nameType, boolean useCanonicalHostname) {
        Objects.requireNonNull(kerberosConfig, "Kerberos config path is null");
        Objects.requireNonNull(remoteServiceName, "Kerberos remote service name is null");
        Objects.requireNonNull(nameType, "GSS name type is null");
        this.keytab = keytab;
        this.credentialCache = credentialCache;
        this.servicePrincipalPattern = servicePrincipalPattern;
        this.principal = principal;
        this.remoteServiceName = remoteServiceName;
        this.nameType = nameType.getOid();
        this.useCanonicalHostname = useCanonicalHostname;
        System.setProperty("java.security.krb5.conf", kerberosConfig.getAbsolutePath());
    }

    public Authentication.Result authenticate(Request request, ContentResponse response, final Authentication.HeaderInfo headerInfo, Attributes attributes) {
        final URI normalizedUri = UriUtil.normalizedUri(request.getURI());
        return new Authentication.Result(){

            public URI getURI() {
                return normalizedUri;
            }

            public void apply(Request request) {
                Failsafe.with((Policy[])new RetryPolicy[]{AUTHENTICATION_RETRY_POLICY}).run(() -> this.authenticate(request));
            }

            private void authenticate(Request request) {
                block12: {
                    GSSContext context = null;
                    try {
                        String servicePrincipal = SpnegoAuthentication.makeServicePrincipal(SpnegoAuthentication.this.servicePrincipalPattern, SpnegoAuthentication.this.remoteServiceName, normalizedUri.getHost(), SpnegoAuthentication.this.useCanonicalHostname);
                        Session session = SpnegoAuthentication.this.getSession();
                        context = (GSSContext)SpnegoAuthentication.doAs(session.getLoginContext().getSubject(), () -> {
                            GSSContext result = GSS_MANAGER.createContext(GSS_MANAGER.createName(servicePrincipal, SpnegoAuthentication.this.nameType), SPNEGO_OID, session.getClientCredential(), Integer.MAX_VALUE);
                            result.requestMutualAuth(true);
                            result.requestConf(true);
                            result.requestInteg(true);
                            result.requestCredDeleg(false);
                            return result;
                        });
                        byte[] token = context.initSecContext(new byte[0], 0, 0);
                        if (token != null) {
                            request.header(headerInfo.getHeader(), String.format("%s %s", NEGOTIATE, Base64.getEncoder().encodeToString(token)));
                            break block12;
                        }
                        throw new RuntimeException(String.format("No token generated from GSS context for %s", request.getURI()));
                    }
                    catch (GSSException e) {
                        throw new RuntimeException(String.format("Failed to establish GSSContext for request %s", request.getURI()), e);
                    }
                    catch (LoginException e) {
                        throw new RuntimeException(String.format("Failed to establish LoginContext for request %s", request.getURI()), e);
                    }
                    finally {
                        try {
                            if (context != null) {
                                context.dispose();
                            }
                        }
                        catch (GSSException gSSException) {}
                    }
                }
            }
        };
    }

    private static boolean isNetworkIssue(Throwable throwable) {
        return Throwables.getCausalChain((Throwable)throwable).stream().anyMatch(SocketException.class::isInstance);
    }

    public boolean matches(String type, URI uri, String realm) {
        return NEGOTIATE.equalsIgnoreCase(type);
    }

    private synchronized Session getSession() throws LoginException, GSSException {
        if (this.clientSession == null || (double)this.clientSession.getClientCredential().getRemainingLifetime() < MIN_CREDENTIAL_LIFE_TIME.getValue(TimeUnit.SECONDS)) {
            LoginContext loginContext = new LoginContext("", null, null, new Configuration(){

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                    ImmutableMap.Builder optionsBuilder = ImmutableMap.builder();
                    optionsBuilder.put((Object)"refreshKrb5Config", (Object)"true");
                    optionsBuilder.put((Object)"doNotPrompt", (Object)"true");
                    optionsBuilder.put((Object)"useKeyTab", (Object)"true");
                    if (LOG.isDebugEnabled()) {
                        optionsBuilder.put((Object)"debug", (Object)"true");
                    }
                    if (SpnegoAuthentication.this.keytab != null) {
                        optionsBuilder.put((Object)"keyTab", (Object)SpnegoAuthentication.this.keytab.getAbsolutePath());
                    }
                    if (SpnegoAuthentication.this.credentialCache != null) {
                        optionsBuilder.put((Object)"ticketCache", (Object)SpnegoAuthentication.this.credentialCache.getAbsolutePath());
                        optionsBuilder.put((Object)"useTicketCache", (Object)"true");
                        optionsBuilder.put((Object)"renewTGT", (Object)"true");
                    }
                    if (SpnegoAuthentication.this.principal != null) {
                        optionsBuilder.put((Object)"principal", (Object)SpnegoAuthentication.this.principal);
                    }
                    return new AppConfigurationEntry[]{new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, (Map<String, ?>)optionsBuilder.build())};
                }
            });
            loginContext.login();
            Subject subject = loginContext.getSubject();
            Principal clientPrincipal = subject.getPrincipals().iterator().next();
            GSSCredential clientCredential = SpnegoAuthentication.doAs(subject, () -> GSS_MANAGER.createCredential(GSS_MANAGER.createName(clientPrincipal.getName(), GSSName.NT_USER_NAME), 0, KERBEROS_OID, 1));
            this.clientSession = new Session(loginContext, clientCredential);
        }
        return this.clientSession;
    }

    private static String makeServicePrincipal(String servicePrincipalPattern, String serviceName, String hostName, boolean useCanonicalHostname) {
        String serviceHostName = hostName;
        if (useCanonicalHostname) {
            serviceHostName = SpnegoAuthentication.canonicalizeServiceHostname(hostName);
        }
        return servicePrincipalPattern.replaceAll("\\$\\{SERVICE}", serviceName).replaceAll("\\$\\{HOST}", serviceHostName.toLowerCase(Locale.US));
    }

    private static String canonicalizeServiceHostname(String hostName) {
        try {
            InetAddress address = InetAddress.getByName(hostName);
            String fullHostName = "localhost".equalsIgnoreCase(address.getHostName()) ? InetAddress.getLocalHost().getCanonicalHostName() : address.getCanonicalHostName();
            return fullHostName;
        }
        catch (UnknownHostException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static <T> T doAs(Subject subject, GssSupplier<T> action) {
        return (T)Subject.doAs(subject, () -> {
            try {
                return action.get();
            }
            catch (GSSException e) {
                throw new RuntimeException(e);
            }
        });
    }

    static {
        try {
            SPNEGO_OID = new Oid("1.3.6.1.5.5.2");
            KERBEROS_OID = new Oid("1.2.840.113554.1.2.2");
        }
        catch (GSSException e) {
            throw new AssertionError((Object)e);
        }
        AUTHENTICATION_RETRY_POLICY = ((RetryPolicy)new RetryPolicy().withBackoff(1L, 5L, ChronoUnit.SECONDS).withMaxRetries(5).handleIf(SpnegoAuthentication::isNetworkIssue)).onRetry(event -> LOG.debug("Authentication failed on attempt %s, will retry. Exception: %s", new Object[]{event.getAttemptCount(), event.getLastFailure().getMessage()}));
    }

    private static class Session {
        private final LoginContext loginContext;
        private final GSSCredential clientCredential;

        Session(LoginContext loginContext, GSSCredential clientCredential) {
            Objects.requireNonNull(loginContext, "loginContext is null");
            Objects.requireNonNull(clientCredential, "gssCredential is null");
            this.loginContext = loginContext;
            this.clientCredential = clientCredential;
        }

        LoginContext getLoginContext() {
            return this.loginContext;
        }

        GSSCredential getClientCredential() {
            return this.clientCredential;
        }
    }

    private static interface GssSupplier<T> {
        public T get() throws GSSException;
    }
}

